<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden proposities.
 * @subpackage Structs
 * @date 20240419 package
 */
class PropositieInfo extends AbstractStructBase
{
    /**
     * The proposities
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden proposities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Proposities[]
     */
    public $proposities;
    /**
     * Constructor method for PropositieInfo
     * @uses PropositieInfo::setProposities()
     * @param \AbonnementApiV6\StructType\Proposities[] $proposities
     */
    public function __construct(array $proposities = array())
    {
        $this
            ->setProposities($proposities);
    }
    /**
     * Get proposities value
     * @return \AbonnementApiV6\StructType\Proposities[]|null
     */
    public function getProposities()
    {
        return $this->proposities;
    }
    /**
     * This method is responsible for validating the values passed to the setProposities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProposities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropositiesForArrayConstraintsFromSetProposities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propositieInfoPropositiesItem) {
            // validation for constraint: itemType
            if (!$propositieInfoPropositiesItem instanceof \AbonnementApiV6\StructType\Proposities) {
                $invalidValues[] = is_object($propositieInfoPropositiesItem) ? get_class($propositieInfoPropositiesItem) : sprintf('%s(%s)', gettype($propositieInfoPropositiesItem), var_export($propositieInfoPropositiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proposities property can only contain items of type \AbonnementApiV6\StructType\Proposities, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proposities value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Proposities[] $proposities
     * @return \AbonnementApiV6\StructType\PropositieInfo
     */
    public function setProposities(array $proposities = array())
    {
        // validation for constraint: array
        if ('' !== ($propositiesArrayErrorMessage = self::validatePropositiesForArrayConstraintsFromSetProposities($proposities))) {
            throw new \InvalidArgumentException($propositiesArrayErrorMessage, __LINE__);
        }
        $this->proposities = $proposities;
        return $this;
    }
    /**
     * Add item to proposities value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Proposities $item
     * @return \AbonnementApiV6\StructType\PropositieInfo
     */
    public function addToProposities(\AbonnementApiV6\StructType\Proposities $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Proposities) {
            throw new \InvalidArgumentException(sprintf('The proposities property can only contain items of type \AbonnementApiV6\StructType\Proposities, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->proposities[] = $item;
        return $this;
    }
}
