<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeverbareProductenInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met leverbare producten (uitgaven).
 * @subpackage Structs
 * @date 20240419 package
 */
class LeverbareProductenInfo extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta information extracted from the WSDL
     * - documentation: Lijst met leverbare producten (uitgaven).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\UitgaveObject[]
     */
    public $uitgave;
    /**
     * Constructor method for LeverbareProductenInfo
     * @uses LeverbareProductenInfo::setUitgave()
     * @param \AbonnementApiV6\StructType\UitgaveObject[] $uitgave
     */
    public function __construct(array $uitgave = array())
    {
        $this
            ->setUitgave($uitgave);
    }
    /**
     * Get uitgave value
     * @return \AbonnementApiV6\StructType\UitgaveObject[]|null
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * This method is responsible for validating the values passed to the setUitgave method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUitgave method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUitgaveForArrayConstraintsFromSetUitgave(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leverbareProductenInfoUitgaveItem) {
            // validation for constraint: itemType
            if (!$leverbareProductenInfoUitgaveItem instanceof \AbonnementApiV6\StructType\UitgaveObject) {
                $invalidValues[] = is_object($leverbareProductenInfoUitgaveItem) ? get_class($leverbareProductenInfoUitgaveItem) : sprintf('%s(%s)', gettype($leverbareProductenInfoUitgaveItem), var_export($leverbareProductenInfoUitgaveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uitgave property can only contain items of type \AbonnementApiV6\StructType\UitgaveObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uitgave value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\UitgaveObject[] $uitgave
     * @return \AbonnementApiV6\StructType\LeverbareProductenInfo
     */
    public function setUitgave(array $uitgave = array())
    {
        // validation for constraint: array
        if ('' !== ($uitgaveArrayErrorMessage = self::validateUitgaveForArrayConstraintsFromSetUitgave($uitgave))) {
            throw new \InvalidArgumentException($uitgaveArrayErrorMessage, __LINE__);
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Add item to uitgave value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\UitgaveObject $item
     * @return \AbonnementApiV6\StructType\LeverbareProductenInfo
     */
    public function addToUitgave(\AbonnementApiV6\StructType\UitgaveObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\UitgaveObject) {
            throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of type \AbonnementApiV6\StructType\UitgaveObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uitgave[] = $item;
        return $this;
    }
}
