<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Klacht StructType
 * Meta information extracted from the WSDL
 * - documentation: Klacht informatie.
 * @subpackage Structs
 * @date 20240419 package
 */
class Klacht extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The klachtErnstig
     * Meta information extracted from the WSDL
     * - documentation: Indicatie ernstige klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtErnstig;
    /**
     * The klachtHerhaald
     * Meta information extracted from the WSDL
     * - documentation: Indicatie herhaalde klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtHerhaald;
    /**
     * The klachtNo
     * Meta information extracted from the WSDL
     * - documentation: Klachtnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The klachtOnderwerpCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het klachtonderwerp.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtOnderwerpCode;
    /**
     * The klachtOnderwerpOmschr
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het klachtonderwerp.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtOnderwerpOmschr;
    /**
     * The klachtSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de klachtsoort.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtSoortCode;
    /**
     * The klachtSoortOmschr
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de klachtsoort.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtSoortOmschr;
    /**
     * The klachtToelichting
     * Meta information extracted from the WSDL
     * - documentation: Toelichting bij de klacht.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtVerschDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum waarover geklaagd is. Dit is in het systeem de verschijningsdatum van een editie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtVerschDatum;
    /**
     * The meldDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum van de klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $meldDatum;
    /**
     * The klachtStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de klachtstatus.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtStatusCode;
    /**
     * The klachtStatusOmschr
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de klachtstatus.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtStatusOmschr;
    /**
     * The canCancel
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of deze klacht geannuleerd mag worden, als de abonnee vindt dat het bij nader inzien een onterechte klacht is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCancel;
    /**
     * The klachtAfgehandeld
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of de klacht is afgehandeld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtAfgehandeld;
    /**
     * The klachtNazenden
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of er gaat worden nagezonden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtNazenden;
    /**
     * The klachtCompenseren
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of het abonnement van de klacht ter compensatie verlengd is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtCompenseren;
    /**
     * Constructor method for Klacht
     * @uses Klacht::setAboNo()
     * @uses Klacht::setKlachtErnstig()
     * @uses Klacht::setKlachtHerhaald()
     * @uses Klacht::setKlachtNo()
     * @uses Klacht::setKlachtOnderwerpCode()
     * @uses Klacht::setKlachtOnderwerpOmschr()
     * @uses Klacht::setKlachtSoortCode()
     * @uses Klacht::setKlachtSoortOmschr()
     * @uses Klacht::setKlachtToelichting()
     * @uses Klacht::setKlachtVerschDatum()
     * @uses Klacht::setMeldDatum()
     * @uses Klacht::setKlachtStatusCode()
     * @uses Klacht::setKlachtStatusOmschr()
     * @uses Klacht::setCanCancel()
     * @uses Klacht::setKlachtAfgehandeld()
     * @uses Klacht::setKlachtNazenden()
     * @uses Klacht::setKlachtCompenseren()
     * @param int $aboNo
     * @param bool $klachtErnstig
     * @param bool $klachtHerhaald
     * @param int $klachtNo
     * @param string $klachtOnderwerpCode
     * @param string $klachtOnderwerpOmschr
     * @param string $klachtSoortCode
     * @param string $klachtSoortOmschr
     * @param string $klachtToelichting
     * @param string $klachtVerschDatum
     * @param string $meldDatum
     * @param string $klachtStatusCode
     * @param string $klachtStatusOmschr
     * @param bool $canCancel
     * @param bool $klachtAfgehandeld
     * @param bool $klachtNazenden
     * @param bool $klachtCompenseren
     */
    public function __construct($aboNo = null, $klachtErnstig = null, $klachtHerhaald = null, $klachtNo = null, $klachtOnderwerpCode = null, $klachtOnderwerpOmschr = null, $klachtSoortCode = null, $klachtSoortOmschr = null, $klachtToelichting = null, $klachtVerschDatum = null, $meldDatum = null, $klachtStatusCode = null, $klachtStatusOmschr = null, $canCancel = null, $klachtAfgehandeld = null, $klachtNazenden = null, $klachtCompenseren = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setKlachtErnstig($klachtErnstig)
            ->setKlachtHerhaald($klachtHerhaald)
            ->setKlachtNo($klachtNo)
            ->setKlachtOnderwerpCode($klachtOnderwerpCode)
            ->setKlachtOnderwerpOmschr($klachtOnderwerpOmschr)
            ->setKlachtSoortCode($klachtSoortCode)
            ->setKlachtSoortOmschr($klachtSoortOmschr)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtVerschDatum($klachtVerschDatum)
            ->setMeldDatum($meldDatum)
            ->setKlachtStatusCode($klachtStatusCode)
            ->setKlachtStatusOmschr($klachtStatusOmschr)
            ->setCanCancel($canCancel)
            ->setKlachtAfgehandeld($klachtAfgehandeld)
            ->setKlachtNazenden($klachtNazenden)
            ->setKlachtCompenseren($klachtCompenseren);
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get klachtErnstig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtErnstig()
    {
        return isset($this->klachtErnstig) ? $this->klachtErnstig : null;
    }
    /**
     * Set klachtErnstig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtErnstig
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtErnstig($klachtErnstig = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtErnstig) && !is_bool($klachtErnstig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtErnstig, true), gettype($klachtErnstig)), __LINE__);
        }
        if (is_null($klachtErnstig) || (is_array($klachtErnstig) && empty($klachtErnstig))) {
            unset($this->klachtErnstig);
        } else {
            $this->klachtErnstig = $klachtErnstig;
        }
        return $this;
    }
    /**
     * Get klachtHerhaald value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtHerhaald()
    {
        return isset($this->klachtHerhaald) ? $this->klachtHerhaald : null;
    }
    /**
     * Set klachtHerhaald value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtHerhaald
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtHerhaald($klachtHerhaald = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtHerhaald) && !is_bool($klachtHerhaald)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtHerhaald, true), gettype($klachtHerhaald)), __LINE__);
        }
        if (is_null($klachtHerhaald) || (is_array($klachtHerhaald) && empty($klachtHerhaald))) {
            unset($this->klachtHerhaald);
        } else {
            $this->klachtHerhaald = $klachtHerhaald;
        }
        return $this;
    }
    /**
     * Get klachtNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKlachtNo()
    {
        return isset($this->klachtNo) ? $this->klachtNo : null;
    }
    /**
     * Set klachtNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $klachtNo
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: int
        if (!is_null($klachtNo) && !(is_int($klachtNo) || ctype_digit($klachtNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($klachtNo, true), gettype($klachtNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($klachtNo) && mb_strlen(preg_replace('/(\D)/', '', $klachtNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($klachtNo, true), mb_strlen(preg_replace('/(\D)/', '', $klachtNo))), __LINE__);
        }
        if (is_null($klachtNo) || (is_array($klachtNo) && empty($klachtNo))) {
            unset($this->klachtNo);
        } else {
            $this->klachtNo = $klachtNo;
        }
        return $this;
    }
    /**
     * Get klachtOnderwerpCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtOnderwerpCode()
    {
        return isset($this->klachtOnderwerpCode) ? $this->klachtOnderwerpCode : null;
    }
    /**
     * Set klachtOnderwerpCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtOnderwerpCode
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtOnderwerpCode($klachtOnderwerpCode = null)
    {
        // validation for constraint: string
        if (!is_null($klachtOnderwerpCode) && !is_string($klachtOnderwerpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtOnderwerpCode, true), gettype($klachtOnderwerpCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($klachtOnderwerpCode) && mb_strlen($klachtOnderwerpCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($klachtOnderwerpCode)), __LINE__);
        }
        if (is_null($klachtOnderwerpCode) || (is_array($klachtOnderwerpCode) && empty($klachtOnderwerpCode))) {
            unset($this->klachtOnderwerpCode);
        } else {
            $this->klachtOnderwerpCode = $klachtOnderwerpCode;
        }
        return $this;
    }
    /**
     * Get klachtOnderwerpOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtOnderwerpOmschr()
    {
        return isset($this->klachtOnderwerpOmschr) ? $this->klachtOnderwerpOmschr : null;
    }
    /**
     * Set klachtOnderwerpOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtOnderwerpOmschr
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtOnderwerpOmschr($klachtOnderwerpOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($klachtOnderwerpOmschr) && !is_string($klachtOnderwerpOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtOnderwerpOmschr, true), gettype($klachtOnderwerpOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($klachtOnderwerpOmschr) && mb_strlen($klachtOnderwerpOmschr) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($klachtOnderwerpOmschr)), __LINE__);
        }
        if (is_null($klachtOnderwerpOmschr) || (is_array($klachtOnderwerpOmschr) && empty($klachtOnderwerpOmschr))) {
            unset($this->klachtOnderwerpOmschr);
        } else {
            $this->klachtOnderwerpOmschr = $klachtOnderwerpOmschr;
        }
        return $this;
    }
    /**
     * Get klachtSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtSoortCode()
    {
        return isset($this->klachtSoortCode) ? $this->klachtSoortCode : null;
    }
    /**
     * Set klachtSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtSoortCode
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtSoortCode($klachtSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($klachtSoortCode) && !is_string($klachtSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtSoortCode, true), gettype($klachtSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($klachtSoortCode) && mb_strlen($klachtSoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($klachtSoortCode)), __LINE__);
        }
        if (is_null($klachtSoortCode) || (is_array($klachtSoortCode) && empty($klachtSoortCode))) {
            unset($this->klachtSoortCode);
        } else {
            $this->klachtSoortCode = $klachtSoortCode;
        }
        return $this;
    }
    /**
     * Get klachtSoortOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtSoortOmschr()
    {
        return isset($this->klachtSoortOmschr) ? $this->klachtSoortOmschr : null;
    }
    /**
     * Set klachtSoortOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtSoortOmschr
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtSoortOmschr($klachtSoortOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($klachtSoortOmschr) && !is_string($klachtSoortOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtSoortOmschr, true), gettype($klachtSoortOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($klachtSoortOmschr) && mb_strlen($klachtSoortOmschr) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($klachtSoortOmschr)), __LINE__);
        }
        if (is_null($klachtSoortOmschr) || (is_array($klachtSoortOmschr) && empty($klachtSoortOmschr))) {
            unset($this->klachtSoortOmschr);
        } else {
            $this->klachtSoortOmschr = $klachtSoortOmschr;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtToelichting, true), gettype($klachtToelichting)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($klachtToelichting) && mb_strlen($klachtToelichting) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtVerschDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtVerschDatum()
    {
        return isset($this->klachtVerschDatum) ? $this->klachtVerschDatum : null;
    }
    /**
     * Set klachtVerschDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtVerschDatum
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtVerschDatum($klachtVerschDatum = null)
    {
        // validation for constraint: string
        if (!is_null($klachtVerschDatum) && !is_string($klachtVerschDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtVerschDatum, true), gettype($klachtVerschDatum)), __LINE__);
        }
        if (is_null($klachtVerschDatum) || (is_array($klachtVerschDatum) && empty($klachtVerschDatum))) {
            unset($this->klachtVerschDatum);
        } else {
            $this->klachtVerschDatum = $klachtVerschDatum;
        }
        return $this;
    }
    /**
     * Get meldDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeldDatum()
    {
        return isset($this->meldDatum) ? $this->meldDatum : null;
    }
    /**
     * Set meldDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $meldDatum
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setMeldDatum($meldDatum = null)
    {
        // validation for constraint: string
        if (!is_null($meldDatum) && !is_string($meldDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldDatum, true), gettype($meldDatum)), __LINE__);
        }
        if (is_null($meldDatum) || (is_array($meldDatum) && empty($meldDatum))) {
            unset($this->meldDatum);
        } else {
            $this->meldDatum = $meldDatum;
        }
        return $this;
    }
    /**
     * Get klachtStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtStatusCode()
    {
        return isset($this->klachtStatusCode) ? $this->klachtStatusCode : null;
    }
    /**
     * Set klachtStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtStatusCode
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtStatusCode($klachtStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($klachtStatusCode) && !is_string($klachtStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtStatusCode, true), gettype($klachtStatusCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($klachtStatusCode) && mb_strlen($klachtStatusCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($klachtStatusCode)), __LINE__);
        }
        if (is_null($klachtStatusCode) || (is_array($klachtStatusCode) && empty($klachtStatusCode))) {
            unset($this->klachtStatusCode);
        } else {
            $this->klachtStatusCode = $klachtStatusCode;
        }
        return $this;
    }
    /**
     * Get klachtStatusOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtStatusOmschr()
    {
        return isset($this->klachtStatusOmschr) ? $this->klachtStatusOmschr : null;
    }
    /**
     * Set klachtStatusOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtStatusOmschr
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtStatusOmschr($klachtStatusOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($klachtStatusOmschr) && !is_string($klachtStatusOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtStatusOmschr, true), gettype($klachtStatusOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($klachtStatusOmschr) && mb_strlen($klachtStatusOmschr) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($klachtStatusOmschr)), __LINE__);
        }
        if (is_null($klachtStatusOmschr) || (is_array($klachtStatusOmschr) && empty($klachtStatusOmschr))) {
            unset($this->klachtStatusOmschr);
        } else {
            $this->klachtStatusOmschr = $klachtStatusOmschr;
        }
        return $this;
    }
    /**
     * Get canCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCancel()
    {
        return isset($this->canCancel) ? $this->canCancel : null;
    }
    /**
     * Set canCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCancel
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setCanCancel($canCancel = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCancel) && !is_bool($canCancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCancel, true), gettype($canCancel)), __LINE__);
        }
        if (is_null($canCancel) || (is_array($canCancel) && empty($canCancel))) {
            unset($this->canCancel);
        } else {
            $this->canCancel = $canCancel;
        }
        return $this;
    }
    /**
     * Get klachtAfgehandeld value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtAfgehandeld()
    {
        return isset($this->klachtAfgehandeld) ? $this->klachtAfgehandeld : null;
    }
    /**
     * Set klachtAfgehandeld value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtAfgehandeld
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtAfgehandeld($klachtAfgehandeld = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtAfgehandeld) && !is_bool($klachtAfgehandeld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtAfgehandeld, true), gettype($klachtAfgehandeld)), __LINE__);
        }
        if (is_null($klachtAfgehandeld) || (is_array($klachtAfgehandeld) && empty($klachtAfgehandeld))) {
            unset($this->klachtAfgehandeld);
        } else {
            $this->klachtAfgehandeld = $klachtAfgehandeld;
        }
        return $this;
    }
    /**
     * Get klachtNazenden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtNazenden()
    {
        return isset($this->klachtNazenden) ? $this->klachtNazenden : null;
    }
    /**
     * Set klachtNazenden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtNazenden
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtNazenden($klachtNazenden = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtNazenden) && !is_bool($klachtNazenden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtNazenden, true), gettype($klachtNazenden)), __LINE__);
        }
        if (is_null($klachtNazenden) || (is_array($klachtNazenden) && empty($klachtNazenden))) {
            unset($this->klachtNazenden);
        } else {
            $this->klachtNazenden = $klachtNazenden;
        }
        return $this;
    }
    /**
     * Get klachtCompenseren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtCompenseren()
    {
        return isset($this->klachtCompenseren) ? $this->klachtCompenseren : null;
    }
    /**
     * Set klachtCompenseren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtCompenseren
     * @return \AbonnementApiV6\StructType\Klacht
     */
    public function setKlachtCompenseren($klachtCompenseren = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtCompenseren) && !is_bool($klachtCompenseren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtCompenseren, true), gettype($klachtCompenseren)), __LINE__);
        }
        if (is_null($klachtCompenseren) || (is_array($klachtCompenseren) && empty($klachtCompenseren))) {
            unset($this->klachtCompenseren);
        } else {
            $this->klachtCompenseren = $klachtCompenseren;
        }
        return $this;
    }
}
