<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSmartcodeByAboNoResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error266: Op basis van het abonnement is geen smartcode gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetSmartcodeByAboNoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The smartcode
     * Meta information extracted from the WSDL
     * - documentation: De opgevraagde smartcode.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $smartcode;
    /**
     * Constructor method for getSmartcodeByAboNoResponse
     * @uses GetSmartcodeByAboNoResponse::setRequestTag()
     * @uses GetSmartcodeByAboNoResponse::setSmartcode()
     * @param string $requestTag
     * @param string $smartcode
     */
    public function __construct($requestTag = null, $smartcode = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setSmartcode($smartcode);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetSmartcodeByAboNoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get smartcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmartcode()
    {
        return isset($this->smartcode) ? $this->smartcode : null;
    }
    /**
     * Set smartcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smartcode
     * @return \AbonnementApiV6\StructType\GetSmartcodeByAboNoResponse
     */
    public function setSmartcode($smartcode = null)
    {
        // validation for constraint: string
        if (!is_null($smartcode) && !is_string($smartcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smartcode, true), gettype($smartcode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($smartcode) && mb_strlen($smartcode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($smartcode)), __LINE__);
        }
        if (is_null($smartcode) || (is_array($smartcode) && empty($smartcode))) {
            unset($this->smartcode);
        } else {
            $this->smartcode = $smartcode;
        }
        return $this;
    }
}
