<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieAbosoortPrijsResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error93: De abonnee is niet gevonden | error92: De abonnementsoort is niet bekend | error21: De debiteur is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetRelatieAbosoortPrijsResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The prijsExclBtw
     * Meta information extracted from the WSDL
     * - documentation: De prijs excl. BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsExclBtwPerStuk
     * Meta information extracted from the WSDL
     * - documentation: De prijs excl. BTW per stuk.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtwPerStuk;
    /**
     * The kortingStaffelBedr
     * Meta information extracted from the WSDL
     * - documentation: Het bedrag aan eventuele staffelkorting dat geldt voor het gegeven aantal exemplaren.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelBedr;
    /**
     * The kortingStaffelPerc
     * Meta information extracted from the WSDL
     * - documentation: Het percentage aan eventuele staffelkorting die geldt voor het gegeven aantal exemplaren.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelPerc;
    /**
     * The kortingPrijsmatrixBedr
     * Meta information extracted from the WSDL
     * - documentation: Het eventuele kortingsbedrag die geldt volgens de prijsmatrix.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrixBedr;
    /**
     * The kortingPrijsmatrixPerc
     * Meta information extracted from the WSDL
     * - documentation: Het eventuele kortingspercentage die geldt volgens de prijsmatrix.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrixPerc;
    /**
     * The kortingPrijsmatrixOmschr
     * Meta information extracted from the WSDL
     * - documentation: De omschrijving van de reden van de korting volgens de prijsmatrix.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingPrijsmatrixOmschr;
    /**
     * The btwPerc
     * Meta information extracted from the WSDL
     * - documentation: Het BTW percentage dat geldt voor de debiteur.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwPerc;
    /**
     * The btwBedr
     * Meta information extracted from the WSDL
     * - documentation: het bedrag aan BTW dat geldt voor de debiteur.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $btwBedr;
    /**
     * Constructor method for getRelatieAbosoortPrijsResponse
     * @uses GetRelatieAbosoortPrijsResponse::setRequestTag()
     * @uses GetRelatieAbosoortPrijsResponse::setPrijsExclBtw()
     * @uses GetRelatieAbosoortPrijsResponse::setPrijsExclBtwPerStuk()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingStaffelBedr()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingStaffelPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixBedr()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setKortingPrijsmatrixOmschr()
     * @uses GetRelatieAbosoortPrijsResponse::setBtwPerc()
     * @uses GetRelatieAbosoortPrijsResponse::setBtwBedr()
     * @param string $requestTag
     * @param float $prijsExclBtw
     * @param float $prijsExclBtwPerStuk
     * @param float $kortingStaffelBedr
     * @param float $kortingStaffelPerc
     * @param float $kortingPrijsmatrixBedr
     * @param float $kortingPrijsmatrixPerc
     * @param string $kortingPrijsmatrixOmschr
     * @param float $btwPerc
     * @param float $btwBedr
     */
    public function __construct($requestTag = null, $prijsExclBtw = null, $prijsExclBtwPerStuk = null, $kortingStaffelBedr = null, $kortingStaffelPerc = null, $kortingPrijsmatrixBedr = null, $kortingPrijsmatrixPerc = null, $kortingPrijsmatrixOmschr = null, $btwPerc = null, $btwBedr = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsExclBtwPerStuk($prijsExclBtwPerStuk)
            ->setKortingStaffelBedr($kortingStaffelBedr)
            ->setKortingStaffelPerc($kortingStaffelPerc)
            ->setKortingPrijsmatrixBedr($kortingPrijsmatrixBedr)
            ->setKortingPrijsmatrixPerc($kortingPrijsmatrixPerc)
            ->setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr)
            ->setBtwPerc($btwPerc)
            ->setBtwBedr($btwBedr);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtw()
    {
        return isset($this->prijsExclBtw) ? $this->prijsExclBtw : null;
    }
    /**
     * Set prijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtw
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtw) && !(is_float($prijsExclBtw) || is_numeric($prijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtw, true), gettype($prijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw))), __LINE__);
        }
        if (is_null($prijsExclBtw) || (is_array($prijsExclBtw) && empty($prijsExclBtw))) {
            unset($this->prijsExclBtw);
        } else {
            $this->prijsExclBtw = $prijsExclBtw;
        }
        return $this;
    }
    /**
     * Get prijsExclBtwPerStuk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtwPerStuk()
    {
        return isset($this->prijsExclBtwPerStuk) ? $this->prijsExclBtwPerStuk : null;
    }
    /**
     * Set prijsExclBtwPerStuk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtwPerStuk
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setPrijsExclBtwPerStuk($prijsExclBtwPerStuk = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtwPerStuk) && !(is_float($prijsExclBtwPerStuk) || is_numeric($prijsExclBtwPerStuk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtwPerStuk, true), gettype($prijsExclBtwPerStuk)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtwPerStuk) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtwPerStuk)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtwPerStuk, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtwPerStuk))), __LINE__);
        }
        if (is_null($prijsExclBtwPerStuk) || (is_array($prijsExclBtwPerStuk) && empty($prijsExclBtwPerStuk))) {
            unset($this->prijsExclBtwPerStuk);
        } else {
            $this->prijsExclBtwPerStuk = $prijsExclBtwPerStuk;
        }
        return $this;
    }
    /**
     * Get kortingStaffelBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelBedr()
    {
        return isset($this->kortingStaffelBedr) ? $this->kortingStaffelBedr : null;
    }
    /**
     * Set kortingStaffelBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelBedr
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingStaffelBedr($kortingStaffelBedr = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelBedr) && !(is_float($kortingStaffelBedr) || is_numeric($kortingStaffelBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelBedr, true), gettype($kortingStaffelBedr)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffelBedr) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelBedr)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffelBedr, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelBedr))), __LINE__);
        }
        if (is_null($kortingStaffelBedr) || (is_array($kortingStaffelBedr) && empty($kortingStaffelBedr))) {
            unset($this->kortingStaffelBedr);
        } else {
            $this->kortingStaffelBedr = $kortingStaffelBedr;
        }
        return $this;
    }
    /**
     * Get kortingStaffelPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelPerc()
    {
        return isset($this->kortingStaffelPerc) ? $this->kortingStaffelPerc : null;
    }
    /**
     * Set kortingStaffelPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelPerc
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingStaffelPerc($kortingStaffelPerc = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelPerc) && !(is_float($kortingStaffelPerc) || is_numeric($kortingStaffelPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelPerc, true), gettype($kortingStaffelPerc)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffelPerc) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPerc)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffelPerc, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPerc))), __LINE__);
        }
        if (is_null($kortingStaffelPerc) || (is_array($kortingStaffelPerc) && empty($kortingStaffelPerc))) {
            unset($this->kortingStaffelPerc);
        } else {
            $this->kortingStaffelPerc = $kortingStaffelPerc;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixBedr()
    {
        return isset($this->kortingPrijsmatrixBedr) ? $this->kortingPrijsmatrixBedr : null;
    }
    /**
     * Set kortingPrijsmatrixBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixBedr
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixBedr($kortingPrijsmatrixBedr = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixBedr) && !(is_float($kortingPrijsmatrixBedr) || is_numeric($kortingPrijsmatrixBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixBedr, true), gettype($kortingPrijsmatrixBedr)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPrijsmatrixBedr) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixBedr)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPrijsmatrixBedr, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixBedr))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixBedr) || (is_array($kortingPrijsmatrixBedr) && empty($kortingPrijsmatrixBedr))) {
            unset($this->kortingPrijsmatrixBedr);
        } else {
            $this->kortingPrijsmatrixBedr = $kortingPrijsmatrixBedr;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixPerc()
    {
        return isset($this->kortingPrijsmatrixPerc) ? $this->kortingPrijsmatrixPerc : null;
    }
    /**
     * Set kortingPrijsmatrixPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixPerc
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixPerc($kortingPrijsmatrixPerc = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixPerc) && !(is_float($kortingPrijsmatrixPerc) || is_numeric($kortingPrijsmatrixPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixPerc, true), gettype($kortingPrijsmatrixPerc)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPrijsmatrixPerc) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPerc)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPrijsmatrixPerc, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPerc))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixPerc) || (is_array($kortingPrijsmatrixPerc) && empty($kortingPrijsmatrixPerc))) {
            unset($this->kortingPrijsmatrixPerc);
        } else {
            $this->kortingPrijsmatrixPerc = $kortingPrijsmatrixPerc;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingPrijsmatrixOmschr()
    {
        return isset($this->kortingPrijsmatrixOmschr) ? $this->kortingPrijsmatrixOmschr : null;
    }
    /**
     * Set kortingPrijsmatrixOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingPrijsmatrixOmschr
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingPrijsmatrixOmschr) && !is_string($kortingPrijsmatrixOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingPrijsmatrixOmschr, true), gettype($kortingPrijsmatrixOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($kortingPrijsmatrixOmschr) && mb_strlen($kortingPrijsmatrixOmschr) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($kortingPrijsmatrixOmschr)), __LINE__);
        }
        if (is_null($kortingPrijsmatrixOmschr) || (is_array($kortingPrijsmatrixOmschr) && empty($kortingPrijsmatrixOmschr))) {
            unset($this->kortingPrijsmatrixOmschr);
        } else {
            $this->kortingPrijsmatrixOmschr = $kortingPrijsmatrixOmschr;
        }
        return $this;
    }
    /**
     * Get btwPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPerc()
    {
        return isset($this->btwPerc) ? $this->btwPerc : null;
    }
    /**
     * Set btwPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPerc
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setBtwPerc($btwPerc = null)
    {
        // validation for constraint: float
        if (!is_null($btwPerc) && !(is_float($btwPerc) || is_numeric($btwPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPerc, true), gettype($btwPerc)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwPerc) && mb_strlen(preg_replace('/(\D)/', '', $btwPerc)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwPerc, true), mb_strlen(preg_replace('/(\D)/', '', $btwPerc))), __LINE__);
        }
        if (is_null($btwPerc) || (is_array($btwPerc) && empty($btwPerc))) {
            unset($this->btwPerc);
        } else {
            $this->btwPerc = $btwPerc;
        }
        return $this;
    }
    /**
     * Get btwBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwBedr()
    {
        return isset($this->btwBedr) ? $this->btwBedr : null;
    }
    /**
     * Set btwBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwBedr
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse
     */
    public function setBtwBedr($btwBedr = null)
    {
        // validation for constraint: float
        if (!is_null($btwBedr) && !(is_float($btwBedr) || is_numeric($btwBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwBedr, true), gettype($btwBedr)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwBedr) && mb_strlen(preg_replace('/(\D)/', '', $btwBedr)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwBedr, true), mb_strlen(preg_replace('/(\D)/', '', $btwBedr))), __LINE__);
        }
        if (is_null($btwBedr) || (is_array($btwBedr) && empty($btwBedr))) {
            unset($this->btwBedr);
        } else {
            $this->btwBedr = $btwBedr;
        }
        return $this;
    }
}
