<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPakketInfoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van de gegevens van een of meerdere (abonnements) pakketten. Hierbij kan gezocht worden op basis van de pakketcode en op inactieve pakketten.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPakketInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The pakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het pakket waarvan de informatie wordt opgevraagd. Indien leeg wordt van alle pakketten de gegevens opgehaald.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * The inclusiefInactieve
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of inactieve pakketten teruggegeven moet worden. false (Default) = Alleen actieve. true = Inclusief inactieve.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactieve;
    /**
     * Constructor method for getPakketInfoRequest
     * @uses GetPakketInfoRequest::setRequestTag()
     * @uses GetPakketInfoRequest::setPakketCode()
     * @uses GetPakketInfoRequest::setInclusiefInactieve()
     * @param string $requestTag
     * @param string $pakketCode
     * @param bool $inclusiefInactieve
     */
    public function __construct($requestTag = null, $pakketCode = null, $inclusiefInactieve = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPakketCode($pakketCode)
            ->setInclusiefInactieve($inclusiefInactieve);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetPakketInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \AbonnementApiV6\StructType\GetPakketInfoRequest
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get inclusiefInactieve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactieve()
    {
        return isset($this->inclusiefInactieve) ? $this->inclusiefInactieve : null;
    }
    /**
     * Set inclusiefInactieve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactieve
     * @return \AbonnementApiV6\StructType\GetPakketInfoRequest
     */
    public function setInclusiefInactieve($inclusiefInactieve = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefInactieve) && !is_bool($inclusiefInactieve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefInactieve, true), gettype($inclusiefInactieve)), __LINE__);
        }
        if (is_null($inclusiefInactieve) || (is_array($inclusiefInactieve) && empty($inclusiefInactieve))) {
            unset($this->inclusiefInactieve);
        } else {
            $this->inclusiefInactieve = $inclusiefInactieve;
        }
        return $this;
    }
}
