<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getHerkomstInfoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft de herkomstcodes op die gelden voor een bepaalde uitgave
 * @subpackage Structs
 * @date 20240419 package
 */
class GetHerkomstInfoRequest extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave waarvan de herkomsten worden opgevraagd.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getHerkomstInfoRequest
     * @uses GetHerkomstInfoRequest::setUitgaveCode()
     * @uses GetHerkomstInfoRequest::setRequestTag()
     * @param string $uitgaveCode
     * @param string $requestTag
     */
    public function __construct($uitgaveCode = null, $requestTag = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\GetHerkomstInfoRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetHerkomstInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
