<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEersteVerschijningResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error254: De uitgave is niet gevonden op basis van de opgegeven uitgaveCode | error2: Het abonnement is niet gevonden op basis van de opgegeven aboNo
 * @subpackage Structs
 * @date 20240419 package
 */
class GetEersteVerschijningResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The editie
     * Meta information extracted from the WSDL
     * - documentation: De gevonden editie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\Editie
     */
    public $editie;
    /**
     * Constructor method for getEersteVerschijningResponse
     * @uses GetEersteVerschijningResponse::setRequestTag()
     * @uses GetEersteVerschijningResponse::setEditie()
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\Editie $editie
     */
    public function __construct($requestTag = null, \AbonnementApiV6\StructType\Editie $editie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setEditie($editie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetEersteVerschijningResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get editie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\Editie|null
     */
    public function getEditie()
    {
        return isset($this->editie) ? $this->editie : null;
    }
    /**
     * Set editie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\Editie $editie
     * @return \AbonnementApiV6\StructType\GetEersteVerschijningResponse
     */
    public function setEditie(\AbonnementApiV6\StructType\Editie $editie = null)
    {
        if (is_null($editie) || (is_array($editie) && empty($editie))) {
            unset($this->editie);
        } else {
            $this->editie = $editie;
        }
        return $this;
    }
}
