<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementInfoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van abonnements informatie.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetAbonnementInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de relatie. Dient > 0 te zijn.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toonAbonnementen
     * Meta information extracted from the WSDL
     * - documentation: Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * The toonHistorie
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of ook historische abonnementen moeten worden opgehaald.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $toonHistorie;
    /**
     * The exclVerschijningen
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van de recente verschijningen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclVerschijningen;
    /**
     * The exclKlachten
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van bijbehorende klachten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclKlachten;
    /**
     * Constructor method for getAbonnementInfoRequest
     * @uses GetAbonnementInfoRequest::setRequestTag()
     * @uses GetAbonnementInfoRequest::setRelNo()
     * @uses GetAbonnementInfoRequest::setToonAbonnementen()
     * @uses GetAbonnementInfoRequest::setToonHistorie()
     * @uses GetAbonnementInfoRequest::setExclVerschijningen()
     * @uses GetAbonnementInfoRequest::setExclKlachten()
     * @param string $requestTag
     * @param int $relNo
     * @param float $toonAbonnementen
     * @param bool $toonHistorie
     * @param bool $exclVerschijningen
     * @param bool $exclKlachten
     */
    public function __construct($requestTag = null, $relNo = null, $toonAbonnementen = null, $toonHistorie = null, $exclVerschijningen = null, $exclKlachten = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setToonAbonnementen($toonAbonnementen)
            ->setToonHistorie($toonHistorie)
            ->setExclVerschijningen($exclVerschijningen)
            ->setExclKlachten($exclKlachten);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: float
        if (!is_null($toonAbonnementen) && !(is_float($toonAbonnementen) || is_numeric($toonAbonnementen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toonAbonnementen, true), gettype($toonAbonnementen)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($toonAbonnementen) && mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($toonAbonnementen, true), mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Get toonHistorie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getToonHistorie()
    {
        return isset($this->toonHistorie) ? $this->toonHistorie : null;
    }
    /**
     * Set toonHistorie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $toonHistorie
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setToonHistorie($toonHistorie = null)
    {
        // validation for constraint: boolean
        if (!is_null($toonHistorie) && !is_bool($toonHistorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toonHistorie, true), gettype($toonHistorie)), __LINE__);
        }
        if (is_null($toonHistorie) || (is_array($toonHistorie) && empty($toonHistorie))) {
            unset($this->toonHistorie);
        } else {
            $this->toonHistorie = $toonHistorie;
        }
        return $this;
    }
    /**
     * Get exclVerschijningen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclVerschijningen()
    {
        return isset($this->exclVerschijningen) ? $this->exclVerschijningen : null;
    }
    /**
     * Set exclVerschijningen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclVerschijningen
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setExclVerschijningen($exclVerschijningen = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclVerschijningen) && !is_bool($exclVerschijningen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclVerschijningen, true), gettype($exclVerschijningen)), __LINE__);
        }
        if (is_null($exclVerschijningen) || (is_array($exclVerschijningen) && empty($exclVerschijningen))) {
            unset($this->exclVerschijningen);
        } else {
            $this->exclVerschijningen = $exclVerschijningen;
        }
        return $this;
    }
    /**
     * Get exclKlachten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclKlachten()
    {
        return isset($this->exclKlachten) ? $this->exclKlachten : null;
    }
    /**
     * Set exclKlachten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclKlachten
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoRequest
     */
    public function setExclKlachten($exclKlachten = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclKlachten) && !is_bool($exclKlachten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclKlachten, true), gettype($exclKlachten)), __LINE__);
        }
        if (is_null($exclKlachten) || (is_array($exclKlachten) && empty($exclKlachten))) {
            unset($this->exclKlachten);
        } else {
            $this->exclKlachten = $exclKlachten;
        }
        return $this;
    }
}
