<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatSubtotInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvatSubtotInfo extends AbstractStructBase
{
    /**
     * The subtotaal
     * Meta information extracted from the WSDL
     * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\FactSamenvatSubtot[]
     */
    public $subtotaal;
    /**
     * Constructor method for FactSamenvatSubtotInfo
     * @uses FactSamenvatSubtotInfo::setSubtotaal()
     * @param \AbonnementApiV6\StructType\FactSamenvatSubtot[] $subtotaal
     */
    public function __construct(array $subtotaal = array())
    {
        $this
            ->setSubtotaal($subtotaal);
    }
    /**
     * Get subtotaal value
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtot[]|null
     */
    public function getSubtotaal()
    {
        return $this->subtotaal;
    }
    /**
     * This method is responsible for validating the values passed to the setSubtotaal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubtotaal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubtotaalForArrayConstraintsFromSetSubtotaal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatSubtotInfoSubtotaalItem) {
            // validation for constraint: itemType
            if (!$factSamenvatSubtotInfoSubtotaalItem instanceof \AbonnementApiV6\StructType\FactSamenvatSubtot) {
                $invalidValues[] = is_object($factSamenvatSubtotInfoSubtotaalItem) ? get_class($factSamenvatSubtotInfoSubtotaalItem) : sprintf('%s(%s)', gettype($factSamenvatSubtotInfoSubtotaalItem), var_export($factSamenvatSubtotInfoSubtotaalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subtotaal property can only contain items of type \AbonnementApiV6\StructType\FactSamenvatSubtot, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subtotaal value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvatSubtot[] $subtotaal
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtotInfo
     */
    public function setSubtotaal(array $subtotaal = array())
    {
        // validation for constraint: array
        if ('' !== ($subtotaalArrayErrorMessage = self::validateSubtotaalForArrayConstraintsFromSetSubtotaal($subtotaal))) {
            throw new \InvalidArgumentException($subtotaalArrayErrorMessage, __LINE__);
        }
        $this->subtotaal = $subtotaal;
        return $this;
    }
    /**
     * Add item to subtotaal value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvatSubtot $item
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtotInfo
     */
    public function addToSubtotaal(\AbonnementApiV6\StructType\FactSamenvatSubtot $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\FactSamenvatSubtot) {
            throw new \InvalidArgumentException(sprintf('The subtotaal property can only contain items of type \AbonnementApiV6\StructType\FactSamenvatSubtot, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subtotaal[] = $item;
        return $this;
    }
}
