<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met facturen samenvattingen.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvatInfo extends AbstractStructBase
{
    /**
     * The factuurSamenvatting
     * Meta information extracted from the WSDL
     * - documentation: Lijst met factuur samenvattingen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\FactSamenvat[]
     */
    public $factuurSamenvatting;
    /**
     * Constructor method for FactSamenvatInfo
     * @uses FactSamenvatInfo::setFactuurSamenvatting()
     * @param \AbonnementApiV6\StructType\FactSamenvat[] $factuurSamenvatting
     */
    public function __construct(array $factuurSamenvatting = array())
    {
        $this
            ->setFactuurSamenvatting($factuurSamenvatting);
    }
    /**
     * Get factuurSamenvatting value
     * @return \AbonnementApiV6\StructType\FactSamenvat[]|null
     */
    public function getFactuurSamenvatting()
    {
        return $this->factuurSamenvatting;
    }
    /**
     * This method is responsible for validating the values passed to the setFactuurSamenvatting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFactuurSamenvatting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFactuurSamenvattingForArrayConstraintsFromSetFactuurSamenvatting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatInfoFactuurSamenvattingItem) {
            // validation for constraint: itemType
            if (!$factSamenvatInfoFactuurSamenvattingItem instanceof \AbonnementApiV6\StructType\FactSamenvat) {
                $invalidValues[] = is_object($factSamenvatInfoFactuurSamenvattingItem) ? get_class($factSamenvatInfoFactuurSamenvattingItem) : sprintf('%s(%s)', gettype($factSamenvatInfoFactuurSamenvattingItem), var_export($factSamenvatInfoFactuurSamenvattingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The factuurSamenvatting property can only contain items of type \AbonnementApiV6\StructType\FactSamenvat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvat[] $factuurSamenvatting
     * @return \AbonnementApiV6\StructType\FactSamenvatInfo
     */
    public function setFactuurSamenvatting(array $factuurSamenvatting = array())
    {
        // validation for constraint: array
        if ('' !== ($factuurSamenvattingArrayErrorMessage = self::validateFactuurSamenvattingForArrayConstraintsFromSetFactuurSamenvatting($factuurSamenvatting))) {
            throw new \InvalidArgumentException($factuurSamenvattingArrayErrorMessage, __LINE__);
        }
        $this->factuurSamenvatting = $factuurSamenvatting;
        return $this;
    }
    /**
     * Add item to factuurSamenvatting value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvat $item
     * @return \AbonnementApiV6\StructType\FactSamenvatInfo
     */
    public function addToFactuurSamenvatting(\AbonnementApiV6\StructType\FactSamenvat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\FactSamenvat) {
            throw new \InvalidArgumentException(sprintf('The factuurSamenvatting property can only contain items of type \AbonnementApiV6\StructType\FactSamenvat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->factuurSamenvatting[] = $item;
        return $this;
    }
}
