<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatBtwInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met BTW gegevens van de factuur samenvatting.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvatBtwInfo extends AbstractStructBase
{
    /**
     * The btw
     * Meta information extracted from the WSDL
     * - documentation: Lijst met btw gegevens van de factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\FactSamenvatBtw[]
     */
    public $btw;
    /**
     * Constructor method for FactSamenvatBtwInfo
     * @uses FactSamenvatBtwInfo::setBtw()
     * @param \AbonnementApiV6\StructType\FactSamenvatBtw[] $btw
     */
    public function __construct(array $btw = array())
    {
        $this
            ->setBtw($btw);
    }
    /**
     * Get btw value
     * @return \AbonnementApiV6\StructType\FactSamenvatBtw[]|null
     */
    public function getBtw()
    {
        return $this->btw;
    }
    /**
     * This method is responsible for validating the values passed to the setBtw method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBtw method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBtwForArrayConstraintsFromSetBtw(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $factSamenvatBtwInfoBtwItem) {
            // validation for constraint: itemType
            if (!$factSamenvatBtwInfoBtwItem instanceof \AbonnementApiV6\StructType\FactSamenvatBtw) {
                $invalidValues[] = is_object($factSamenvatBtwInfoBtwItem) ? get_class($factSamenvatBtwInfoBtwItem) : sprintf('%s(%s)', gettype($factSamenvatBtwInfoBtwItem), var_export($factSamenvatBtwInfoBtwItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The btw property can only contain items of type \AbonnementApiV6\StructType\FactSamenvatBtw, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set btw value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvatBtw[] $btw
     * @return \AbonnementApiV6\StructType\FactSamenvatBtwInfo
     */
    public function setBtw(array $btw = array())
    {
        // validation for constraint: array
        if ('' !== ($btwArrayErrorMessage = self::validateBtwForArrayConstraintsFromSetBtw($btw))) {
            throw new \InvalidArgumentException($btwArrayErrorMessage, __LINE__);
        }
        $this->btw = $btw;
        return $this;
    }
    /**
     * Add item to btw value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\FactSamenvatBtw $item
     * @return \AbonnementApiV6\StructType\FactSamenvatBtwInfo
     */
    public function addToBtw(\AbonnementApiV6\StructType\FactSamenvatBtw $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\FactSamenvatBtw) {
            throw new \InvalidArgumentException(sprintf('The btw property can only contain items of type \AbonnementApiV6\StructType\FactSamenvatBtw, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->btw[] = $item;
        return $this;
    }
}
