<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatBtw StructType
 * Meta information extracted from the WSDL
 * - documentation: BTW gegevens van een factuur samenvatting.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvatBtw extends AbstractStructBase
{
    /**
     * The btwCode
     * Meta information extracted from the WSDL
     * - documentation: Btw code.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $btwCode;
    /**
     * The btwPercentage
     * Meta information extracted from the WSDL
     * - documentation: Btw percentage.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 16
     * @var float
     */
    public $btwPercentage;
    /**
     * The btwOverSubtotaal
     * Meta information extracted from the WSDL
     * - documentation: Subtotaal waarover BTW wordt berekend.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $btwOverSubtotaal;
    /**
     * The btwBedrag
     * Meta information extracted from the WSDL
     * - documentation: Btw bedrag.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $btwBedrag;
    /**
     * Constructor method for FactSamenvatBtw
     * @uses FactSamenvatBtw::setBtwCode()
     * @uses FactSamenvatBtw::setBtwPercentage()
     * @uses FactSamenvatBtw::setBtwOverSubtotaal()
     * @uses FactSamenvatBtw::setBtwBedrag()
     * @param string $btwCode
     * @param float $btwPercentage
     * @param float $btwOverSubtotaal
     * @param float $btwBedrag
     */
    public function __construct($btwCode = null, $btwPercentage = null, $btwOverSubtotaal = null, $btwBedrag = null)
    {
        $this
            ->setBtwCode($btwCode)
            ->setBtwPercentage($btwPercentage)
            ->setBtwOverSubtotaal($btwOverSubtotaal)
            ->setBtwBedrag($btwBedrag);
    }
    /**
     * Get btwCode value
     * @return string
     */
    public function getBtwCode()
    {
        return $this->btwCode;
    }
    /**
     * Set btwCode value
     * @param string $btwCode
     * @return \AbonnementApiV6\StructType\FactSamenvatBtw
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwCode, true), gettype($btwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($btwCode) && mb_strlen($btwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($btwCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($btwCode) && mb_strlen($btwCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($btwCode)), __LINE__);
        }
        $this->btwCode = $btwCode;
        return $this;
    }
    /**
     * Get btwPercentage value
     * @return float
     */
    public function getBtwPercentage()
    {
        return $this->btwPercentage;
    }
    /**
     * Set btwPercentage value
     * @param float $btwPercentage
     * @return \AbonnementApiV6\StructType\FactSamenvatBtw
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($btwPercentage) && !(is_float($btwPercentage) || is_numeric($btwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPercentage, true), gettype($btwPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($btwPercentage) && mb_strlen(mb_substr($btwPercentage, false !== mb_strpos($btwPercentage, '.') ? mb_strpos($btwPercentage, '.') + 1 : mb_strlen($btwPercentage))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($btwPercentage, true), mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($btwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $btwPercentage)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($btwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $btwPercentage))), __LINE__);
        }
        $this->btwPercentage = $btwPercentage;
        return $this;
    }
    /**
     * Get btwOverSubtotaal value
     * @return float
     */
    public function getBtwOverSubtotaal()
    {
        return $this->btwOverSubtotaal;
    }
    /**
     * Set btwOverSubtotaal value
     * @param float $btwOverSubtotaal
     * @return \AbonnementApiV6\StructType\FactSamenvatBtw
     */
    public function setBtwOverSubtotaal($btwOverSubtotaal = null)
    {
        // validation for constraint: float
        if (!is_null($btwOverSubtotaal) && !(is_float($btwOverSubtotaal) || is_numeric($btwOverSubtotaal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwOverSubtotaal, true), gettype($btwOverSubtotaal)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwOverSubtotaal) && mb_strlen(preg_replace('/(\D)/', '', $btwOverSubtotaal)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwOverSubtotaal, true), mb_strlen(preg_replace('/(\D)/', '', $btwOverSubtotaal))), __LINE__);
        }
        $this->btwOverSubtotaal = $btwOverSubtotaal;
        return $this;
    }
    /**
     * Get btwBedrag value
     * @return float
     */
    public function getBtwBedrag()
    {
        return $this->btwBedrag;
    }
    /**
     * Set btwBedrag value
     * @param float $btwBedrag
     * @return \AbonnementApiV6\StructType\FactSamenvatBtw
     */
    public function setBtwBedrag($btwBedrag = null)
    {
        // validation for constraint: float
        if (!is_null($btwBedrag) && !(is_float($btwBedrag) || is_numeric($btwBedrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwBedrag, true), gettype($btwBedrag)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($btwBedrag) && mb_strlen(preg_replace('/(\D)/', '', $btwBedrag)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($btwBedrag, true), mb_strlen(preg_replace('/(\D)/', '', $btwBedrag))), __LINE__);
        }
        $this->btwBedrag = $btwBedrag;
        return $this;
    }
}
