<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createKlantPersoonRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>RelatieApiV6.createPersoon</b> te gebruiken om de relatie aan te maken.
 * </br></u> <br/> Aanmaken van een nieuwe relatie van type persoon. Bij het aanmaken wordt op basis van de input gekeken of er al een persoon in de database staat die gelijk is. In dat geval wordt er geen nieuwe relatie aangemaakt maar wordt de
 * bestaande relatie gebruikt. De businessrules hiervoor zijn op te vragen bij de servicedesk van Socho_IT.
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateKlantPersoonRequest extends AbstractStructBase
{
    /**
     * The persoonsObject
     * Meta information extracted from the WSDL
     * - documentation: Persoonsgegevens van de aan te maken relatie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoonsObject;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The bezoekAdresObject
     * Meta information extracted from the WSDL
     * - documentation: Adresgegevens van het aan te maken bezoekadres.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $bezoekAdresObject;
    /**
     * The forceerNieuweKlant
     * Meta information extracted from the WSDL
     * - documentation: Aanmaken nieuwe klant forceren, dus niet controleren of de klant al bestaat. Default false dus wel controleren en eventueel bestaande klant gebruiken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerNieuweKlant;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createKlantPersoonRequest
     * @uses CreateKlantPersoonRequest::setPersoonsObject()
     * @uses CreateKlantPersoonRequest::setRequestTag()
     * @uses CreateKlantPersoonRequest::setBezoekAdresObject()
     * @uses CreateKlantPersoonRequest::setForceerNieuweKlant()
     * @uses CreateKlantPersoonRequest::setCanCreate()
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObject
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\AdresObject $bezoekAdresObject
     * @param bool $forceerNieuweKlant
     * @param bool $canCreate
     */
    public function __construct(\AbonnementApiV6\StructType\PersoonsObject $persoonsObject = null, $requestTag = null, \AbonnementApiV6\StructType\AdresObject $bezoekAdresObject = null, $forceerNieuweKlant = null, $canCreate = null)
    {
        $this
            ->setPersoonsObject($persoonsObject)
            ->setRequestTag($requestTag)
            ->setBezoekAdresObject($bezoekAdresObject)
            ->setForceerNieuweKlant($forceerNieuweKlant)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObject value
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function getPersoonsObject()
    {
        return $this->persoonsObject;
    }
    /**
     * Set persoonsObject value
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObject
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonRequest
     */
    public function setPersoonsObject(\AbonnementApiV6\StructType\PersoonsObject $persoonsObject = null)
    {
        $this->persoonsObject = $persoonsObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get bezoekAdresObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AdresObject|null
     */
    public function getBezoekAdresObject()
    {
        return isset($this->bezoekAdresObject) ? $this->bezoekAdresObject : null;
    }
    /**
     * Set bezoekAdresObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AdresObject $bezoekAdresObject
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonRequest
     */
    public function setBezoekAdresObject(\AbonnementApiV6\StructType\AdresObject $bezoekAdresObject = null)
    {
        if (is_null($bezoekAdresObject) || (is_array($bezoekAdresObject) && empty($bezoekAdresObject))) {
            unset($this->bezoekAdresObject);
        } else {
            $this->bezoekAdresObject = $bezoekAdresObject;
        }
        return $this;
    }
    /**
     * Get forceerNieuweKlant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerNieuweKlant()
    {
        return isset($this->forceerNieuweKlant) ? $this->forceerNieuweKlant : null;
    }
    /**
     * Set forceerNieuweKlant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerNieuweKlant
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonRequest
     */
    public function setForceerNieuweKlant($forceerNieuweKlant = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerNieuweKlant) && !is_bool($forceerNieuweKlant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerNieuweKlant, true), gettype($forceerNieuweKlant)), __LINE__);
        }
        if (is_null($forceerNieuweKlant) || (is_array($forceerNieuweKlant) && empty($forceerNieuweKlant))) {
            unset($this->forceerNieuweKlant);
        } else {
            $this->forceerNieuweKlant = $forceerNieuweKlant;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
