<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBezKlachtRelUitgaveRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanmaken van een bezorgklacht op basis van een opgegeven relatienummer en uitgavecode
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateBezKlachtRelUitgaveRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de relatie waarvoor de klacht aangemaakt moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave waarvoor de klacht aangemaakt moet worden.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveCode;
    /**
     * The klachtSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de klachtsoort. Moet een bestaande en actieve klachtsoort zijn.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $klachtSoortCode;
    /**
     * The klachtOnderwerpCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de klachtonderwerp. Moet een bestaande en actief klachtonderwerp zijn.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $klachtOnderwerpCode;
    /**
     * The klachtDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum waarvoor de klacht geldt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $klachtDatum;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The klachtToelichting
     * Meta information extracted from the WSDL
     * - documentation: Korte toelichting van de klacht. Kan door Zeno in het response aangevuld worden met een code t.b.v. het signaleren van herhaalde/erntige klachten, door bijv. de code '1HEK' toe te voegen aan de toelichting.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtNabezorgen
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de krant/tijdschrift nabezorgd moet worden. Standaardwaarde false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtNabezorgen;
    /**
     * The klachtCompenseren
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de krant/tijdschrift ter compensatie verlengd moet worden. Standaardwaarde false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtCompenseren;
    /**
     * The klachtEmail
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres van de klager. Wordt bij de klacht opgeslagen; mag afwijken van het e-mail adres van de relatie die bij de klacht geregistreerd staat.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtEmail;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen bezorgklacht aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createBezKlachtRelUitgaveRequest
     * @uses CreateBezKlachtRelUitgaveRequest::setRelNo()
     * @uses CreateBezKlachtRelUitgaveRequest::setUitgaveCode()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtSoortCode()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtOnderwerpCode()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtDatum()
     * @uses CreateBezKlachtRelUitgaveRequest::setRequestTag()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtToelichting()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtNabezorgen()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtCompenseren()
     * @uses CreateBezKlachtRelUitgaveRequest::setKlachtEmail()
     * @uses CreateBezKlachtRelUitgaveRequest::setCanCreate()
     * @param int $relNo
     * @param string $uitgaveCode
     * @param string $klachtSoortCode
     * @param string $klachtOnderwerpCode
     * @param string $klachtDatum
     * @param string $requestTag
     * @param string $klachtToelichting
     * @param bool $klachtNabezorgen
     * @param bool $klachtCompenseren
     * @param string $klachtEmail
     * @param bool $canCreate
     */
    public function __construct($relNo = null, $uitgaveCode = null, $klachtSoortCode = null, $klachtOnderwerpCode = null, $klachtDatum = null, $requestTag = null, $klachtToelichting = null, $klachtNabezorgen = null, $klachtCompenseren = null, $klachtEmail = null, $canCreate = null)
    {
        $this
            ->setRelNo($relNo)
            ->setUitgaveCode($uitgaveCode)
            ->setKlachtSoortCode($klachtSoortCode)
            ->setKlachtOnderwerpCode($klachtOnderwerpCode)
            ->setKlachtDatum($klachtDatum)
            ->setRequestTag($requestTag)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtNabezorgen($klachtNabezorgen)
            ->setKlachtCompenseren($klachtCompenseren)
            ->setKlachtEmail($klachtEmail)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get klachtSoortCode value
     * @return string
     */
    public function getKlachtSoortCode()
    {
        return $this->klachtSoortCode;
    }
    /**
     * Set klachtSoortCode value
     * @param string $klachtSoortCode
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtSoortCode($klachtSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($klachtSoortCode) && !is_string($klachtSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtSoortCode, true), gettype($klachtSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($klachtSoortCode) && mb_strlen($klachtSoortCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($klachtSoortCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($klachtSoortCode) && mb_strlen($klachtSoortCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($klachtSoortCode)), __LINE__);
        }
        $this->klachtSoortCode = $klachtSoortCode;
        return $this;
    }
    /**
     * Get klachtOnderwerpCode value
     * @return string
     */
    public function getKlachtOnderwerpCode()
    {
        return $this->klachtOnderwerpCode;
    }
    /**
     * Set klachtOnderwerpCode value
     * @param string $klachtOnderwerpCode
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtOnderwerpCode($klachtOnderwerpCode = null)
    {
        // validation for constraint: string
        if (!is_null($klachtOnderwerpCode) && !is_string($klachtOnderwerpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtOnderwerpCode, true), gettype($klachtOnderwerpCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($klachtOnderwerpCode) && mb_strlen($klachtOnderwerpCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($klachtOnderwerpCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($klachtOnderwerpCode) && mb_strlen($klachtOnderwerpCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($klachtOnderwerpCode)), __LINE__);
        }
        $this->klachtOnderwerpCode = $klachtOnderwerpCode;
        return $this;
    }
    /**
     * Get klachtDatum value
     * @return string
     */
    public function getKlachtDatum()
    {
        return $this->klachtDatum;
    }
    /**
     * Set klachtDatum value
     * @param string $klachtDatum
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtDatum($klachtDatum = null)
    {
        // validation for constraint: string
        if (!is_null($klachtDatum) && !is_string($klachtDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtDatum, true), gettype($klachtDatum)), __LINE__);
        }
        $this->klachtDatum = $klachtDatum;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtToelichting, true), gettype($klachtToelichting)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($klachtToelichting) && mb_strlen($klachtToelichting) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtNabezorgen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtNabezorgen()
    {
        return isset($this->klachtNabezorgen) ? $this->klachtNabezorgen : null;
    }
    /**
     * Set klachtNabezorgen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtNabezorgen
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtNabezorgen($klachtNabezorgen = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtNabezorgen) && !is_bool($klachtNabezorgen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtNabezorgen, true), gettype($klachtNabezorgen)), __LINE__);
        }
        if (is_null($klachtNabezorgen) || (is_array($klachtNabezorgen) && empty($klachtNabezorgen))) {
            unset($this->klachtNabezorgen);
        } else {
            $this->klachtNabezorgen = $klachtNabezorgen;
        }
        return $this;
    }
    /**
     * Get klachtCompenseren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtCompenseren()
    {
        return isset($this->klachtCompenseren) ? $this->klachtCompenseren : null;
    }
    /**
     * Set klachtCompenseren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtCompenseren
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtCompenseren($klachtCompenseren = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtCompenseren) && !is_bool($klachtCompenseren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtCompenseren, true), gettype($klachtCompenseren)), __LINE__);
        }
        if (is_null($klachtCompenseren) || (is_array($klachtCompenseren) && empty($klachtCompenseren))) {
            unset($this->klachtCompenseren);
        } else {
            $this->klachtCompenseren = $klachtCompenseren;
        }
        return $this;
    }
    /**
     * Get klachtEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtEmail()
    {
        return isset($this->klachtEmail) ? $this->klachtEmail : null;
    }
    /**
     * Set klachtEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtEmail
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setKlachtEmail($klachtEmail = null)
    {
        // validation for constraint: string
        if (!is_null($klachtEmail) && !is_string($klachtEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtEmail, true), gettype($klachtEmail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($klachtEmail) && mb_strlen($klachtEmail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($klachtEmail)), __LINE__);
        }
        if (is_null($klachtEmail) || (is_array($klachtEmail) && empty($klachtEmail))) {
            unset($this->klachtEmail);
        } else {
            $this->klachtEmail = $klachtEmail;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
