<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboAboNawRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>createAboAboNo</b> te gebruiken i.c.m. de RelatieApiV6 om de relatie aan te
 * maken. </br></u> <br/> Aanmaken van een nieuw abonnement voor een relatie, waarbij de NAW gegevens van de relatie meegegeven kan worden. Deze relatie wordt zowel als abonnee als debiteur aan het abonnement gekoppeld.
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAboAboNawRequest extends AbstractStructBase
{
    /**
     * The persoonsObjectAbo
     * Meta information extracted from the WSDL
     * - documentation: Persoonsgegevens abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoonsObjectAbo;
    /**
     * The adresObjectAbo
     * Meta information extracted from the WSDL
     * - documentation: Adresgegevens abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $adresObjectAbo;
    /**
     * The aboObject
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsgegevens.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboObject
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The geenControleLopendAbo
     * Meta information extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The forceerNieuweKlant
     * Meta information extracted from the WSDL
     * - documentation: Aanmaken nieuwe klant forceren, dus niet controleren of de klant al bestaat. Default false dus wel controleren en eventueel bestaande klant gebruiken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerNieuweKlant;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie en abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createAboAboNawRequest
     * @uses CreateAboAboNawRequest::setPersoonsObjectAbo()
     * @uses CreateAboAboNawRequest::setAdresObjectAbo()
     * @uses CreateAboAboNawRequest::setAboObject()
     * @uses CreateAboAboNawRequest::setRequestTag()
     * @uses CreateAboAboNawRequest::setGeenControleLopendAbo()
     * @uses CreateAboAboNawRequest::setForceerNieuweKlant()
     * @uses CreateAboAboNawRequest::setCanCreate()
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectAbo
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @param string $requestTag
     * @param bool $geenControleLopendAbo
     * @param bool $forceerNieuweKlant
     * @param bool $canCreate
     */
    public function __construct(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo = null, \AbonnementApiV6\StructType\AdresObject $adresObjectAbo = null, \AbonnementApiV6\StructType\AboObject $aboObject = null, $requestTag = null, $geenControleLopendAbo = null, $forceerNieuweKlant = null, $canCreate = null)
    {
        $this
            ->setPersoonsObjectAbo($persoonsObjectAbo)
            ->setAdresObjectAbo($adresObjectAbo)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setForceerNieuweKlant($forceerNieuweKlant)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObjectAbo value
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function getPersoonsObjectAbo()
    {
        return $this->persoonsObjectAbo;
    }
    /**
     * Set persoonsObjectAbo value
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setPersoonsObjectAbo(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo = null)
    {
        $this->persoonsObjectAbo = $persoonsObjectAbo;
        return $this;
    }
    /**
     * Get adresObjectAbo value
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function getAdresObjectAbo()
    {
        return $this->adresObjectAbo;
    }
    /**
     * Set adresObjectAbo value
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectAbo
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setAdresObjectAbo(\AbonnementApiV6\StructType\AdresObject $adresObjectAbo = null)
    {
        $this->adresObjectAbo = $adresObjectAbo;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setAboObject(\AbonnementApiV6\StructType\AboObject $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get forceerNieuweKlant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerNieuweKlant()
    {
        return isset($this->forceerNieuweKlant) ? $this->forceerNieuweKlant : null;
    }
    /**
     * Set forceerNieuweKlant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerNieuweKlant
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setForceerNieuweKlant($forceerNieuweKlant = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerNieuweKlant) && !is_bool($forceerNieuweKlant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerNieuweKlant, true), gettype($forceerNieuweKlant)), __LINE__);
        }
        if (is_null($forceerNieuweKlant) || (is_array($forceerNieuweKlant) && empty($forceerNieuweKlant))) {
            unset($this->forceerNieuweKlant);
        } else {
            $this->forceerNieuweKlant = $forceerNieuweKlant;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \AbonnementApiV6\StructType\CreateAboAboNawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
