<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkProefaboResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error2: Ongeldige uitgavecode meegegeven. | error1: Controle op eerdere proefabonnementen staat niet aan.
 * @subpackage Structs
 * @date 20240419 package
 */
class CheckProefaboResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Geeft terug of er een proefabonnement gevonden is. <br /> -1 = Er geen controle op proefabonnementen actief. <br /> 0 = Geen proefabonnementen gevonden in de laatste x maanden. <br /> 1 = Een proefabonnement gevonden in de afgelopen
     * x maanden op dezelfde uitgave. <br /> 2 = Een proefabonnement gevonden in de afgelopen x maanden op een andere uitgave. <br />
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The aantalMaandenControle
     * Meta information extracted from the WSDL
     * - documentation: Aantal maanden dat ingesteld is in Zeno waarop een relatie geen proefabonnement mag hebben.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenControle;
    /**
     * The aantalMaandenProefabo
     * Meta information extracted from the WSDL
     * - documentation: Aantal maanden dat een relatie met de opgegeven gegevens voor het laatst een proefabonnement heeft gehad.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenProefabo;
    /**
     * The uitgaveProefabo
     * Meta information extracted from the WSDL
     * - documentation: De uitgave waar een relatie met de opgegeven gegevens voor het laatst een proefabonnement op heeft gehad (kan afwijken van de opgegeven uitgave indien in Zeno de controle over uitgaven heen aan staat).
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveProefabo;
    /**
     * Constructor method for checkProefaboResponse
     * @uses CheckProefaboResponse::setRequestTag()
     * @uses CheckProefaboResponse::setStatus()
     * @uses CheckProefaboResponse::setAantalMaandenControle()
     * @uses CheckProefaboResponse::setAantalMaandenProefabo()
     * @uses CheckProefaboResponse::setUitgaveProefabo()
     * @param string $requestTag
     * @param float $status
     * @param float $aantalMaandenControle
     * @param float $aantalMaandenProefabo
     * @param string $uitgaveProefabo
     */
    public function __construct($requestTag = null, $status = null, $aantalMaandenControle = null, $aantalMaandenProefabo = null, $uitgaveProefabo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setStatus($status)
            ->setAantalMaandenControle($aantalMaandenControle)
            ->setAantalMaandenProefabo($aantalMaandenProefabo)
            ->setUitgaveProefabo($uitgaveProefabo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $status
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get aantalMaandenControle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenControle()
    {
        return isset($this->aantalMaandenControle) ? $this->aantalMaandenControle : null;
    }
    /**
     * Set aantalMaandenControle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenControle
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function setAantalMaandenControle($aantalMaandenControle = null)
    {
        // validation for constraint: float
        if (!is_null($aantalMaandenControle) && !(is_float($aantalMaandenControle) || is_numeric($aantalMaandenControle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalMaandenControle, true), gettype($aantalMaandenControle)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalMaandenControle) && mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenControle)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalMaandenControle, true), mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenControle))), __LINE__);
        }
        if (is_null($aantalMaandenControle) || (is_array($aantalMaandenControle) && empty($aantalMaandenControle))) {
            unset($this->aantalMaandenControle);
        } else {
            $this->aantalMaandenControle = $aantalMaandenControle;
        }
        return $this;
    }
    /**
     * Get aantalMaandenProefabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenProefabo()
    {
        return isset($this->aantalMaandenProefabo) ? $this->aantalMaandenProefabo : null;
    }
    /**
     * Set aantalMaandenProefabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenProefabo
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function setAantalMaandenProefabo($aantalMaandenProefabo = null)
    {
        // validation for constraint: float
        if (!is_null($aantalMaandenProefabo) && !(is_float($aantalMaandenProefabo) || is_numeric($aantalMaandenProefabo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalMaandenProefabo, true), gettype($aantalMaandenProefabo)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalMaandenProefabo) && mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenProefabo)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalMaandenProefabo, true), mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenProefabo))), __LINE__);
        }
        if (is_null($aantalMaandenProefabo) || (is_array($aantalMaandenProefabo) && empty($aantalMaandenProefabo))) {
            unset($this->aantalMaandenProefabo);
        } else {
            $this->aantalMaandenProefabo = $aantalMaandenProefabo;
        }
        return $this;
    }
    /**
     * Get uitgaveProefabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveProefabo()
    {
        return isset($this->uitgaveProefabo) ? $this->uitgaveProefabo : null;
    }
    /**
     * Set uitgaveProefabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveProefabo
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function setUitgaveProefabo($uitgaveProefabo = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveProefabo) && !is_string($uitgaveProefabo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveProefabo, true), gettype($uitgaveProefabo)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($uitgaveProefabo) && mb_strlen($uitgaveProefabo) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($uitgaveProefabo)), __LINE__);
        }
        if (is_null($uitgaveProefabo) || (is_array($uitgaveProefabo) && empty($uitgaveProefabo))) {
            unset($this->uitgaveProefabo);
        } else {
            $this->uitgaveProefabo = $uitgaveProefabo;
        }
        return $this;
    }
}
