<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkActieaboResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error2: Ongeldige uitgavecode meegegeven. | error1: Controle op eerdere actieabonnementen staat niet aan.
 * @subpackage Structs
 * @date 20240419 package
 */
class CheckActieaboResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Geeft terug of er een actieabonnement gevonden is. <br /> -1 = Er geen controle op actieabonnementen actief. <br /> 0 = Geen actieabonnementen gevonden in de laatste x maanden. <br /> 1 = Een actieabonnement gevonden in de afgelopen
     * x maanden op dezelfde uitgave. <br /> 2 = Een actieabonnement gevonden in de afgelopen x maanden op een andere uitgave. <br />
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The aantalMaandenControle
     * Meta information extracted from the WSDL
     * - documentation: Aantal maanden dat ingesteld is in Zeno waarop een relatie geen actieabonnement mag hebben.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenControle;
    /**
     * The aantalMaandenActieabo
     * Meta information extracted from the WSDL
     * - documentation: Aantal maanden dat een relatie met de opgegeven gegevens voor het laatst een actieabonnement heeft gehad.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenActieabo;
    /**
     * The uitgaveActieabo
     * Meta information extracted from the WSDL
     * - documentation: De uitgave waar een relatie met de opgegeven gegevens voor het laatst een actieabonnement op heeft gehad (kan afwijken van de opgegeven uitgave indien in Zeno de controle over uitgaven heen aan staat).
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveActieabo;
    /**
     * Constructor method for checkActieaboResponse
     * @uses CheckActieaboResponse::setRequestTag()
     * @uses CheckActieaboResponse::setStatus()
     * @uses CheckActieaboResponse::setAantalMaandenControle()
     * @uses CheckActieaboResponse::setAantalMaandenActieabo()
     * @uses CheckActieaboResponse::setUitgaveActieabo()
     * @param string $requestTag
     * @param float $status
     * @param float $aantalMaandenControle
     * @param float $aantalMaandenActieabo
     * @param string $uitgaveActieabo
     */
    public function __construct($requestTag = null, $status = null, $aantalMaandenControle = null, $aantalMaandenActieabo = null, $uitgaveActieabo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setStatus($status)
            ->setAantalMaandenControle($aantalMaandenControle)
            ->setAantalMaandenActieabo($aantalMaandenActieabo)
            ->setUitgaveActieabo($uitgaveActieabo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $status
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get aantalMaandenControle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenControle()
    {
        return isset($this->aantalMaandenControle) ? $this->aantalMaandenControle : null;
    }
    /**
     * Set aantalMaandenControle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenControle
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse
     */
    public function setAantalMaandenControle($aantalMaandenControle = null)
    {
        // validation for constraint: float
        if (!is_null($aantalMaandenControle) && !(is_float($aantalMaandenControle) || is_numeric($aantalMaandenControle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalMaandenControle, true), gettype($aantalMaandenControle)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalMaandenControle) && mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenControle)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalMaandenControle, true), mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenControle))), __LINE__);
        }
        if (is_null($aantalMaandenControle) || (is_array($aantalMaandenControle) && empty($aantalMaandenControle))) {
            unset($this->aantalMaandenControle);
        } else {
            $this->aantalMaandenControle = $aantalMaandenControle;
        }
        return $this;
    }
    /**
     * Get aantalMaandenActieabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenActieabo()
    {
        return isset($this->aantalMaandenActieabo) ? $this->aantalMaandenActieabo : null;
    }
    /**
     * Set aantalMaandenActieabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenActieabo
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse
     */
    public function setAantalMaandenActieabo($aantalMaandenActieabo = null)
    {
        // validation for constraint: float
        if (!is_null($aantalMaandenActieabo) && !(is_float($aantalMaandenActieabo) || is_numeric($aantalMaandenActieabo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalMaandenActieabo, true), gettype($aantalMaandenActieabo)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalMaandenActieabo) && mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenActieabo)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalMaandenActieabo, true), mb_strlen(preg_replace('/(\D)/', '', $aantalMaandenActieabo))), __LINE__);
        }
        if (is_null($aantalMaandenActieabo) || (is_array($aantalMaandenActieabo) && empty($aantalMaandenActieabo))) {
            unset($this->aantalMaandenActieabo);
        } else {
            $this->aantalMaandenActieabo = $aantalMaandenActieabo;
        }
        return $this;
    }
    /**
     * Get uitgaveActieabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveActieabo()
    {
        return isset($this->uitgaveActieabo) ? $this->uitgaveActieabo : null;
    }
    /**
     * Set uitgaveActieabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveActieabo
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse
     */
    public function setUitgaveActieabo($uitgaveActieabo = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveActieabo) && !is_string($uitgaveActieabo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveActieabo, true), gettype($uitgaveActieabo)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($uitgaveActieabo) && mb_strlen($uitgaveActieabo) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($uitgaveActieabo)), __LINE__);
        }
        if (is_null($uitgaveActieabo) || (is_array($uitgaveActieabo) && empty($uitgaveActieabo))) {
            unset($this->uitgaveActieabo);
        } else {
            $this->uitgaveActieabo = $uitgaveActieabo;
        }
        return $this;
    }
}
