<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelBezorgKlachtRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Annuleert een bezorg klacht als de abonnee vindt dat het bij nader inzien een onterechte klacht is. Of annulering van een bezorgklacht nog is toegestaan wordt aangegeven door het element canCancel in het type KlachtV4. Als een klacht
 * bijvoorbeeld al is afgehandeld kan deze niet meer worden geannuleerd, actie is dan namelijk al ondernomen.
 * @subpackage Structs
 * @date 20240419 package
 */
class CancelBezorgKlachtRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer bij de te annuleren bezorgklacht.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The klachtNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de te annuleren bezorgklacht.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The canCancel
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen echte annulering uitgevoerd) false (Default) = uit, true = aan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCancel;
    /**
     * Constructor method for cancelBezorgKlachtRequest
     * @uses CancelBezorgKlachtRequest::setRelNo()
     * @uses CancelBezorgKlachtRequest::setKlachtNo()
     * @uses CancelBezorgKlachtRequest::setRequestTag()
     * @uses CancelBezorgKlachtRequest::setCanCancel()
     * @param int $relNo
     * @param int $klachtNo
     * @param string $requestTag
     * @param bool $canCancel
     */
    public function __construct($relNo = null, $klachtNo = null, $requestTag = null, $canCancel = null)
    {
        $this
            ->setRelNo($relNo)
            ->setKlachtNo($klachtNo)
            ->setRequestTag($requestTag)
            ->setCanCancel($canCancel);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get klachtNo value
     * @return int
     */
    public function getKlachtNo()
    {
        return $this->klachtNo;
    }
    /**
     * Set klachtNo value
     * @param int $klachtNo
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtRequest
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: int
        if (!is_null($klachtNo) && !(is_int($klachtNo) || ctype_digit($klachtNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($klachtNo, true), gettype($klachtNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($klachtNo) && mb_strlen(preg_replace('/(\D)/', '', $klachtNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($klachtNo, true), mb_strlen(preg_replace('/(\D)/', '', $klachtNo))), __LINE__);
        }
        $this->klachtNo = $klachtNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCancel()
    {
        return isset($this->canCancel) ? $this->canCancel : null;
    }
    /**
     * Set canCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCancel
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtRequest
     */
    public function setCanCancel($canCancel = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCancel) && !is_bool($canCancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCancel, true), gettype($canCancel)), __LINE__);
        }
        if (is_null($canCancel) || (is_array($canCancel) && empty($canCancel))) {
            unset($this->canCancel);
        } else {
            $this->canCancel = $canCancel;
        }
        return $this;
    }
}
