<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calamiteit StructType
 * Meta information extracted from the WSDL
 * - documentation: Gegevens van de gevonden calamiteit
 * @subpackage Structs
 * @date 20240419 package
 */
class Calamiteit extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The datum
     * Meta information extracted from the WSDL
     * - documentation: Datum van de calamiteit.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $datum;
    /**
     * The omschrijving
     * Meta information extracted from the WSDL
     * - documentation: Korte omschrijving van de calamiteit.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $omschrijving;
    /**
     * The redenSleutel
     * Meta information extracted from the WSDL
     * - documentation: Melding sleutel.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $redenSleutel;
    /**
     * The redenSoort
     * Meta information extracted from the WSDL
     * - documentation: Melding soort.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $redenSoort;
    /**
     * The tijd
     * Meta information extracted from the WSDL
     * - documentation: Tijd tot en met wanneer de calamiteit actief is.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $tijd;
    /**
     * Constructor method for Calamiteit
     * @uses Calamiteit::setAboNo()
     * @uses Calamiteit::setDatum()
     * @uses Calamiteit::setOmschrijving()
     * @uses Calamiteit::setRedenSleutel()
     * @uses Calamiteit::setRedenSoort()
     * @uses Calamiteit::setTijd()
     * @param int $aboNo
     * @param string $datum
     * @param string $omschrijving
     * @param string $redenSleutel
     * @param string $redenSoort
     * @param string $tijd
     */
    public function __construct($aboNo = null, $datum = null, $omschrijving = null, $redenSleutel = null, $redenSoort = null, $tijd = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setDatum($datum)
            ->setOmschrijving($omschrijving)
            ->setRedenSleutel($redenSleutel)
            ->setRedenSoort($redenSoort)
            ->setTijd($tijd);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get datum value
     * @return string
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get omschrijving value
     * @return string
     */
    public function getOmschrijving()
    {
        return $this->omschrijving;
    }
    /**
     * Set omschrijving value
     * @param string $omschrijving
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($omschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($omschrijving)), __LINE__);
        }
        $this->omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get redenSleutel value
     * @return string
     */
    public function getRedenSleutel()
    {
        return $this->redenSleutel;
    }
    /**
     * Set redenSleutel value
     * @param string $redenSleutel
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setRedenSleutel($redenSleutel = null)
    {
        // validation for constraint: string
        if (!is_null($redenSleutel) && !is_string($redenSleutel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redenSleutel, true), gettype($redenSleutel)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($redenSleutel) && mb_strlen($redenSleutel) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($redenSleutel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($redenSleutel) && mb_strlen($redenSleutel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($redenSleutel)), __LINE__);
        }
        $this->redenSleutel = $redenSleutel;
        return $this;
    }
    /**
     * Get redenSoort value
     * @return string
     */
    public function getRedenSoort()
    {
        return $this->redenSoort;
    }
    /**
     * Set redenSoort value
     * @param string $redenSoort
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setRedenSoort($redenSoort = null)
    {
        // validation for constraint: string
        if (!is_null($redenSoort) && !is_string($redenSoort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redenSoort, true), gettype($redenSoort)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($redenSoort) && mb_strlen($redenSoort) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($redenSoort)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($redenSoort) && mb_strlen($redenSoort) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($redenSoort)), __LINE__);
        }
        $this->redenSoort = $redenSoort;
        return $this;
    }
    /**
     * Get tijd value
     * @return string
     */
    public function getTijd()
    {
        return $this->tijd;
    }
    /**
     * Set tijd value
     * @param string $tijd
     * @return \AbonnementApiV6\StructType\Calamiteit
     */
    public function setTijd($tijd = null)
    {
        // validation for constraint: string
        if (!is_null($tijd) && !is_string($tijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tijd, true), gettype($tijd)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tijd) && mb_strlen($tijd) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tijd)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tijd) && mb_strlen($tijd) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tijd)), __LINE__);
        }
        $this->tijd = $tijd;
        return $this;
    }
}
