<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Actie StructType
 * Meta information extracted from the WSDL
 * - documentation: Actie object.
 * @subpackage Structs
 * @date 20240419 package
 */
class Actie extends AbstractStructBase
{
    /**
     * The actieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de actie.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $actieCode;
    /**
     * The omschrijving
     * Meta information extracted from the WSDL
     * - documentation: Korte omschrijving van de actie.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $omschrijving;
    /**
     * The prijsEerstePeriode
     * Meta information extracted from the WSDL
     * - documentation: Prijs exclusief BTW voor de eerste periode, dus met verrekening actiekorting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 17
     * @var float
     */
    public $prijsEerstePeriode;
    /**
     * The prijsVervolgPeriode
     * Meta information extracted from the WSDL
     * - documentation: Prijs exclusief BTW voor de vervolg periode.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 17
     * @var float
     */
    public $prijsVervolgPeriode;
    /**
     * The omschrijvingUitgebreid
     * Meta information extracted from the WSDL
     * - documentation: Uitgebreide omschrijving van de actie voor op de website.
     * - base: xsd:string
     * - maxLength: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijvingUitgebreid;
    /**
     * The aboSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de bijbehorende abonnementsoort.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortCode;
    /**
     * The pakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het bijbehorende pakket.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * Constructor method for Actie
     * @uses Actie::setActieCode()
     * @uses Actie::setOmschrijving()
     * @uses Actie::setPrijsEerstePeriode()
     * @uses Actie::setPrijsVervolgPeriode()
     * @uses Actie::setOmschrijvingUitgebreid()
     * @uses Actie::setAboSoortCode()
     * @uses Actie::setPakketCode()
     * @param string $actieCode
     * @param string $omschrijving
     * @param float $prijsEerstePeriode
     * @param float $prijsVervolgPeriode
     * @param string $omschrijvingUitgebreid
     * @param string $aboSoortCode
     * @param string $pakketCode
     */
    public function __construct($actieCode = null, $omschrijving = null, $prijsEerstePeriode = null, $prijsVervolgPeriode = null, $omschrijvingUitgebreid = null, $aboSoortCode = null, $pakketCode = null)
    {
        $this
            ->setActieCode($actieCode)
            ->setOmschrijving($omschrijving)
            ->setPrijsEerstePeriode($prijsEerstePeriode)
            ->setPrijsVervolgPeriode($prijsVervolgPeriode)
            ->setOmschrijvingUitgebreid($omschrijvingUitgebreid)
            ->setAboSoortCode($aboSoortCode)
            ->setPakketCode($pakketCode);
    }
    /**
     * Get actieCode value
     * @return string
     */
    public function getActieCode()
    {
        return $this->actieCode;
    }
    /**
     * Set actieCode value
     * @param string $actieCode
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieCode, true), gettype($actieCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($actieCode) && mb_strlen($actieCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($actieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($actieCode) && mb_strlen($actieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($actieCode)), __LINE__);
        }
        $this->actieCode = $actieCode;
        return $this;
    }
    /**
     * Get omschrijving value
     * @return string
     */
    public function getOmschrijving()
    {
        return $this->omschrijving;
    }
    /**
     * Set omschrijving value
     * @param string $omschrijving
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($omschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($omschrijving)), __LINE__);
        }
        $this->omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get prijsEerstePeriode value
     * @return float
     */
    public function getPrijsEerstePeriode()
    {
        return $this->prijsEerstePeriode;
    }
    /**
     * Set prijsEerstePeriode value
     * @param float $prijsEerstePeriode
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setPrijsEerstePeriode($prijsEerstePeriode = null)
    {
        // validation for constraint: float
        if (!is_null($prijsEerstePeriode) && !(is_float($prijsEerstePeriode) || is_numeric($prijsEerstePeriode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsEerstePeriode, true), gettype($prijsEerstePeriode)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsEerstePeriode) && mb_strlen(mb_substr($prijsEerstePeriode, false !== mb_strpos($prijsEerstePeriode, '.') ? mb_strpos($prijsEerstePeriode, '.') + 1 : mb_strlen($prijsEerstePeriode))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsEerstePeriode, true), mb_strlen(mb_substr($prijsEerstePeriode, mb_strpos($prijsEerstePeriode, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsEerstePeriode) && mb_strlen(preg_replace('/(\D)/', '', $prijsEerstePeriode)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsEerstePeriode, true), mb_strlen(preg_replace('/(\D)/', '', $prijsEerstePeriode))), __LINE__);
        }
        $this->prijsEerstePeriode = $prijsEerstePeriode;
        return $this;
    }
    /**
     * Get prijsVervolgPeriode value
     * @return float
     */
    public function getPrijsVervolgPeriode()
    {
        return $this->prijsVervolgPeriode;
    }
    /**
     * Set prijsVervolgPeriode value
     * @param float $prijsVervolgPeriode
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setPrijsVervolgPeriode($prijsVervolgPeriode = null)
    {
        // validation for constraint: float
        if (!is_null($prijsVervolgPeriode) && !(is_float($prijsVervolgPeriode) || is_numeric($prijsVervolgPeriode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsVervolgPeriode, true), gettype($prijsVervolgPeriode)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsVervolgPeriode) && mb_strlen(mb_substr($prijsVervolgPeriode, false !== mb_strpos($prijsVervolgPeriode, '.') ? mb_strpos($prijsVervolgPeriode, '.') + 1 : mb_strlen($prijsVervolgPeriode))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsVervolgPeriode, true), mb_strlen(mb_substr($prijsVervolgPeriode, mb_strpos($prijsVervolgPeriode, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsVervolgPeriode) && mb_strlen(preg_replace('/(\D)/', '', $prijsVervolgPeriode)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsVervolgPeriode, true), mb_strlen(preg_replace('/(\D)/', '', $prijsVervolgPeriode))), __LINE__);
        }
        $this->prijsVervolgPeriode = $prijsVervolgPeriode;
        return $this;
    }
    /**
     * Get omschrijvingUitgebreid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijvingUitgebreid()
    {
        return isset($this->omschrijvingUitgebreid) ? $this->omschrijvingUitgebreid : null;
    }
    /**
     * Set omschrijvingUitgebreid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijvingUitgebreid
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setOmschrijvingUitgebreid($omschrijvingUitgebreid = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijvingUitgebreid) && !is_string($omschrijvingUitgebreid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijvingUitgebreid, true), gettype($omschrijvingUitgebreid)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($omschrijvingUitgebreid) && mb_strlen($omschrijvingUitgebreid) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($omschrijvingUitgebreid)), __LINE__);
        }
        if (is_null($omschrijvingUitgebreid) || (is_array($omschrijvingUitgebreid) && empty($omschrijvingUitgebreid))) {
            unset($this->omschrijvingUitgebreid);
        } else {
            $this->omschrijvingUitgebreid = $omschrijvingUitgebreid;
        }
        return $this;
    }
    /**
     * Get aboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortCode()
    {
        return isset($this->aboSoortCode) ? $this->aboSoortCode : null;
    }
    /**
     * Set aboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortCode
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setAboSoortCode($aboSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortCode) && !is_string($aboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortCode, true), gettype($aboSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aboSoortCode) && mb_strlen($aboSoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aboSoortCode)), __LINE__);
        }
        if (is_null($aboSoortCode) || (is_array($aboSoortCode) && empty($aboSoortCode))) {
            unset($this->aboSoortCode);
        } else {
            $this->aboSoortCode = $aboSoortCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \AbonnementApiV6\StructType\Actie
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
}
