<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboRelatie StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie informatie
 * @subpackage Structs
 * @date 20240419 package
 */
class AboRelatie extends AbstractStructBase
{
    /**
     * The aanhef
     * Meta information extracted from the WSDL
     * - documentation: Aanhef via de standaard functionaliteit van Zeno.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aanhef;
    /**
     * The achternaam
     * Meta information extracted from the WSDL
     * - documentation: Achternaam van de abonnee.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaam;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres van de abonnee.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The geboorteDatum
     * Meta information extracted from the WSDL
     * - documentation: Geboortedatum van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geboorteDatum;
    /**
     * The geslachtsIndicatie
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3] Indicatie geslacht: 0 = nvt, 1 = Man, 2 = Vrouw, 3 = Onbekend.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $geslachtsIndicatie;
    /**
     * The huisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer van het adres van de abonnee.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $huisNummer;
    /**
     * The huisNummerToev
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer toevoeging van het adres van de abonnee.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisNummerToev;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: Landcode van het land van de abonnee.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The plaats
     * Meta information extracted from the WSDL
     * - documentation: Woonplaats van het adres van de abonnee.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $plaats;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode van het adres van de abonnee.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The provincieCode
     * Meta information extracted from the WSDL
     * - documentation: Provinciecode van de provincie van de abonnee.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $provincieCode;
    /**
     * The relNoAbo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer abonnee.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAbo;
    /**
     * The straat
     * Meta information extracted from the WSDL
     * - documentation: Straat van het adres van de abonnee.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $straat;
    /**
     * The telefoonNummer
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer van de abonnee.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonNummer;
    /**
     * The telefoonNummerMobiel
     * Meta information extracted from the WSDL
     * - documentation: Mobiel telefoonnummer van de abonnee.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonNummerMobiel;
    /**
     * The titulatuurCode
     * Meta information extracted from the WSDL
     * - documentation: Titutatuur voor de abonnee.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $titulatuurCode;
    /**
     * The tussenvoegsel
     * Meta information extracted from the WSDL
     * - documentation: Tussenvoegsel van de abonnee.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tussenvoegsel;
    /**
     * The voorletters
     * Meta information extracted from the WSDL
     * - documentation: Voorletters van de abonnee.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorletters;
    /**
     * The voornaam
     * Meta information extracted from the WSDL
     * - documentation: Voornaam van de abonnee.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voornaam;
    /**
     * The rekeningNummer
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer van de abonnee.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rekeningNummer;
    /**
     * The rekeningIbanNummer
     * Meta information extracted from the WSDL
     * - documentation: IBAN van de abonnee.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rekeningIbanNummer;
    /**
     * The rekeningBicCode
     * Meta information extracted from the WSDL
     * - documentation: BIC van de abonnee.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rekeningBicCode;
    /**
     * The btwNummer
     * Meta information extracted from the WSDL
     * - documentation: BTW nummer van de abonnee.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwNummer;
    /**
     * The bedrijfsNaam
     * Meta information extracted from the WSDL
     * - documentation: Bedrijfsnaam.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bedrijfsNaam;
    /**
     * The uitsluitenVanMailing
     * Meta information extracted from the WSDL
     * - documentation: Deze relatie uitsluiten van mailing(s). Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande instelling voor relaties
     * bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $uitsluitenVanMailing;
    /**
     * The rechtVanBeperking
     * Meta information extracted from the WSDL
     * - documentation: Voor deze relatie geldt het recht van beperking op verwerking. Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande
     * instelling voor relaties bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $rechtVanBeperking;
    /**
     * The onvolledig
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of de gegevens van de relatie onvolledig zijn. Waarschuwing: zet deze indicatie niet zomaar aan. Dit betekent dat een aantal checks, bijv. het bestaan van een geldig adres, niet wordt uitgevoerd. De relatie kan desondanks
     * dan toch worden aangemaakt, maar dat zou procesmatig later wel een probleem kunnen vormen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $onvolledig;
    /**
     * The aboAbonnementen
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsgegevens: N.B. standaard worden alleen actieve of toekomstige abonnementen opgehaald. Abonnementen die afgesloten zijn worden door deze service teruggegeven afhankelijk van de instelling toonHistorie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AbonnementTab
     */
    public $aboAbonnementen;
    /**
     * Constructor method for AboRelatie
     * @uses AboRelatie::setAanhef()
     * @uses AboRelatie::setAchternaam()
     * @uses AboRelatie::setEmail()
     * @uses AboRelatie::setGeboorteDatum()
     * @uses AboRelatie::setGeslachtsIndicatie()
     * @uses AboRelatie::setHuisNummer()
     * @uses AboRelatie::setHuisNummerToev()
     * @uses AboRelatie::setLandCode()
     * @uses AboRelatie::setPlaats()
     * @uses AboRelatie::setPostcode()
     * @uses AboRelatie::setProvincieCode()
     * @uses AboRelatie::setRelNoAbo()
     * @uses AboRelatie::setStraat()
     * @uses AboRelatie::setTelefoonNummer()
     * @uses AboRelatie::setTelefoonNummerMobiel()
     * @uses AboRelatie::setTitulatuurCode()
     * @uses AboRelatie::setTussenvoegsel()
     * @uses AboRelatie::setVoorletters()
     * @uses AboRelatie::setVoornaam()
     * @uses AboRelatie::setRekeningNummer()
     * @uses AboRelatie::setRekeningIbanNummer()
     * @uses AboRelatie::setRekeningBicCode()
     * @uses AboRelatie::setBtwNummer()
     * @uses AboRelatie::setBedrijfsNaam()
     * @uses AboRelatie::setUitsluitenVanMailing()
     * @uses AboRelatie::setRechtVanBeperking()
     * @uses AboRelatie::setOnvolledig()
     * @uses AboRelatie::setAboAbonnementen()
     * @param string $aanhef
     * @param string $achternaam
     * @param string $email
     * @param string $geboorteDatum
     * @param int $geslachtsIndicatie
     * @param int $huisNummer
     * @param string $huisNummerToev
     * @param string $landCode
     * @param string $plaats
     * @param string $postcode
     * @param string $provincieCode
     * @param int $relNoAbo
     * @param string $straat
     * @param string $telefoonNummer
     * @param string $telefoonNummerMobiel
     * @param string $titulatuurCode
     * @param string $tussenvoegsel
     * @param string $voorletters
     * @param string $voornaam
     * @param string $rekeningNummer
     * @param string $rekeningIbanNummer
     * @param string $rekeningBicCode
     * @param string $btwNummer
     * @param string $bedrijfsNaam
     * @param bool $uitsluitenVanMailing
     * @param bool $rechtVanBeperking
     * @param bool $onvolledig
     * @param \AbonnementApiV6\StructType\AbonnementTab $aboAbonnementen
     */
    public function __construct($aanhef = null, $achternaam = null, $email = null, $geboorteDatum = null, $geslachtsIndicatie = null, $huisNummer = null, $huisNummerToev = null, $landCode = null, $plaats = null, $postcode = null, $provincieCode = null, $relNoAbo = null, $straat = null, $telefoonNummer = null, $telefoonNummerMobiel = null, $titulatuurCode = null, $tussenvoegsel = null, $voorletters = null, $voornaam = null, $rekeningNummer = null, $rekeningIbanNummer = null, $rekeningBicCode = null, $btwNummer = null, $bedrijfsNaam = null, $uitsluitenVanMailing = null, $rechtVanBeperking = null, $onvolledig = null, \AbonnementApiV6\StructType\AbonnementTab $aboAbonnementen = null)
    {
        $this
            ->setAanhef($aanhef)
            ->setAchternaam($achternaam)
            ->setEmail($email)
            ->setGeboorteDatum($geboorteDatum)
            ->setGeslachtsIndicatie($geslachtsIndicatie)
            ->setHuisNummer($huisNummer)
            ->setHuisNummerToev($huisNummerToev)
            ->setLandCode($landCode)
            ->setPlaats($plaats)
            ->setPostcode($postcode)
            ->setProvincieCode($provincieCode)
            ->setRelNoAbo($relNoAbo)
            ->setStraat($straat)
            ->setTelefoonNummer($telefoonNummer)
            ->setTelefoonNummerMobiel($telefoonNummerMobiel)
            ->setTitulatuurCode($titulatuurCode)
            ->setTussenvoegsel($tussenvoegsel)
            ->setVoorletters($voorletters)
            ->setVoornaam($voornaam)
            ->setRekeningNummer($rekeningNummer)
            ->setRekeningIbanNummer($rekeningIbanNummer)
            ->setRekeningBicCode($rekeningBicCode)
            ->setBtwNummer($btwNummer)
            ->setBedrijfsNaam($bedrijfsNaam)
            ->setUitsluitenVanMailing($uitsluitenVanMailing)
            ->setRechtVanBeperking($rechtVanBeperking)
            ->setOnvolledig($onvolledig)
            ->setAboAbonnementen($aboAbonnementen);
    }
    /**
     * Get aanhef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAanhef()
    {
        return isset($this->aanhef) ? $this->aanhef : null;
    }
    /**
     * Set aanhef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aanhef
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setAanhef($aanhef = null)
    {
        // validation for constraint: string
        if (!is_null($aanhef) && !is_string($aanhef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aanhef, true), gettype($aanhef)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($aanhef) && mb_strlen($aanhef) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($aanhef)), __LINE__);
        }
        if (is_null($aanhef) || (is_array($aanhef) && empty($aanhef))) {
            unset($this->aanhef);
        } else {
            $this->aanhef = $aanhef;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get geboorteDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboorteDatum()
    {
        return isset($this->geboorteDatum) ? $this->geboorteDatum : null;
    }
    /**
     * Set geboorteDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboorteDatum
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setGeboorteDatum($geboorteDatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboorteDatum) && !is_string($geboorteDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geboorteDatum, true), gettype($geboorteDatum)), __LINE__);
        }
        if (is_null($geboorteDatum) || (is_array($geboorteDatum) && empty($geboorteDatum))) {
            unset($this->geboorteDatum);
        } else {
            $this->geboorteDatum = $geboorteDatum;
        }
        return $this;
    }
    /**
     * Get geslachtsIndicatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGeslachtsIndicatie()
    {
        return isset($this->geslachtsIndicatie) ? $this->geslachtsIndicatie : null;
    }
    /**
     * Set geslachtsIndicatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $geslachtsIndicatie
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setGeslachtsIndicatie($geslachtsIndicatie = null)
    {
        // validation for constraint: int
        if (!is_null($geslachtsIndicatie) && !(is_int($geslachtsIndicatie) || ctype_digit($geslachtsIndicatie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geslachtsIndicatie, true), gettype($geslachtsIndicatie)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($geslachtsIndicatie) && mb_strlen(preg_replace('/(\D)/', '', $geslachtsIndicatie)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($geslachtsIndicatie, true), mb_strlen(preg_replace('/(\D)/', '', $geslachtsIndicatie))), __LINE__);
        }
        if (is_null($geslachtsIndicatie) || (is_array($geslachtsIndicatie) && empty($geslachtsIndicatie))) {
            unset($this->geslachtsIndicatie);
        } else {
            $this->geslachtsIndicatie = $geslachtsIndicatie;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $huisNummer
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: int
        if (!is_null($huisNummer) && !(is_int($huisNummer) || ctype_digit($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get huisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToev()
    {
        return isset($this->huisNummerToev) ? $this->huisNummerToev : null;
    }
    /**
     * Set huisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToev
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setHuisNummerToev($huisNummerToev = null)
    {
        // validation for constraint: string
        if (!is_null($huisNummerToev) && !is_string($huisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisNummerToev, true), gettype($huisNummerToev)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($huisNummerToev) && mb_strlen($huisNummerToev) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($huisNummerToev)), __LINE__);
        }
        if (is_null($huisNummerToev) || (is_array($huisNummerToev) && empty($huisNummerToev))) {
            unset($this->huisNummerToev);
        } else {
            $this->huisNummerToev = $huisNummerToev;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->plaats) ? $this->plaats : null;
    }
    /**
     * Set plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaats, true), gettype($plaats)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plaats) && mb_strlen($plaats) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->plaats);
        } else {
            $this->plaats = $plaats;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get provincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieCode()
    {
        return isset($this->provincieCode) ? $this->provincieCode : null;
    }
    /**
     * Set provincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieCode
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieCode, true), gettype($provincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($provincieCode)), __LINE__);
        }
        if (is_null($provincieCode) || (is_array($provincieCode) && empty($provincieCode))) {
            unset($this->provincieCode);
        } else {
            $this->provincieCode = $provincieCode;
        }
        return $this;
    }
    /**
     * Get relNoAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAbo()
    {
        return isset($this->relNoAbo) ? $this->relNoAbo : null;
    }
    /**
     * Set relNoAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAbo
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setRelNoAbo($relNoAbo = null)
    {
        // validation for constraint: int
        if (!is_null($relNoAbo) && !(is_int($relNoAbo) || ctype_digit($relNoAbo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoAbo, true), gettype($relNoAbo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoAbo) && mb_strlen(preg_replace('/(\D)/', '', $relNoAbo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoAbo, true), mb_strlen(preg_replace('/(\D)/', '', $relNoAbo))), __LINE__);
        }
        if (is_null($relNoAbo) || (is_array($relNoAbo) && empty($relNoAbo))) {
            unset($this->relNoAbo);
        } else {
            $this->relNoAbo = $relNoAbo;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($straat, true), gettype($straat)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($straat) && mb_strlen($straat) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get telefoonNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummer()
    {
        return isset($this->telefoonNummer) ? $this->telefoonNummer : null;
    }
    /**
     * Set telefoonNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummer
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setTelefoonNummer($telefoonNummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonNummer) && !is_string($telefoonNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonNummer, true), gettype($telefoonNummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonNummer) && mb_strlen($telefoonNummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonNummer)), __LINE__);
        }
        if (is_null($telefoonNummer) || (is_array($telefoonNummer) && empty($telefoonNummer))) {
            unset($this->telefoonNummer);
        } else {
            $this->telefoonNummer = $telefoonNummer;
        }
        return $this;
    }
    /**
     * Get telefoonNummerMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummerMobiel()
    {
        return isset($this->telefoonNummerMobiel) ? $this->telefoonNummerMobiel : null;
    }
    /**
     * Set telefoonNummerMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummerMobiel
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setTelefoonNummerMobiel($telefoonNummerMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonNummerMobiel) && !is_string($telefoonNummerMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonNummerMobiel, true), gettype($telefoonNummerMobiel)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonNummerMobiel) && mb_strlen($telefoonNummerMobiel) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonNummerMobiel)), __LINE__);
        }
        if (is_null($telefoonNummerMobiel) || (is_array($telefoonNummerMobiel) && empty($telefoonNummerMobiel))) {
            unset($this->telefoonNummerMobiel);
        } else {
            $this->telefoonNummerMobiel = $telefoonNummerMobiel;
        }
        return $this;
    }
    /**
     * Get titulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitulatuurCode()
    {
        return isset($this->titulatuurCode) ? $this->titulatuurCode : null;
    }
    /**
     * Set titulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titulatuurCode
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setTitulatuurCode($titulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($titulatuurCode) && !is_string($titulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulatuurCode, true), gettype($titulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($titulatuurCode) && mb_strlen($titulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($titulatuurCode)), __LINE__);
        }
        if (is_null($titulatuurCode) || (is_array($titulatuurCode) && empty($titulatuurCode))) {
            unset($this->titulatuurCode);
        } else {
            $this->titulatuurCode = $titulatuurCode;
        }
        return $this;
    }
    /**
     * Get tussenvoegsel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsel()
    {
        return isset($this->tussenvoegsel) ? $this->tussenvoegsel : null;
    }
    /**
     * Set tussenvoegsel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsel
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setTussenvoegsel($tussenvoegsel = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsel) && !is_string($tussenvoegsel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tussenvoegsel, true), gettype($tussenvoegsel)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($tussenvoegsel) && mb_strlen($tussenvoegsel) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($tussenvoegsel)), __LINE__);
        }
        if (is_null($tussenvoegsel) || (is_array($tussenvoegsel) && empty($tussenvoegsel))) {
            unset($this->tussenvoegsel);
        } else {
            $this->tussenvoegsel = $tussenvoegsel;
        }
        return $this;
    }
    /**
     * Get voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->voorletters) ? $this->voorletters : null;
    }
    /**
     * Set voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorletters, true), gettype($voorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($voorletters) && mb_strlen($voorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->voorletters);
        } else {
            $this->voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voornaam, true), gettype($voornaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($voornaam) && mb_strlen($voornaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get rekeningNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningNummer()
    {
        return isset($this->rekeningNummer) ? $this->rekeningNummer : null;
    }
    /**
     * Set rekeningNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningNummer
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setRekeningNummer($rekeningNummer = null)
    {
        // validation for constraint: string
        if (!is_null($rekeningNummer) && !is_string($rekeningNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rekeningNummer, true), gettype($rekeningNummer)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($rekeningNummer) && mb_strlen($rekeningNummer) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($rekeningNummer)), __LINE__);
        }
        if (is_null($rekeningNummer) || (is_array($rekeningNummer) && empty($rekeningNummer))) {
            unset($this->rekeningNummer);
        } else {
            $this->rekeningNummer = $rekeningNummer;
        }
        return $this;
    }
    /**
     * Get rekeningIbanNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningIbanNummer()
    {
        return isset($this->rekeningIbanNummer) ? $this->rekeningIbanNummer : null;
    }
    /**
     * Set rekeningIbanNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningIbanNummer
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setRekeningIbanNummer($rekeningIbanNummer = null)
    {
        // validation for constraint: string
        if (!is_null($rekeningIbanNummer) && !is_string($rekeningIbanNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rekeningIbanNummer, true), gettype($rekeningIbanNummer)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($rekeningIbanNummer) && mb_strlen($rekeningIbanNummer) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($rekeningIbanNummer)), __LINE__);
        }
        if (is_null($rekeningIbanNummer) || (is_array($rekeningIbanNummer) && empty($rekeningIbanNummer))) {
            unset($this->rekeningIbanNummer);
        } else {
            $this->rekeningIbanNummer = $rekeningIbanNummer;
        }
        return $this;
    }
    /**
     * Get rekeningBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningBicCode()
    {
        return isset($this->rekeningBicCode) ? $this->rekeningBicCode : null;
    }
    /**
     * Set rekeningBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningBicCode
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setRekeningBicCode($rekeningBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($rekeningBicCode) && !is_string($rekeningBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rekeningBicCode, true), gettype($rekeningBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($rekeningBicCode) && mb_strlen($rekeningBicCode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($rekeningBicCode)), __LINE__);
        }
        if (is_null($rekeningBicCode) || (is_array($rekeningBicCode) && empty($rekeningBicCode))) {
            unset($this->rekeningBicCode);
        } else {
            $this->rekeningBicCode = $rekeningBicCode;
        }
        return $this;
    }
    /**
     * Get btwNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwNummer()
    {
        return isset($this->btwNummer) ? $this->btwNummer : null;
    }
    /**
     * Set btwNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwNummer
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setBtwNummer($btwNummer = null)
    {
        // validation for constraint: string
        if (!is_null($btwNummer) && !is_string($btwNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwNummer, true), gettype($btwNummer)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($btwNummer) && mb_strlen($btwNummer) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($btwNummer)), __LINE__);
        }
        if (is_null($btwNummer) || (is_array($btwNummer) && empty($btwNummer))) {
            unset($this->btwNummer);
        } else {
            $this->btwNummer = $btwNummer;
        }
        return $this;
    }
    /**
     * Get bedrijfsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsNaam()
    {
        return isset($this->bedrijfsNaam) ? $this->bedrijfsNaam : null;
    }
    /**
     * Set bedrijfsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsNaam
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setBedrijfsNaam($bedrijfsNaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsNaam) && !is_string($bedrijfsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bedrijfsNaam, true), gettype($bedrijfsNaam)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($bedrijfsNaam) && mb_strlen($bedrijfsNaam) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($bedrijfsNaam)), __LINE__);
        }
        if (is_null($bedrijfsNaam) || (is_array($bedrijfsNaam) && empty($bedrijfsNaam))) {
            unset($this->bedrijfsNaam);
        } else {
            $this->bedrijfsNaam = $bedrijfsNaam;
        }
        return $this;
    }
    /**
     * Get uitsluitenVanMailing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUitsluitenVanMailing()
    {
        return isset($this->uitsluitenVanMailing) ? $this->uitsluitenVanMailing : null;
    }
    /**
     * Set uitsluitenVanMailing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $uitsluitenVanMailing
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setUitsluitenVanMailing($uitsluitenVanMailing = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitsluitenVanMailing) && !is_bool($uitsluitenVanMailing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitsluitenVanMailing, true), gettype($uitsluitenVanMailing)), __LINE__);
        }
        if (is_null($uitsluitenVanMailing) || (is_array($uitsluitenVanMailing) && empty($uitsluitenVanMailing))) {
            unset($this->uitsluitenVanMailing);
        } else {
            $this->uitsluitenVanMailing = $uitsluitenVanMailing;
        }
        return $this;
    }
    /**
     * Get rechtVanBeperking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRechtVanBeperking()
    {
        return isset($this->rechtVanBeperking) ? $this->rechtVanBeperking : null;
    }
    /**
     * Set rechtVanBeperking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $rechtVanBeperking
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setRechtVanBeperking($rechtVanBeperking = null)
    {
        // validation for constraint: boolean
        if (!is_null($rechtVanBeperking) && !is_bool($rechtVanBeperking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rechtVanBeperking, true), gettype($rechtVanBeperking)), __LINE__);
        }
        if (is_null($rechtVanBeperking) || (is_array($rechtVanBeperking) && empty($rechtVanBeperking))) {
            unset($this->rechtVanBeperking);
        } else {
            $this->rechtVanBeperking = $rechtVanBeperking;
        }
        return $this;
    }
    /**
     * Get onvolledig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnvolledig()
    {
        return isset($this->onvolledig) ? $this->onvolledig : null;
    }
    /**
     * Set onvolledig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onvolledig
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setOnvolledig($onvolledig = null)
    {
        // validation for constraint: boolean
        if (!is_null($onvolledig) && !is_bool($onvolledig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onvolledig, true), gettype($onvolledig)), __LINE__);
        }
        if (is_null($onvolledig) || (is_array($onvolledig) && empty($onvolledig))) {
            unset($this->onvolledig);
        } else {
            $this->onvolledig = $onvolledig;
        }
        return $this;
    }
    /**
     * Get aboAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AbonnementTab|null
     */
    public function getAboAbonnementen()
    {
        return isset($this->aboAbonnementen) ? $this->aboAbonnementen : null;
    }
    /**
     * Set aboAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AbonnementTab $aboAbonnementen
     * @return \AbonnementApiV6\StructType\AboRelatie
     */
    public function setAboAbonnementen(\AbonnementApiV6\StructType\AbonnementTab $aboAbonnementen = null)
    {
        if (is_null($aboAbonnementen) || (is_array($aboAbonnementen) && empty($aboAbonnementen))) {
            unset($this->aboAbonnementen);
        } else {
            $this->aboAbonnementen = $aboAbonnementen;
        }
        return $this;
    }
}
