<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden abonnements pakketten.
 * @subpackage Structs
 * @date 20240419 package
 */
class AboPakketInfo extends AbstractStructBase
{
    /**
     * The aboPakket
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden abonnements pakketten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboPakket[]
     */
    public $aboPakket;
    /**
     * Constructor method for AboPakketInfo
     * @uses AboPakketInfo::setAboPakket()
     * @param \AbonnementApiV6\StructType\AboPakket[] $aboPakket
     */
    public function __construct(array $aboPakket = array())
    {
        $this
            ->setAboPakket($aboPakket);
    }
    /**
     * Get aboPakket value
     * @return \AbonnementApiV6\StructType\AboPakket[]|null
     */
    public function getAboPakket()
    {
        return $this->aboPakket;
    }
    /**
     * This method is responsible for validating the values passed to the setAboPakket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboPakket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboPakketForArrayConstraintsFromSetAboPakket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aboPakketInfoAboPakketItem) {
            // validation for constraint: itemType
            if (!$aboPakketInfoAboPakketItem instanceof \AbonnementApiV6\StructType\AboPakket) {
                $invalidValues[] = is_object($aboPakketInfoAboPakketItem) ? get_class($aboPakketInfoAboPakketItem) : sprintf('%s(%s)', gettype($aboPakketInfoAboPakketItem), var_export($aboPakketInfoAboPakketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aboPakket property can only contain items of type \AbonnementApiV6\StructType\AboPakket, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aboPakket value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboPakket[] $aboPakket
     * @return \AbonnementApiV6\StructType\AboPakketInfo
     */
    public function setAboPakket(array $aboPakket = array())
    {
        // validation for constraint: array
        if ('' !== ($aboPakketArrayErrorMessage = self::validateAboPakketForArrayConstraintsFromSetAboPakket($aboPakket))) {
            throw new \InvalidArgumentException($aboPakketArrayErrorMessage, __LINE__);
        }
        $this->aboPakket = $aboPakket;
        return $this;
    }
    /**
     * Add item to aboPakket value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboPakket $item
     * @return \AbonnementApiV6\StructType\AboPakketInfo
     */
    public function addToAboPakket(\AbonnementApiV6\StructType\AboPakket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\AboPakket) {
            throw new \InvalidArgumentException(sprintf('The aboPakket property can only contain items of type \AbonnementApiV6\StructType\AboPakket, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aboPakket[] = $item;
        return $this;
    }
}
