<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketAanvProd StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanvullend product object onder dit abonnements pakket
 * @subpackage Structs
 * @date 20240419 package
 */
class AboPakketAanvProd extends AbstractStructBase
{
    /**
     * The artikelCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de onderliggende aanvullende product.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelCode;
    /**
     * The artikelNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de onderliggende aanvullende product.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelNaam;
    /**
     * The onderdeelPrijsInclBtw
     * Meta information extracted from the WSDL
     * - documentation: Onderdeel prijs inclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsInclBtw;
    /**
     * The onderdeelPrijsExclBtw
     * Meta information extracted from the WSDL
     * - documentation: Onderdeel prijs exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsExclBtw;
    /**
     * The btwCode
     * Meta information extracted from the WSDL
     * - documentation: BTW code.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwCode;
    /**
     * The btwOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: BTW omschrijving.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwOmschrijving;
    /**
     * The btwPercentage
     * Meta information extracted from the WSDL
     * - documentation: BTW percentage.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 6
     * @var float
     */
    public $btwPercentage;
    /**
     * Constructor method for AboPakketAanvProd
     * @uses AboPakketAanvProd::setArtikelCode()
     * @uses AboPakketAanvProd::setArtikelNaam()
     * @uses AboPakketAanvProd::setOnderdeelPrijsInclBtw()
     * @uses AboPakketAanvProd::setOnderdeelPrijsExclBtw()
     * @uses AboPakketAanvProd::setBtwCode()
     * @uses AboPakketAanvProd::setBtwOmschrijving()
     * @uses AboPakketAanvProd::setBtwPercentage()
     * @param string $artikelCode
     * @param string $artikelNaam
     * @param float $onderdeelPrijsInclBtw
     * @param float $onderdeelPrijsExclBtw
     * @param string $btwCode
     * @param string $btwOmschrijving
     * @param float $btwPercentage
     */
    public function __construct($artikelCode = null, $artikelNaam = null, $onderdeelPrijsInclBtw = null, $onderdeelPrijsExclBtw = null, $btwCode = null, $btwOmschrijving = null, $btwPercentage = null)
    {
        $this
            ->setArtikelCode($artikelCode)
            ->setArtikelNaam($artikelNaam)
            ->setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw)
            ->setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw)
            ->setBtwCode($btwCode)
            ->setBtwOmschrijving($btwOmschrijving)
            ->setBtwPercentage($btwPercentage);
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelCode, true), gettype($artikelCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get artikelNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelNaam()
    {
        return isset($this->artikelNaam) ? $this->artikelNaam : null;
    }
    /**
     * Set artikelNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelNaam
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setArtikelNaam($artikelNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelNaam) && !is_string($artikelNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelNaam, true), gettype($artikelNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($artikelNaam) && mb_strlen($artikelNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($artikelNaam)), __LINE__);
        }
        if (is_null($artikelNaam) || (is_array($artikelNaam) && empty($artikelNaam))) {
            unset($this->artikelNaam);
        } else {
            $this->artikelNaam = $artikelNaam;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsInclBtw()
    {
        return isset($this->onderdeelPrijsInclBtw) ? $this->onderdeelPrijsInclBtw : null;
    }
    /**
     * Set onderdeelPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsInclBtw
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($onderdeelPrijsInclBtw) && !(is_float($onderdeelPrijsInclBtw) || is_numeric($onderdeelPrijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onderdeelPrijsInclBtw, true), gettype($onderdeelPrijsInclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($onderdeelPrijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $onderdeelPrijsInclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($onderdeelPrijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $onderdeelPrijsInclBtw))), __LINE__);
        }
        if (is_null($onderdeelPrijsInclBtw) || (is_array($onderdeelPrijsInclBtw) && empty($onderdeelPrijsInclBtw))) {
            unset($this->onderdeelPrijsInclBtw);
        } else {
            $this->onderdeelPrijsInclBtw = $onderdeelPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsExclBtw()
    {
        return isset($this->onderdeelPrijsExclBtw) ? $this->onderdeelPrijsExclBtw : null;
    }
    /**
     * Set onderdeelPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsExclBtw
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($onderdeelPrijsExclBtw) && !(is_float($onderdeelPrijsExclBtw) || is_numeric($onderdeelPrijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onderdeelPrijsExclBtw, true), gettype($onderdeelPrijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($onderdeelPrijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $onderdeelPrijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($onderdeelPrijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $onderdeelPrijsExclBtw))), __LINE__);
        }
        if (is_null($onderdeelPrijsExclBtw) || (is_array($onderdeelPrijsExclBtw) && empty($onderdeelPrijsExclBtw))) {
            unset($this->onderdeelPrijsExclBtw);
        } else {
            $this->onderdeelPrijsExclBtw = $onderdeelPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get btwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwCode()
    {
        return isset($this->btwCode) ? $this->btwCode : null;
    }
    /**
     * Set btwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwCode
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwCode, true), gettype($btwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($btwCode) && mb_strlen($btwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($btwCode)), __LINE__);
        }
        if (is_null($btwCode) || (is_array($btwCode) && empty($btwCode))) {
            unset($this->btwCode);
        } else {
            $this->btwCode = $btwCode;
        }
        return $this;
    }
    /**
     * Get btwOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwOmschrijving()
    {
        return isset($this->btwOmschrijving) ? $this->btwOmschrijving : null;
    }
    /**
     * Set btwOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwOmschrijving
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setBtwOmschrijving($btwOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($btwOmschrijving) && !is_string($btwOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwOmschrijving, true), gettype($btwOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($btwOmschrijving) && mb_strlen($btwOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($btwOmschrijving)), __LINE__);
        }
        if (is_null($btwOmschrijving) || (is_array($btwOmschrijving) && empty($btwOmschrijving))) {
            unset($this->btwOmschrijving);
        } else {
            $this->btwOmschrijving = $btwOmschrijving;
        }
        return $this;
    }
    /**
     * Get btwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPercentage()
    {
        return isset($this->btwPercentage) ? $this->btwPercentage : null;
    }
    /**
     * Set btwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPercentage
     * @return \AbonnementApiV6\StructType\AboPakketAanvProd
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($btwPercentage) && !(is_float($btwPercentage) || is_numeric($btwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPercentage, true), gettype($btwPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($btwPercentage) && mb_strlen(mb_substr($btwPercentage, false !== mb_strpos($btwPercentage, '.') ? mb_strpos($btwPercentage, '.') + 1 : mb_strlen($btwPercentage))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($btwPercentage, true), mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($btwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $btwPercentage)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($btwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $btwPercentage))), __LINE__);
        }
        if (is_null($btwPercentage) || (is_array($btwPercentage) && empty($btwPercentage))) {
            unset($this->btwPercentage);
        } else {
            $this->btwPercentage = $btwPercentage;
        }
        return $this;
    }
}
