<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renew ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Renew extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named renewAbonnement
     * Meta information extracted from the WSDL
     * - documentation: Een bestaand, gestopt abonnement, renewen. Hierbij moet een van deze combinatie aan parameters meegegeven worden:<br/> <ul><li>aboNo</li> <li>uitgaveCode en relatieNo</li> <li>uitgaveCode en emailAdres</li> </ul>error1: Kan geen
     * abonnement vinden voor opgegeven aboNo of uitgaveCode+relatieNo/emailAdreserror2: renewPerWanneer heeft een ongeldige waarde.error3: renewPerEditie mag alleen worden opgegeven als renewPerWanneer=specifieke_editieerror4: renewPerEditie moet groter
     * zijn dan de huidige stopeditie van het abonnementerror5: renewNaarAbonnement heeft een ongeldige waardeerror6: Als renewNaarAbonnement=zelfde, moeten renewNaarAbosoortCode, renewNaarActieCode en renewNaarPakketCode leeg zijnerror7: Als
     * renewNaarAbonnement=ander, mag alleen renewNaarAbosoortCode of renewNaarActieCode of renewNaarPakketCode gevuld zijn.error8: Het huidige abonnement is niet gestopt.error9: De abonnementsoort van het huidige abonnement is niet van een geldig
     * typeerror10: Het abonnement is reeds gerenewed.error11: Kan geen volgende editie bepalen voor het huidige abonnementerror12: Het is niet mogelijk om dit abonnement te renewen, het is reeds definitief stopgezet.error13: Bij betaalwijze 3 (iDeal) moet
     * een betaalReferentie worden opgegevenerror50: Er is een onbekende foutmelding opgetreden.error51: De renew-optie is niet actief
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\RenewAbonnementRequest $request_parameters
     * @return \AbonnementApiV6\StructType\RenewAbonnementResponse|bool
     */
    public function renewAbonnement(\AbonnementApiV6\StructType\RenewAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->renewAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\RenewAbonnementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
