<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getUitgaveInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met uitgaven terug.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetUitgaveInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetUitgaveInfoResponse|bool
     */
    public function getUitgaveInfo(\AbonnementApiV6\StructType\GetUitgaveInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUitgaveInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAbonnementsoortInfo
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een of meerdere abonnementsoorten. Hierbij kan gezocht worden op basis van de abonnementsoortcode, de uitgavecode en op inactieve abonnementsoorten.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetAbonnementsoortInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetAbonnementsoortInfoResponse|bool
     */
    public function getAbonnementsoortInfo(\AbonnementApiV6\StructType\GetAbonnementsoortInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAbonnementsoortInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPakketInfo
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een of meerdere (abonnements) pakketten. Hierbij kan gezocht worden op basis van de pakketcode en op inactieve pakketten.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetPakketInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetPakketInfoResponse|bool
     */
    public function getPakketInfo(\AbonnementApiV6\StructType\GetPakketInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPakketInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActieInfo
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van gegeven svan de acties voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetActieInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetActieInfoResponse|bool
     */
    public function getActieInfo(\AbonnementApiV6\StructType\GetActieInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getActieInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPropositieInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft informatie terug over een propositie voor de gegeven actieCode</p> <p>In de default implementatie worden alleen gegevens terugegeven voor abonnementsoorten die bij de Actieve Stamgegevens op actief zijn gezet.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetPropositieInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetPropositieInfoResponse|bool
     */
    public function getPropositieInfo(\AbonnementApiV6\StructType\GetPropositieInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPropositieInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAbonnementInfo
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van abonnements informatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetAbonnementInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoResponse|bool
     */
    public function getAbonnementInfo(\AbonnementApiV6\StructType\GetAbonnementInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAbonnementInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmartcodeByAboNo
     * Meta information extracted from the WSDL
     * - documentation: Geeft de smartcode van een abonnement nummer terug.error266: Op basis van het abonnement is geen smartcode gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetSmartcodeByAboNoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetSmartcodeByAboNoResponse|bool
     */
    public function getSmartcodeByAboNo(\AbonnementApiV6\StructType\GetSmartcodeByAboNoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSmartcodeByAboNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieAbosoortPrijs
     * Meta information extracted from the WSDL
     * - documentation: Geeft de prijs terug van een abonnementsoort die voor een relatie geldterror21: De debiteur is niet gevondenerror92: De abonnementsoort is niet bekenderror93: De abonnee is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse|bool
     */
    public function getRelatieAbosoortPrijs(\AbonnementApiV6\StructType\GetRelatieAbosoortPrijsRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatieAbosoortPrijs($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalamiteitInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft informatie over calamiteiten die gelden voor de distributie van een krant naar een relatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetCalamiteitInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoResponse|bool
     */
    public function getCalamiteitInfo(\AbonnementApiV6\StructType\GetCalamiteitInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalamiteitInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalamiteitInfoByPcHnr
     * Meta information extracted from the WSDL
     * - documentation: Geeft informatie over calamiteiten die actief zijn voor de distributie van een krant op een specifiek adres.error186: Opgegeven postcode is niet geldigerror999: Deze functionaliteit is niet geimplementeerd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrResponse|bool
     */
    public function getCalamiteitInfoByPcHnr(\AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalamiteitInfoByPcHnr($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHerkomstInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft de herkomstcodes op die gelden voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetHerkomstInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetHerkomstInfoResponse|bool
     */
    public function getHerkomstInfo(\AbonnementApiV6\StructType\GetHerkomstInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHerkomstInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSwitchProposities
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met proposities terug waar een abonnement naartoe kan switchenerror1: Het abonnement is niet gevondenerror12: Er is geen abonnement opgegevenerror34: De actie is niet gevondenerror57: De actie is niet actieferror84:
     * Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding kan dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request)error85: Het is niet mogelijk een proefabonnement aan te makenerror95: De
     * ingangsdatum van de actie is nog niet ingegaanerror96: De einddatum van de actie is verstrekenerror180: Geen geldig switchmogelijkheid gevondenerror282: Het is niet mogelijk een actieabonnement aan te makenerror283: Het op te volgen abonnement is
     * geen actieabonnement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetSwitchPropositiesRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetSwitchPropositiesResponse|bool
     */
    public function getSwitchProposities(\AbonnementApiV6\StructType\GetSwitchPropositiesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSwitchProposities($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLeverbareProductenInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan welke producten er leverbaar zijn voor de opgegeven relatie.error182: De combinatie postcode/huisnummer is ongeldigerror186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletterserror187: Het
     * huisnummer dient geheel te bestaan uit cijfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetLeverbareProductenInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetLeverbareProductenInfoResponse|bool
     */
    public function getLeverbareProductenInfo(\AbonnementApiV6\StructType\GetLeverbareProductenInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLeverbareProductenInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRolInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft alle rollen terug die gedefinieerd zijn voor een bepaalde uitgave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetRolInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetRolInfoResponse|bool
     */
    public function getRolInfo(\AbonnementApiV6\StructType\GetRolInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRolInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicentiehouders
     * Meta information extracted from the WSDL
     * - documentation: Geeft terug wat de licentiehouders van een bepaald abonnement is.error1: Het abonnement is niet gevondenerror238: De licentiehouder is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetLicentiehoudersRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetLicentiehoudersResponse|bool
     */
    public function getLicentiehouders(\AbonnementApiV6\StructType\GetLicentiehoudersRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLicentiehouders($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFactSamenvatInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met factuur samenvattingen per debiteur relatienummer. <ul><li>Er wordt alleen samenvattende informatie op hoofdlijnen getoond, geen gedetailleerde specificatie per factuur.</li> <li>Deze operatie kan alleen worden
     * aangeroepen als deze is geimplementeerd.</li></ul>error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de opgegeven relNo.error999: Deze functionaliteit is niet geimplementeerd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetFactSamenvatInfoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetFactSamenvatInfoResponse|bool
     */
    public function getFactSamenvatInfo(\AbonnementApiV6\StructType\GetFactSamenvatInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFactSamenvatInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getToekomstigeMutaties
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met toekomstige mutaties per relatienummer. Toekomstige mutaties zijn bijvoorbeeld vakantie regelingen of verhuizingen.error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de
     * opgegeven relNo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetToekomstigeMutatiesRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetToekomstigeMutatiesResponse|bool
     */
    public function getToekomstigeMutaties(\AbonnementApiV6\StructType\GetToekomstigeMutatiesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getToekomstigeMutaties($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEdities
     * Meta information extracted from the WSDL
     * - documentation: Retourneert een lijst van toekomstige (nog niet verschenen) edities. Selectie is mogelijk op basis van een abonnement of een uitgave. Met parameter aantal_edities kan gestuurd worden tot hoeveel toekomstige edities er geretourneerd
     * hoeven worden.error2: Het abonnement is niet gevonden op basis van de opgegeven aboNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetEditiesRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetEditiesResponse|bool
     */
    public function getEdities(\AbonnementApiV6\StructType\GetEditiesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEdities($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEersteVerschijning
     * Meta information extracted from the WSDL
     * - documentation: Retourneert de eerste nog niet verzonden editie van de opgegeven datum of daarna. Als er geen datum wordt meegegeven dan wordt uitgegaan van vandaag.error2: Het abonnement is niet gevonden op basis van de opgegeven aboNoerror254: De
     * uitgave is niet gevonden op basis van de opgegeven uitgaveCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\GetEersteVerschijningRequest $request_parameters
     * @return \AbonnementApiV6\StructType\GetEersteVerschijningResponse|bool
     */
    public function getEersteVerschijning(\AbonnementApiV6\StructType\GetEersteVerschijningRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEersteVerschijning($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoResponse|\AbonnementApiV6\StructType\GetAbonnementsoortInfoResponse|\AbonnementApiV6\StructType\GetActieInfoResponse|\AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrResponse|\AbonnementApiV6\StructType\GetCalamiteitInfoResponse|\AbonnementApiV6\StructType\GetEditiesResponse|\AbonnementApiV6\StructType\GetEersteVerschijningResponse|\AbonnementApiV6\StructType\GetFactSamenvatInfoResponse|\AbonnementApiV6\StructType\GetHerkomstInfoResponse|\AbonnementApiV6\StructType\GetLeverbareProductenInfoResponse|\AbonnementApiV6\StructType\GetLicentiehoudersResponse|\AbonnementApiV6\StructType\GetPakketInfoResponse|\AbonnementApiV6\StructType\GetPropositieInfoResponse|\AbonnementApiV6\StructType\GetRelatieAbosoortPrijsResponse|\AbonnementApiV6\StructType\GetRolInfoResponse|\AbonnementApiV6\StructType\GetSmartcodeByAboNoResponse|\AbonnementApiV6\StructType\GetSwitchPropositiesResponse|\AbonnementApiV6\StructType\GetToekomstigeMutatiesResponse|\AbonnementApiV6\StructType\GetUitgaveInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
