<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkProefabo
     * Meta information extracted from the WSDL
     * - documentation: Met deze webservice kan worden gecontroleerd of een relatie (obv zijn gegeven e-mail adres of postcode/huisnummer/toevoeging combinatie) al een proefabonnement heeft gehad dat gestart is binnen de afgelopen x maanden. Deze periode is
     * op te geven in de Zeno constantenkaart.error1: Controle op eerdere proefabonnementen staat niet aan.error2: Ongeldige uitgavecode meegegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\CheckProefaboRequest $request_parameters
     * @return \AbonnementApiV6\StructType\CheckProefaboResponse|bool
     */
    public function checkProefabo(\AbonnementApiV6\StructType\CheckProefaboRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkProefabo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkActieabo
     * Meta information extracted from the WSDL
     * - documentation: Met deze webservice kan worden gecontroleerd of een relatie (obv zijn gegeven e-mail adres of postcode/huisnummer/toevoeging combinatie) al een actieabonnement heeft gehad dat gestart is binnen de afgelopen x maanden. Deze periode is
     * op te geven in de Zeno constantenkaart.error1: Controle op eerdere actieabonnementen staat niet aan.error2: Ongeldige uitgavecode meegegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\CheckActieaboRequest $request_parameters
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse|bool
     */
    public function checkActieabo(\AbonnementApiV6\StructType\CheckActieaboRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkActieabo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\CheckActieaboResponse|\AbonnementApiV6\StructType\CheckProefaboResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
