<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bestaat ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Bestaat extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bestaatActiefAbonnement
     * Meta information extracted from the WSDL
     * - documentation: Check op een adres in combinatie met achternaam of daar al een actief abonnement aanwezig is. Deze controle houdt alleen rekening met nederlandse adressen.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\BestaatActiefAbonnementRequest $request_parameters
     * @return \AbonnementApiV6\StructType\BestaatActiefAbonnementResponse|bool
     */
    public function bestaatActiefAbonnement(\AbonnementApiV6\StructType\BestaatActiefAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bestaatActiefAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\BestaatActiefAbonnementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
