<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addLicentiehouderRol
     * Meta information extracted from the WSDL
     * - documentation: Toevoegen van een rol aan een licentiehouder van een abonnement.error236: De opgegeven rol is niet gevonden bij de uitgave van het abonnementerror238: De licentiehouder is niet gevondenerror247: De opgegeven rol is al gekoppeld bij
     * de licentiehouder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\AddLicentiehouderRolRequest $request_parameters
     * @return \AbonnementApiV6\StructType\AddLicentiehouderRolResponse|bool
     */
    public function addLicentiehouderRol(\AbonnementApiV6\StructType\AddLicentiehouderRolRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addLicentiehouderRol($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLicentiehouder
     * Meta information extracted from the WSDL
     * - documentation: Toevoegen van een licentiehouder bij een abonnement.error1: Het abonnement is niet gevonden.error5: De relatie is niet gevonden.error12: Er is geen abonnement opgegeven.error19: Er is geen relatie opgegeven.error236: De opgegeven rol
     * is niet gevonden bij de uitgave van het abonnement.error239: Het abonnement is geen licentieabonnement.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\AddLicentiehouderRequest $request_parameters
     * @return \AbonnementApiV6\StructType\AddLicentiehouderResponse|bool
     */
    public function addLicentiehouder(\AbonnementApiV6\StructType\AddLicentiehouderRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addLicentiehouder($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\AddLicentiehouderResponse|\AbonnementApiV6\StructType\AddLicentiehouderRolResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
