<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateLicentieRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Hoogt het aantal licenties van een licentieabonnement op. <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen
 * worden leeg gemaakt door de update.
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdateLicentieRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Het abonnementsnummer waarvoor het aantal licenties verhoogd moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aantalLicenties
     * Meta information extracted from the WSDL
     * - documentation: Het nieuwe aantal licenties.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aantalLicenties;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer dat het aantal licenties heeft verhoofd.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The emailAdres
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres van de relatie die het aantal licenties heeft verhoogd.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emailAdres;
    /**
     * Constructor method for updateLicentieRequest
     * @uses UpdateLicentieRequest::setAboNo()
     * @uses UpdateLicentieRequest::setAantalLicenties()
     * @uses UpdateLicentieRequest::setRelNo()
     * @uses UpdateLicentieRequest::setRequestTag()
     * @uses UpdateLicentieRequest::setEmailAdres()
     * @param int $aboNo
     * @param float $aantalLicenties
     * @param int $relNo
     * @param string $requestTag
     * @param string $emailAdres
     */
    public function __construct($aboNo = null, $aantalLicenties = null, $relNo = null, $requestTag = null, $emailAdres = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAantalLicenties($aantalLicenties)
            ->setRelNo($relNo)
            ->setRequestTag($requestTag)
            ->setEmailAdres($emailAdres);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\UpdateLicentieRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aantalLicenties value
     * @return float
     */
    public function getAantalLicenties()
    {
        return $this->aantalLicenties;
    }
    /**
     * Set aantalLicenties value
     * @param float $aantalLicenties
     * @return \AbonnementApiV6\StructType\UpdateLicentieRequest
     */
    public function setAantalLicenties($aantalLicenties = null)
    {
        // validation for constraint: float
        if (!is_null($aantalLicenties) && !(is_float($aantalLicenties) || is_numeric($aantalLicenties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalLicenties, true), gettype($aantalLicenties)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalLicenties) && mb_strlen(preg_replace('/(\D)/', '', $aantalLicenties)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalLicenties, true), mb_strlen(preg_replace('/(\D)/', '', $aantalLicenties))), __LINE__);
        }
        $this->aantalLicenties = $aantalLicenties;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\UpdateLicentieRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\UpdateLicentieRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \AbonnementApiV6\StructType\UpdateLicentieRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdres, true), gettype($emailAdres)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
}
