<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveObject StructType
 * Meta information extracted from the WSDL
 * - documentation: Uitgave object t.b.v getLeverbareProducten.
 * @subpackage Structs
 * @date 20240419 package
 */
class UitgaveObject extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de uitgave.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The uitgaveReguliereBezorging
     * Meta information extracted from the WSDL
     * - documentation: Reguliere bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgaveReguliereBezorging;
    /**
     * The uitgavePostBezorging
     * Meta information extracted from the WSDL
     * - documentation: Post bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgavePostBezorging;
    /**
     * The afschalenPer
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of en per wanneer de uitgave wordt afgeschaald voor het opgegeven adres.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afschalenPer;
    /**
     * The communicerenPer
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan vanaf wanneer de afschaling wordt gecommuniceerd met de klant
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $communicerenPer;
    /**
     * Constructor method for UitgaveObject
     * @uses UitgaveObject::setUitgaveCode()
     * @uses UitgaveObject::setUitgaveNaam()
     * @uses UitgaveObject::setUitgaveReguliereBezorging()
     * @uses UitgaveObject::setUitgavePostBezorging()
     * @uses UitgaveObject::setAfschalenPer()
     * @uses UitgaveObject::setCommunicerenPer()
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param bool $uitgaveReguliereBezorging
     * @param bool $uitgavePostBezorging
     * @param string $afschalenPer
     * @param string $communicerenPer
     */
    public function __construct($uitgaveCode = null, $uitgaveNaam = null, $uitgaveReguliereBezorging = null, $uitgavePostBezorging = null, $afschalenPer = null, $communicerenPer = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setUitgaveReguliereBezorging($uitgaveReguliereBezorging)
            ->setUitgavePostBezorging($uitgavePostBezorging)
            ->setAfschalenPer($afschalenPer)
            ->setCommunicerenPer($communicerenPer);
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * @return string
     */
    public function getUitgaveNaam()
    {
        return $this->uitgaveNaam;
    }
    /**
     * Set uitgaveNaam value
     * @param string $uitgaveNaam
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveNaam)), __LINE__);
        }
        $this->uitgaveNaam = $uitgaveNaam;
        return $this;
    }
    /**
     * Get uitgaveReguliereBezorging value
     * @return bool
     */
    public function getUitgaveReguliereBezorging()
    {
        return $this->uitgaveReguliereBezorging;
    }
    /**
     * Set uitgaveReguliereBezorging value
     * @param bool $uitgaveReguliereBezorging
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setUitgaveReguliereBezorging($uitgaveReguliereBezorging = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitgaveReguliereBezorging) && !is_bool($uitgaveReguliereBezorging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitgaveReguliereBezorging, true), gettype($uitgaveReguliereBezorging)), __LINE__);
        }
        $this->uitgaveReguliereBezorging = $uitgaveReguliereBezorging;
        return $this;
    }
    /**
     * Get uitgavePostBezorging value
     * @return bool
     */
    public function getUitgavePostBezorging()
    {
        return $this->uitgavePostBezorging;
    }
    /**
     * Set uitgavePostBezorging value
     * @param bool $uitgavePostBezorging
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setUitgavePostBezorging($uitgavePostBezorging = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitgavePostBezorging) && !is_bool($uitgavePostBezorging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitgavePostBezorging, true), gettype($uitgavePostBezorging)), __LINE__);
        }
        $this->uitgavePostBezorging = $uitgavePostBezorging;
        return $this;
    }
    /**
     * Get afschalenPer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfschalenPer()
    {
        return isset($this->afschalenPer) ? $this->afschalenPer : null;
    }
    /**
     * Set afschalenPer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afschalenPer
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setAfschalenPer($afschalenPer = null)
    {
        // validation for constraint: string
        if (!is_null($afschalenPer) && !is_string($afschalenPer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afschalenPer, true), gettype($afschalenPer)), __LINE__);
        }
        if (is_null($afschalenPer) || (is_array($afschalenPer) && empty($afschalenPer))) {
            unset($this->afschalenPer);
        } else {
            $this->afschalenPer = $afschalenPer;
        }
        return $this;
    }
    /**
     * Get communicerenPer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicerenPer()
    {
        return isset($this->communicerenPer) ? $this->communicerenPer : null;
    }
    /**
     * Set communicerenPer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicerenPer
     * @return \AbonnementApiV6\StructType\UitgaveObject
     */
    public function setCommunicerenPer($communicerenPer = null)
    {
        // validation for constraint: string
        if (!is_null($communicerenPer) && !is_string($communicerenPer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicerenPer, true), gettype($communicerenPer)), __LINE__);
        }
        if (is_null($communicerenPer) || (is_array($communicerenPer) && empty($communicerenPer))) {
            unset($this->communicerenPer);
        } else {
            $this->communicerenPer = $communicerenPer;
        }
        return $this;
    }
}
