<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met uitgaven.
 * @subpackage Structs
 * @date 20240419 package
 */
class UitgaveInfo extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta information extracted from the WSDL
     * - documentation: Lijst met uitgaven.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Uitgave[]
     */
    public $uitgave;
    /**
     * Constructor method for UitgaveInfo
     * @uses UitgaveInfo::setUitgave()
     * @param \AbonnementApiV6\StructType\Uitgave[] $uitgave
     */
    public function __construct(array $uitgave = array())
    {
        $this
            ->setUitgave($uitgave);
    }
    /**
     * Get uitgave value
     * @return \AbonnementApiV6\StructType\Uitgave[]|null
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * This method is responsible for validating the values passed to the setUitgave method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUitgave method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUitgaveForArrayConstraintsFromSetUitgave(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uitgaveInfoUitgaveItem) {
            // validation for constraint: itemType
            if (!$uitgaveInfoUitgaveItem instanceof \AbonnementApiV6\StructType\Uitgave) {
                $invalidValues[] = is_object($uitgaveInfoUitgaveItem) ? get_class($uitgaveInfoUitgaveItem) : sprintf('%s(%s)', gettype($uitgaveInfoUitgaveItem), var_export($uitgaveInfoUitgaveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uitgave property can only contain items of type \AbonnementApiV6\StructType\Uitgave, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uitgave value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Uitgave[] $uitgave
     * @return \AbonnementApiV6\StructType\UitgaveInfo
     */
    public function setUitgave(array $uitgave = array())
    {
        // validation for constraint: array
        if ('' !== ($uitgaveArrayErrorMessage = self::validateUitgaveForArrayConstraintsFromSetUitgave($uitgave))) {
            throw new \InvalidArgumentException($uitgaveArrayErrorMessage, __LINE__);
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Add item to uitgave value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Uitgave $item
     * @return \AbonnementApiV6\StructType\UitgaveInfo
     */
    public function addToUitgave(\AbonnementApiV6\StructType\Uitgave $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Uitgave) {
            throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of type \AbonnementApiV6\StructType\Uitgave, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uitgave[] = $item;
        return $this;
    }
}
