<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Uitgave StructType
 * Meta information extracted from the WSDL
 * - documentation: Uitgave object t.b.v getUitgaveInfo.
 * @subpackage Structs
 * @date 20240419 package
 */
class Uitgave extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam/omschrijving van de uitgave.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The uitgaveActief
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de uitgave actief is of niet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $uitgaveActief;
    /**
     * The abonnementsoorten
     * Meta information extracted from the WSDL
     * - documentation: Lijst van 0:n abonnementsoort objecten van de abonnementsoorten bij de uitgave. Zie Abonnementsoort object. Afhankelijk van parameter.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AbonnementsoortInfo
     */
    public $abonnementsoorten;
    /**
     * Constructor method for Uitgave
     * @uses Uitgave::setUitgaveCode()
     * @uses Uitgave::setUitgaveNaam()
     * @uses Uitgave::setUitgaveActief()
     * @uses Uitgave::setAbonnementsoorten()
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param bool $uitgaveActief
     * @param \AbonnementApiV6\StructType\AbonnementsoortInfo $abonnementsoorten
     */
    public function __construct($uitgaveCode = null, $uitgaveNaam = null, $uitgaveActief = null, \AbonnementApiV6\StructType\AbonnementsoortInfo $abonnementsoorten = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setUitgaveActief($uitgaveActief)
            ->setAbonnementsoorten($abonnementsoorten);
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\Uitgave
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \AbonnementApiV6\StructType\Uitgave
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get uitgaveActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUitgaveActief()
    {
        return isset($this->uitgaveActief) ? $this->uitgaveActief : null;
    }
    /**
     * Set uitgaveActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $uitgaveActief
     * @return \AbonnementApiV6\StructType\Uitgave
     */
    public function setUitgaveActief($uitgaveActief = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitgaveActief) && !is_bool($uitgaveActief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitgaveActief, true), gettype($uitgaveActief)), __LINE__);
        }
        if (is_null($uitgaveActief) || (is_array($uitgaveActief) && empty($uitgaveActief))) {
            unset($this->uitgaveActief);
        } else {
            $this->uitgaveActief = $uitgaveActief;
        }
        return $this;
    }
    /**
     * Get abonnementsoorten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AbonnementsoortInfo|null
     */
    public function getAbonnementsoorten()
    {
        return isset($this->abonnementsoorten) ? $this->abonnementsoorten : null;
    }
    /**
     * Set abonnementsoorten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AbonnementsoortInfo $abonnementsoorten
     * @return \AbonnementApiV6\StructType\Uitgave
     */
    public function setAbonnementsoorten(\AbonnementApiV6\StructType\AbonnementsoortInfo $abonnementsoorten = null)
    {
        if (is_null($abonnementsoorten) || (is_array($abonnementsoorten) && empty($abonnementsoorten))) {
            unset($this->abonnementsoorten);
        } else {
            $this->abonnementsoorten = $abonnementsoorten;
        }
        return $this;
    }
}
