<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stopGratisAboPerDirectRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Stopt een abonnement per direct. Bedoelt om abonnementen op een nieuwsbrief of online toegang te stoppen.<br /> Mag aangeroepen worden met ofwel aboNo, ofwel met een relNo, een uitgaveCode en evt. een abosoortCode.<br /><br />
 * Voorwaarden: <ul><li>Looptijd van een abonnement is opgegeven in maanden of jaren, of edities en is ingericht met 365 edities per jaar</li> <li>Abonnementsoort is gratis</li></ul><br /> Abonnement wordt stopgezet per de datum van gisteren. Als de
 * startdatum van het abonnement gelijk is aan de datum van vandaag, wordt het abonnement per vandaag gestopt en wordt 'verzendstop' aangezet.<br />
 * @subpackage Structs
 * @date 20240419 package
 */
class StopGratisAboPerDirectRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Het abonnementnummer van het te stoppen abonnement. Als dit is ingevuld, moeten de argumenten relNo, uitgaveCode en abosoortCode leeg zijn
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Een relatienummer. Mag alleen gebruikt worden in combinatie met de argumenten uitgaveCode en abosoortCode
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van een uitgave. Verplicht als relNo is ingevuld.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The abosoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van een abonnementsoort. Optioneel bij opgave van een relNo en een uitgaveCode
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abosoortCode;
    /**
     * The stopReden
     * Meta information extracted from the WSDL
     * - documentation: De stopreden die bij het stoppen van het abonnement genoteerd moet worden. Kan verplicht zijn, afhankelijk van de inrichting.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $stopReden;
    /**
     * Constructor method for stopGratisAboPerDirectRequest
     * @uses StopGratisAboPerDirectRequest::setRequestTag()
     * @uses StopGratisAboPerDirectRequest::setAboNo()
     * @uses StopGratisAboPerDirectRequest::setRelNo()
     * @uses StopGratisAboPerDirectRequest::setUitgaveCode()
     * @uses StopGratisAboPerDirectRequest::setAbosoortCode()
     * @uses StopGratisAboPerDirectRequest::setStopReden()
     * @param string $requestTag
     * @param int $aboNo
     * @param int $relNo
     * @param string $uitgaveCode
     * @param string $abosoortCode
     * @param string $stopReden
     */
    public function __construct($requestTag = null, $aboNo = null, $relNo = null, $uitgaveCode = null, $abosoortCode = null, $stopReden = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setRelNo($relNo)
            ->setUitgaveCode($uitgaveCode)
            ->setAbosoortCode($abosoortCode)
            ->setStopReden($stopReden);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get abosoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbosoortCode()
    {
        return isset($this->abosoortCode) ? $this->abosoortCode : null;
    }
    /**
     * Set abosoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abosoortCode
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setAbosoortCode($abosoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abosoortCode) && !is_string($abosoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abosoortCode, true), gettype($abosoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($abosoortCode) && mb_strlen($abosoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($abosoortCode)), __LINE__);
        }
        if (is_null($abosoortCode) || (is_array($abosoortCode) && empty($abosoortCode))) {
            unset($this->abosoortCode);
        } else {
            $this->abosoortCode = $abosoortCode;
        }
        return $this;
    }
    /**
     * Get stopReden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopReden()
    {
        return isset($this->stopReden) ? $this->stopReden : null;
    }
    /**
     * Set stopReden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopReden
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest
     */
    public function setStopReden($stopReden = null)
    {
        // validation for constraint: string
        if (!is_null($stopReden) && !is_string($stopReden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopReden, true), gettype($stopReden)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($stopReden) && mb_strlen($stopReden) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($stopReden)), __LINE__);
        }
        if (is_null($stopReden) || (is_array($stopReden) && empty($stopReden))) {
            unset($this->stopReden);
        } else {
            $this->stopReden = $stopReden;
        }
        return $this;
    }
}
