<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAbonnementResult StructType
 * Meta information extracted from the WSDL
 * - documentation: Resultaat van zoeken abonnementen
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchAbonnementResult extends AbstractStructBase
{
    /**
     * The aantal
     * Meta information extracted from the WSDL
     * - documentation: Het aantal abonnees, in de lijst hieronder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantal;
    /**
     * The abonnees
     * Meta information extracted from the WSDL
     * - documentation: De resultaat lijst met gevonden abonnees.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AbonnementInfo
     */
    public $abonnees;
    /**
     * Constructor method for SearchAbonnementResult
     * @uses SearchAbonnementResult::setAantal()
     * @uses SearchAbonnementResult::setAbonnees()
     * @param int $aantal
     * @param \AbonnementApiV6\StructType\AbonnementInfo $abonnees
     */
    public function __construct($aantal = null, \AbonnementApiV6\StructType\AbonnementInfo $abonnees = null)
    {
        $this
            ->setAantal($aantal)
            ->setAbonnees($abonnees);
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantal
     * @return \AbonnementApiV6\StructType\SearchAbonnementResult
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: int
        if (!is_null($aantal) && !(is_int($aantal) || ctype_digit($aantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aantal, true), gettype($aantal)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aantal) && mb_strlen(preg_replace('/(\D)/', '', $aantal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aantal, true), mb_strlen(preg_replace('/(\D)/', '', $aantal))), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Get abonnees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AbonnementInfo|null
     */
    public function getAbonnees()
    {
        return isset($this->abonnees) ? $this->abonnees : null;
    }
    /**
     * Set abonnees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AbonnementInfo $abonnees
     * @return \AbonnementApiV6\StructType\SearchAbonnementResult
     */
    public function setAbonnees(\AbonnementApiV6\StructType\AbonnementInfo $abonnees = null)
    {
        if (is_null($abonnees) || (is_array($abonnees) && empty($abonnees))) {
            unset($this->abonnees);
        } else {
            $this->abonnees = $abonnees;
        }
        return $this;
    }
}
