<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchAbonnementByCredRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchAbonnementByCredRequest extends AbstractStructBase
{
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - documentation: Gebruikersnaam.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Wachtwoord.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The toonAbonnementen
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2] Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * The exclVerschijningen
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van de recente verschijningen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclVerschijningen;
    /**
     * The exclKlachten
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van bijbehorende klachten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclKlachten;
    /**
     * Constructor method for searchAbonnementByCredRequest
     * @uses SearchAbonnementByCredRequest::setUserName()
     * @uses SearchAbonnementByCredRequest::setPassword()
     * @uses SearchAbonnementByCredRequest::setRequestTag()
     * @uses SearchAbonnementByCredRequest::setToonAbonnementen()
     * @uses SearchAbonnementByCredRequest::setExclVerschijningen()
     * @uses SearchAbonnementByCredRequest::setExclKlachten()
     * @param string $userName
     * @param string $password
     * @param string $requestTag
     * @param float $toonAbonnementen
     * @param bool $exclVerschijningen
     * @param bool $exclKlachten
     */
    public function __construct($userName = null, $password = null, $requestTag = null, $toonAbonnementen = null, $exclVerschijningen = null, $exclKlachten = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setRequestTag($requestTag)
            ->setToonAbonnementen($toonAbonnementen)
            ->setExclVerschijningen($exclVerschijningen)
            ->setExclKlachten($exclKlachten);
    }
    /**
     * Get userName value
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($userName) && mb_strlen($userName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($userName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($userName) && mb_strlen($userName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($password) && mb_strlen($password) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($password) && mb_strlen($password) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: float
        if (!is_null($toonAbonnementen) && !(is_float($toonAbonnementen) || is_numeric($toonAbonnementen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toonAbonnementen, true), gettype($toonAbonnementen)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($toonAbonnementen) && mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($toonAbonnementen, true), mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Get exclVerschijningen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclVerschijningen()
    {
        return isset($this->exclVerschijningen) ? $this->exclVerschijningen : null;
    }
    /**
     * Set exclVerschijningen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclVerschijningen
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setExclVerschijningen($exclVerschijningen = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclVerschijningen) && !is_bool($exclVerschijningen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclVerschijningen, true), gettype($exclVerschijningen)), __LINE__);
        }
        if (is_null($exclVerschijningen) || (is_array($exclVerschijningen) && empty($exclVerschijningen))) {
            unset($this->exclVerschijningen);
        } else {
            $this->exclVerschijningen = $exclVerschijningen;
        }
        return $this;
    }
    /**
     * Get exclKlachten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclKlachten()
    {
        return isset($this->exclKlachten) ? $this->exclKlachten : null;
    }
    /**
     * Set exclKlachten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclKlachten
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredRequest
     */
    public function setExclKlachten($exclKlachten = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclKlachten) && !is_bool($exclKlachten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclKlachten, true), gettype($exclKlachten)), __LINE__);
        }
        if (is_null($exclKlachten) || (is_array($exclKlachten) && empty($exclKlachten))) {
            unset($this->exclKlachten);
        } else {
            $this->exclKlachten = $exclKlachten;
        }
        return $this;
    }
}
