<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositiePremiums StructType
 * Meta information extracted from the WSDL
 * - documentation: PropositiePremiums object.
 * @subpackage Structs
 * @date 20240419 package
 */
class PropositiePremiums extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke nummer van de propositiePremium.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The artikelCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de propositiePremium.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelCode;
    /**
     * The artikelNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam/omschrijving van de propositiePremium.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelNaam;
    /**
     * The artikelVerkoopprijsExclBtw
     * Meta information extracted from the WSDL
     * - documentation: De verkoopprijs (excl. BTW).
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $artikelVerkoopprijsExclBtw;
    /**
     * The artikelVerkoopprijsInclBtw
     * Meta information extracted from the WSDL
     * - documentation: De verkoopprijs (incl. BTW).
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $artikelVerkoopprijsInclBtw;
    /**
     * Constructor method for PropositiePremiums
     * @uses PropositiePremiums::setArtikelNummer()
     * @uses PropositiePremiums::setArtikelCode()
     * @uses PropositiePremiums::setArtikelNaam()
     * @uses PropositiePremiums::setArtikelVerkoopprijsExclBtw()
     * @uses PropositiePremiums::setArtikelVerkoopprijsInclBtw()
     * @param int $artikelNummer
     * @param string $artikelCode
     * @param string $artikelNaam
     * @param float $artikelVerkoopprijsExclBtw
     * @param float $artikelVerkoopprijsInclBtw
     */
    public function __construct($artikelNummer = null, $artikelCode = null, $artikelNaam = null, $artikelVerkoopprijsExclBtw = null, $artikelVerkoopprijsInclBtw = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setArtikelCode($artikelCode)
            ->setArtikelNaam($artikelNaam)
            ->setArtikelVerkoopprijsExclBtw($artikelVerkoopprijsExclBtw)
            ->setArtikelVerkoopprijsInclBtw($artikelVerkoopprijsInclBtw);
    }
    /**
     * Get artikelNummer value
     * @return int
     */
    public function getArtikelNummer()
    {
        return $this->artikelNummer;
    }
    /**
     * Set artikelNummer value
     * @param int $artikelNummer
     * @return \AbonnementApiV6\StructType\PropositiePremiums
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: int
        if (!is_null($artikelNummer) && !(is_int($artikelNummer) || ctype_digit($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        $this->artikelNummer = $artikelNummer;
        return $this;
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \AbonnementApiV6\StructType\PropositiePremiums
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelCode, true), gettype($artikelCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get artikelNaam value
     * @return string
     */
    public function getArtikelNaam()
    {
        return $this->artikelNaam;
    }
    /**
     * Set artikelNaam value
     * @param string $artikelNaam
     * @return \AbonnementApiV6\StructType\PropositiePremiums
     */
    public function setArtikelNaam($artikelNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelNaam) && !is_string($artikelNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelNaam, true), gettype($artikelNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($artikelNaam) && mb_strlen($artikelNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($artikelNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelNaam) && mb_strlen($artikelNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelNaam)), __LINE__);
        }
        $this->artikelNaam = $artikelNaam;
        return $this;
    }
    /**
     * Get artikelVerkoopprijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getArtikelVerkoopprijsExclBtw()
    {
        return isset($this->artikelVerkoopprijsExclBtw) ? $this->artikelVerkoopprijsExclBtw : null;
    }
    /**
     * Set artikelVerkoopprijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $artikelVerkoopprijsExclBtw
     * @return \AbonnementApiV6\StructType\PropositiePremiums
     */
    public function setArtikelVerkoopprijsExclBtw($artikelVerkoopprijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($artikelVerkoopprijsExclBtw) && !(is_float($artikelVerkoopprijsExclBtw) || is_numeric($artikelVerkoopprijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artikelVerkoopprijsExclBtw, true), gettype($artikelVerkoopprijsExclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($artikelVerkoopprijsExclBtw) && mb_strlen(mb_substr($artikelVerkoopprijsExclBtw, false !== mb_strpos($artikelVerkoopprijsExclBtw, '.') ? mb_strpos($artikelVerkoopprijsExclBtw, '.') + 1 : mb_strlen($artikelVerkoopprijsExclBtw))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($artikelVerkoopprijsExclBtw, true), mb_strlen(mb_substr($artikelVerkoopprijsExclBtw, mb_strpos($artikelVerkoopprijsExclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($artikelVerkoopprijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $artikelVerkoopprijsExclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($artikelVerkoopprijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $artikelVerkoopprijsExclBtw))), __LINE__);
        }
        if (is_null($artikelVerkoopprijsExclBtw) || (is_array($artikelVerkoopprijsExclBtw) && empty($artikelVerkoopprijsExclBtw))) {
            unset($this->artikelVerkoopprijsExclBtw);
        } else {
            $this->artikelVerkoopprijsExclBtw = $artikelVerkoopprijsExclBtw;
        }
        return $this;
    }
    /**
     * Get artikelVerkoopprijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getArtikelVerkoopprijsInclBtw()
    {
        return isset($this->artikelVerkoopprijsInclBtw) ? $this->artikelVerkoopprijsInclBtw : null;
    }
    /**
     * Set artikelVerkoopprijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $artikelVerkoopprijsInclBtw
     * @return \AbonnementApiV6\StructType\PropositiePremiums
     */
    public function setArtikelVerkoopprijsInclBtw($artikelVerkoopprijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($artikelVerkoopprijsInclBtw) && !(is_float($artikelVerkoopprijsInclBtw) || is_numeric($artikelVerkoopprijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artikelVerkoopprijsInclBtw, true), gettype($artikelVerkoopprijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($artikelVerkoopprijsInclBtw) && mb_strlen(mb_substr($artikelVerkoopprijsInclBtw, false !== mb_strpos($artikelVerkoopprijsInclBtw, '.') ? mb_strpos($artikelVerkoopprijsInclBtw, '.') + 1 : mb_strlen($artikelVerkoopprijsInclBtw))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($artikelVerkoopprijsInclBtw, true), mb_strlen(mb_substr($artikelVerkoopprijsInclBtw, mb_strpos($artikelVerkoopprijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($artikelVerkoopprijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $artikelVerkoopprijsInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($artikelVerkoopprijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $artikelVerkoopprijsInclBtw))), __LINE__);
        }
        if (is_null($artikelVerkoopprijsInclBtw) || (is_array($artikelVerkoopprijsInclBtw) && empty($artikelVerkoopprijsInclBtw))) {
            unset($this->artikelVerkoopprijsInclBtw);
        } else {
            $this->artikelVerkoopprijsInclBtw = $artikelVerkoopprijsInclBtw;
        }
        return $this;
    }
}
