<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieObject StructType
 * Meta information extracted from the WSDL
 * - documentation: PropositieObject t.b.v. switch proposities.
 * @subpackage Structs
 * @date 20240419 package
 */
class PropositieObject extends AbstractStructBase
{
    /**
     * The aboSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortCode;
    /**
     * The pakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het (abonnements)pakket.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * Constructor method for PropositieObject
     * @uses PropositieObject::setAboSoortCode()
     * @uses PropositieObject::setPakketCode()
     * @param string $aboSoortCode
     * @param string $pakketCode
     */
    public function __construct($aboSoortCode = null, $pakketCode = null)
    {
        $this
            ->setAboSoortCode($aboSoortCode)
            ->setPakketCode($pakketCode);
    }
    /**
     * Get aboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortCode()
    {
        return isset($this->aboSoortCode) ? $this->aboSoortCode : null;
    }
    /**
     * Set aboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortCode
     * @return \AbonnementApiV6\StructType\PropositieObject
     */
    public function setAboSoortCode($aboSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortCode) && !is_string($aboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortCode, true), gettype($aboSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortCode) && mb_strlen($aboSoortCode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortCode)), __LINE__);
        }
        if (is_null($aboSoortCode) || (is_array($aboSoortCode) && empty($aboSoortCode))) {
            unset($this->aboSoortCode);
        } else {
            $this->aboSoortCode = $aboSoortCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \AbonnementApiV6\StructType\PropositieObject
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
}
