<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoonsObject StructType
 * Meta information extracted from the WSDL
 * - documentation: Het persoonsobject bestaat uit de volgende velden
 * @subpackage Structs
 * @date 20240419 package
 */
class PersoonsObject extends AbstractStructBase
{
    /**
     * The relEmail
     * Meta information extracted from the WSDL
     * - documentation: E-mailadres.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relEmail;
    /**
     * The relGeboorteDatum
     * Meta information extracted from the WSDL
     * - documentation: Geboortedatum mag niet langer geleden zijn dan 100 jaar.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relGeboorteDatum;
    /**
     * The relGeslacht
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3] Geslacht: 0 = n.v.t., 1 = Man, 2 = Vrouw, 3 = Onbekend.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $relGeslacht;
    /**
     * The relNaam
     * Meta information extracted from the WSDL
     * - documentation: Achternaam; N.B. verplicht tenzij de relatie in de context van een abonnee wordt aangemaakt en de abosoort of pakket invoer zonder NAW toestaat.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relNaam;
    /**
     * The relTelefoon
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer, validatie telefoonnummer indien landcode is leeg.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTelefoon;
    /**
     * The relTelefoonMobiel
     * Meta information extracted from the WSDL
     * - documentation: Mobiel telefoonnummer, validatie telefoonnummer indien landcode is leeg.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTelefoonMobiel;
    /**
     * The relTitulatuurCode
     * Meta information extracted from the WSDL
     * - documentation: Bijvoorbeeld Dr. Drs of Ir; Code moet bestaan in de TitulatuurTabel.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTitulatuurCode;
    /**
     * The relTussenVoegsels
     * Meta information extracted from the WSDL
     * - documentation: Tussenvoegsels.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relTussenVoegsels;
    /**
     * The relVoorletters
     * Meta information extracted from the WSDL
     * - documentation: Voorletters.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relVoorletters;
    /**
     * The relVoornaam
     * Meta information extracted from the WSDL
     * - documentation: Voornaam.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relVoornaam;
    /**
     * The relRekNr
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer van de klant; Giro begint met P en niet langer dan 7 pos, banknr 11-proef.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekNr;
    /**
     * The relRekIbanNr
     * Meta information extracted from the WSDL
     * - documentation: Ibannummer van de bankrekening van de klant; Ibannummer wordt gecontroleerd op valide Iban nummer.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekIbanNr;
    /**
     * The relRekBicCode
     * Meta information extracted from the WSDL
     * - documentation: BicCode van de bankrekening van de klant; Biccode wordt gecontroleerd op valide bic code.
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relRekBicCode;
    /**
     * The relUitsluitenVanMailing
     * Meta information extracted from the WSDL
     * - documentation: Deze relatie uitsluiten van mailing(s). Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande instelling voor relaties
     * bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $relUitsluitenVanMailing;
    /**
     * The relRechtVanBeperking
     * Meta information extracted from the WSDL
     * - documentation: Voor deze relatie geldt het recht van beperking op verwerking. Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande
     * instelling voor relaties bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $relRechtVanBeperking;
    /**
     * The relOnvolledig
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of de gegevens van de relatie onvolledig zijn. Waarschuwing: zet deze indicatie niet zomaar aan. Dit betekent dat een aantal checks, bijv. het bestaan van een geldig adres, niet wordt uitgevoerd. De relatie kan desondanks
     * dan toch worden aangemaakt, maar dat zou procesmatig later wel een probleem kunnen vormen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $relOnvolledig;
    /**
     * Constructor method for PersoonsObject
     * @uses PersoonsObject::setRelEmail()
     * @uses PersoonsObject::setRelGeboorteDatum()
     * @uses PersoonsObject::setRelGeslacht()
     * @uses PersoonsObject::setRelNaam()
     * @uses PersoonsObject::setRelTelefoon()
     * @uses PersoonsObject::setRelTelefoonMobiel()
     * @uses PersoonsObject::setRelTitulatuurCode()
     * @uses PersoonsObject::setRelTussenVoegsels()
     * @uses PersoonsObject::setRelVoorletters()
     * @uses PersoonsObject::setRelVoornaam()
     * @uses PersoonsObject::setRelRekNr()
     * @uses PersoonsObject::setRelRekIbanNr()
     * @uses PersoonsObject::setRelRekBicCode()
     * @uses PersoonsObject::setRelUitsluitenVanMailing()
     * @uses PersoonsObject::setRelRechtVanBeperking()
     * @uses PersoonsObject::setRelOnvolledig()
     * @param string $relEmail
     * @param string $relGeboorteDatum
     * @param int $relGeslacht
     * @param string $relNaam
     * @param string $relTelefoon
     * @param string $relTelefoonMobiel
     * @param string $relTitulatuurCode
     * @param string $relTussenVoegsels
     * @param string $relVoorletters
     * @param string $relVoornaam
     * @param string $relRekNr
     * @param string $relRekIbanNr
     * @param string $relRekBicCode
     * @param bool $relUitsluitenVanMailing
     * @param bool $relRechtVanBeperking
     * @param bool $relOnvolledig
     */
    public function __construct($relEmail = null, $relGeboorteDatum = null, $relGeslacht = null, $relNaam = null, $relTelefoon = null, $relTelefoonMobiel = null, $relTitulatuurCode = null, $relTussenVoegsels = null, $relVoorletters = null, $relVoornaam = null, $relRekNr = null, $relRekIbanNr = null, $relRekBicCode = null, $relUitsluitenVanMailing = null, $relRechtVanBeperking = null, $relOnvolledig = null)
    {
        $this
            ->setRelEmail($relEmail)
            ->setRelGeboorteDatum($relGeboorteDatum)
            ->setRelGeslacht($relGeslacht)
            ->setRelNaam($relNaam)
            ->setRelTelefoon($relTelefoon)
            ->setRelTelefoonMobiel($relTelefoonMobiel)
            ->setRelTitulatuurCode($relTitulatuurCode)
            ->setRelTussenVoegsels($relTussenVoegsels)
            ->setRelVoorletters($relVoorletters)
            ->setRelVoornaam($relVoornaam)
            ->setRelRekNr($relRekNr)
            ->setRelRekIbanNr($relRekIbanNr)
            ->setRelRekBicCode($relRekBicCode)
            ->setRelUitsluitenVanMailing($relUitsluitenVanMailing)
            ->setRelRechtVanBeperking($relRechtVanBeperking)
            ->setRelOnvolledig($relOnvolledig);
    }
    /**
     * Get relEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelEmail()
    {
        return isset($this->relEmail) ? $this->relEmail : null;
    }
    /**
     * Set relEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relEmail
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelEmail($relEmail = null)
    {
        // validation for constraint: string
        if (!is_null($relEmail) && !is_string($relEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relEmail, true), gettype($relEmail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relEmail) && mb_strlen($relEmail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relEmail)), __LINE__);
        }
        if (is_null($relEmail) || (is_array($relEmail) && empty($relEmail))) {
            unset($this->relEmail);
        } else {
            $this->relEmail = $relEmail;
        }
        return $this;
    }
    /**
     * Get relGeboorteDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelGeboorteDatum()
    {
        return isset($this->relGeboorteDatum) ? $this->relGeboorteDatum : null;
    }
    /**
     * Set relGeboorteDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relGeboorteDatum
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelGeboorteDatum($relGeboorteDatum = null)
    {
        // validation for constraint: string
        if (!is_null($relGeboorteDatum) && !is_string($relGeboorteDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relGeboorteDatum, true), gettype($relGeboorteDatum)), __LINE__);
        }
        if (is_null($relGeboorteDatum) || (is_array($relGeboorteDatum) && empty($relGeboorteDatum))) {
            unset($this->relGeboorteDatum);
        } else {
            $this->relGeboorteDatum = $relGeboorteDatum;
        }
        return $this;
    }
    /**
     * Get relGeslacht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelGeslacht()
    {
        return isset($this->relGeslacht) ? $this->relGeslacht : null;
    }
    /**
     * Set relGeslacht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relGeslacht
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelGeslacht($relGeslacht = null)
    {
        // validation for constraint: int
        if (!is_null($relGeslacht) && !(is_int($relGeslacht) || ctype_digit($relGeslacht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relGeslacht, true), gettype($relGeslacht)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($relGeslacht) && mb_strlen(preg_replace('/(\D)/', '', $relGeslacht)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($relGeslacht, true), mb_strlen(preg_replace('/(\D)/', '', $relGeslacht))), __LINE__);
        }
        if (is_null($relGeslacht) || (is_array($relGeslacht) && empty($relGeslacht))) {
            unset($this->relGeslacht);
        } else {
            $this->relGeslacht = $relGeslacht;
        }
        return $this;
    }
    /**
     * Get relNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelNaam()
    {
        return isset($this->relNaam) ? $this->relNaam : null;
    }
    /**
     * Set relNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relNaam
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelNaam($relNaam = null)
    {
        // validation for constraint: string
        if (!is_null($relNaam) && !is_string($relNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relNaam, true), gettype($relNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($relNaam) && mb_strlen($relNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($relNaam)), __LINE__);
        }
        if (is_null($relNaam) || (is_array($relNaam) && empty($relNaam))) {
            unset($this->relNaam);
        } else {
            $this->relNaam = $relNaam;
        }
        return $this;
    }
    /**
     * Get relTelefoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTelefoon()
    {
        return isset($this->relTelefoon) ? $this->relTelefoon : null;
    }
    /**
     * Set relTelefoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTelefoon
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelTelefoon($relTelefoon = null)
    {
        // validation for constraint: string
        if (!is_null($relTelefoon) && !is_string($relTelefoon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTelefoon, true), gettype($relTelefoon)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relTelefoon) && mb_strlen($relTelefoon) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relTelefoon)), __LINE__);
        }
        if (is_null($relTelefoon) || (is_array($relTelefoon) && empty($relTelefoon))) {
            unset($this->relTelefoon);
        } else {
            $this->relTelefoon = $relTelefoon;
        }
        return $this;
    }
    /**
     * Get relTelefoonMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTelefoonMobiel()
    {
        return isset($this->relTelefoonMobiel) ? $this->relTelefoonMobiel : null;
    }
    /**
     * Set relTelefoonMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTelefoonMobiel
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelTelefoonMobiel($relTelefoonMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($relTelefoonMobiel) && !is_string($relTelefoonMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTelefoonMobiel, true), gettype($relTelefoonMobiel)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($relTelefoonMobiel) && mb_strlen($relTelefoonMobiel) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($relTelefoonMobiel)), __LINE__);
        }
        if (is_null($relTelefoonMobiel) || (is_array($relTelefoonMobiel) && empty($relTelefoonMobiel))) {
            unset($this->relTelefoonMobiel);
        } else {
            $this->relTelefoonMobiel = $relTelefoonMobiel;
        }
        return $this;
    }
    /**
     * Get relTitulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTitulatuurCode()
    {
        return isset($this->relTitulatuurCode) ? $this->relTitulatuurCode : null;
    }
    /**
     * Set relTitulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTitulatuurCode
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelTitulatuurCode($relTitulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($relTitulatuurCode) && !is_string($relTitulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTitulatuurCode, true), gettype($relTitulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($relTitulatuurCode) && mb_strlen($relTitulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($relTitulatuurCode)), __LINE__);
        }
        if (is_null($relTitulatuurCode) || (is_array($relTitulatuurCode) && empty($relTitulatuurCode))) {
            unset($this->relTitulatuurCode);
        } else {
            $this->relTitulatuurCode = $relTitulatuurCode;
        }
        return $this;
    }
    /**
     * Get relTussenVoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelTussenVoegsels()
    {
        return isset($this->relTussenVoegsels) ? $this->relTussenVoegsels : null;
    }
    /**
     * Set relTussenVoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relTussenVoegsels
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelTussenVoegsels($relTussenVoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($relTussenVoegsels) && !is_string($relTussenVoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relTussenVoegsels, true), gettype($relTussenVoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($relTussenVoegsels) && mb_strlen($relTussenVoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($relTussenVoegsels)), __LINE__);
        }
        if (is_null($relTussenVoegsels) || (is_array($relTussenVoegsels) && empty($relTussenVoegsels))) {
            unset($this->relTussenVoegsels);
        } else {
            $this->relTussenVoegsels = $relTussenVoegsels;
        }
        return $this;
    }
    /**
     * Get relVoorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelVoorletters()
    {
        return isset($this->relVoorletters) ? $this->relVoorletters : null;
    }
    /**
     * Set relVoorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relVoorletters
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelVoorletters($relVoorletters = null)
    {
        // validation for constraint: string
        if (!is_null($relVoorletters) && !is_string($relVoorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relVoorletters, true), gettype($relVoorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($relVoorletters) && mb_strlen($relVoorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($relVoorletters)), __LINE__);
        }
        if (is_null($relVoorletters) || (is_array($relVoorletters) && empty($relVoorletters))) {
            unset($this->relVoorletters);
        } else {
            $this->relVoorletters = $relVoorletters;
        }
        return $this;
    }
    /**
     * Get relVoornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelVoornaam()
    {
        return isset($this->relVoornaam) ? $this->relVoornaam : null;
    }
    /**
     * Set relVoornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relVoornaam
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelVoornaam($relVoornaam = null)
    {
        // validation for constraint: string
        if (!is_null($relVoornaam) && !is_string($relVoornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relVoornaam, true), gettype($relVoornaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($relVoornaam) && mb_strlen($relVoornaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($relVoornaam)), __LINE__);
        }
        if (is_null($relVoornaam) || (is_array($relVoornaam) && empty($relVoornaam))) {
            unset($this->relVoornaam);
        } else {
            $this->relVoornaam = $relVoornaam;
        }
        return $this;
    }
    /**
     * Get relRekNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekNr()
    {
        return isset($this->relRekNr) ? $this->relRekNr : null;
    }
    /**
     * Set relRekNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekNr
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelRekNr($relRekNr = null)
    {
        // validation for constraint: string
        if (!is_null($relRekNr) && !is_string($relRekNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekNr, true), gettype($relRekNr)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($relRekNr) && mb_strlen($relRekNr) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($relRekNr)), __LINE__);
        }
        if (is_null($relRekNr) || (is_array($relRekNr) && empty($relRekNr))) {
            unset($this->relRekNr);
        } else {
            $this->relRekNr = $relRekNr;
        }
        return $this;
    }
    /**
     * Get relRekIbanNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekIbanNr()
    {
        return isset($this->relRekIbanNr) ? $this->relRekIbanNr : null;
    }
    /**
     * Set relRekIbanNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekIbanNr
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelRekIbanNr($relRekIbanNr = null)
    {
        // validation for constraint: string
        if (!is_null($relRekIbanNr) && !is_string($relRekIbanNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekIbanNr, true), gettype($relRekIbanNr)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($relRekIbanNr) && mb_strlen($relRekIbanNr) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($relRekIbanNr)), __LINE__);
        }
        if (is_null($relRekIbanNr) || (is_array($relRekIbanNr) && empty($relRekIbanNr))) {
            unset($this->relRekIbanNr);
        } else {
            $this->relRekIbanNr = $relRekIbanNr;
        }
        return $this;
    }
    /**
     * Get relRekBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelRekBicCode()
    {
        return isset($this->relRekBicCode) ? $this->relRekBicCode : null;
    }
    /**
     * Set relRekBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relRekBicCode
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelRekBicCode($relRekBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($relRekBicCode) && !is_string($relRekBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relRekBicCode, true), gettype($relRekBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($relRekBicCode) && mb_strlen($relRekBicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($relRekBicCode)), __LINE__);
        }
        if (is_null($relRekBicCode) || (is_array($relRekBicCode) && empty($relRekBicCode))) {
            unset($this->relRekBicCode);
        } else {
            $this->relRekBicCode = $relRekBicCode;
        }
        return $this;
    }
    /**
     * Get relUitsluitenVanMailing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRelUitsluitenVanMailing()
    {
        return isset($this->relUitsluitenVanMailing) ? $this->relUitsluitenVanMailing : null;
    }
    /**
     * Set relUitsluitenVanMailing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $relUitsluitenVanMailing
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelUitsluitenVanMailing($relUitsluitenVanMailing = null)
    {
        // validation for constraint: boolean
        if (!is_null($relUitsluitenVanMailing) && !is_bool($relUitsluitenVanMailing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relUitsluitenVanMailing, true), gettype($relUitsluitenVanMailing)), __LINE__);
        }
        if (is_null($relUitsluitenVanMailing) || (is_array($relUitsluitenVanMailing) && empty($relUitsluitenVanMailing))) {
            unset($this->relUitsluitenVanMailing);
        } else {
            $this->relUitsluitenVanMailing = $relUitsluitenVanMailing;
        }
        return $this;
    }
    /**
     * Get relRechtVanBeperking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRelRechtVanBeperking()
    {
        return isset($this->relRechtVanBeperking) ? $this->relRechtVanBeperking : null;
    }
    /**
     * Set relRechtVanBeperking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $relRechtVanBeperking
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelRechtVanBeperking($relRechtVanBeperking = null)
    {
        // validation for constraint: boolean
        if (!is_null($relRechtVanBeperking) && !is_bool($relRechtVanBeperking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relRechtVanBeperking, true), gettype($relRechtVanBeperking)), __LINE__);
        }
        if (is_null($relRechtVanBeperking) || (is_array($relRechtVanBeperking) && empty($relRechtVanBeperking))) {
            unset($this->relRechtVanBeperking);
        } else {
            $this->relRechtVanBeperking = $relRechtVanBeperking;
        }
        return $this;
    }
    /**
     * Get relOnvolledig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRelOnvolledig()
    {
        return isset($this->relOnvolledig) ? $this->relOnvolledig : null;
    }
    /**
     * Set relOnvolledig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $relOnvolledig
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function setRelOnvolledig($relOnvolledig = null)
    {
        // validation for constraint: boolean
        if (!is_null($relOnvolledig) && !is_bool($relOnvolledig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relOnvolledig, true), gettype($relOnvolledig)), __LINE__);
        }
        if (is_null($relOnvolledig) || (is_array($relOnvolledig) && empty($relOnvolledig))) {
            unset($this->relOnvolledig);
        } else {
            $this->relOnvolledig = $relOnvolledig;
        }
        return $this;
    }
}
