<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Licentiehouder StructType
 * Meta information extracted from the WSDL
 * - documentation: Licentiehouder object.
 * @subpackage Structs
 * @date 20240419 package
 */
class Licentiehouder extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de licentiehouder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The licentieNo
     * Meta information extracted from the WSDL
     * - documentation: Het licentienummer van de licentiehouder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * The achternaam
     * Meta information extracted from the WSDL
     * - documentation: Achternaam van de licentiehouder.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaam;
    /**
     * The voornaam
     * Meta information extracted from the WSDL
     * - documentation: Voornaam van de licentiehouder.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voornaam;
    /**
     * The tussenvoegsels
     * Meta information extracted from the WSDL
     * - documentation: Tussenvoegsels van de licentiehouder.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tussenvoegsels;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres van de licentiehouder.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The rollen
     * Meta information extracted from the WSDL
     * - documentation: Lijst met rollen aanwezig bij de licentiehouder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\RolInfo
     */
    public $rollen;
    /**
     * Constructor method for Licentiehouder
     * @uses Licentiehouder::setRelNo()
     * @uses Licentiehouder::setLicentieNo()
     * @uses Licentiehouder::setAchternaam()
     * @uses Licentiehouder::setVoornaam()
     * @uses Licentiehouder::setTussenvoegsels()
     * @uses Licentiehouder::setEmail()
     * @uses Licentiehouder::setRollen()
     * @param int $relNo
     * @param int $licentieNo
     * @param string $achternaam
     * @param string $voornaam
     * @param string $tussenvoegsels
     * @param string $email
     * @param \AbonnementApiV6\StructType\RolInfo $rollen
     */
    public function __construct($relNo = null, $licentieNo = null, $achternaam = null, $voornaam = null, $tussenvoegsels = null, $email = null, \AbonnementApiV6\StructType\RolInfo $rollen = null)
    {
        $this
            ->setRelNo($relNo)
            ->setLicentieNo($licentieNo)
            ->setAchternaam($achternaam)
            ->setVoornaam($voornaam)
            ->setTussenvoegsels($tussenvoegsels)
            ->setEmail($email)
            ->setRollen($rollen);
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get licentieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentieNo()
    {
        return isset($this->licentieNo) ? $this->licentieNo : null;
    }
    /**
     * Set licentieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentieNo
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: int
        if (!is_null($licentieNo) && !(is_int($licentieNo) || ctype_digit($licentieNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licentieNo, true), gettype($licentieNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($licentieNo) && mb_strlen(preg_replace('/(\D)/', '', $licentieNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($licentieNo, true), mb_strlen(preg_replace('/(\D)/', '', $licentieNo))), __LINE__);
        }
        if (is_null($licentieNo) || (is_array($licentieNo) && empty($licentieNo))) {
            unset($this->licentieNo);
        } else {
            $this->licentieNo = $licentieNo;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voornaam, true), gettype($voornaam)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($voornaam) && mb_strlen($voornaam) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get tussenvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsels()
    {
        return isset($this->tussenvoegsels) ? $this->tussenvoegsels : null;
    }
    /**
     * Set tussenvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsels
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setTussenvoegsels($tussenvoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsels) && !is_string($tussenvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tussenvoegsels, true), gettype($tussenvoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($tussenvoegsels) && mb_strlen($tussenvoegsels) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($tussenvoegsels)), __LINE__);
        }
        if (is_null($tussenvoegsels) || (is_array($tussenvoegsels) && empty($tussenvoegsels))) {
            unset($this->tussenvoegsels);
        } else {
            $this->tussenvoegsels = $tussenvoegsels;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get rollen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\RolInfo|null
     */
    public function getRollen()
    {
        return isset($this->rollen) ? $this->rollen : null;
    }
    /**
     * Set rollen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\RolInfo $rollen
     * @return \AbonnementApiV6\StructType\Licentiehouder
     */
    public function setRollen(\AbonnementApiV6\StructType\RolInfo $rollen = null)
    {
        if (is_null($rollen) || (is_array($rollen) && empty($rollen))) {
            unset($this->rollen);
        } else {
            $this->rollen = $rollen;
        }
        return $this;
    }
}
