<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFactSamenvatInfoResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error999: Deze functionaliteit is niet geimplementeerd. | error2: Kan geen relatie vinden obv de opgegeven relNo. | error1: Kan geen relatie vinden, er is geen relNo opgegeven.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetFactSamenvatInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The factuurSamenvattingen
     * Meta information extracted from the WSDL
     * - documentation: De lijst met factuur samenvattingen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\FactSamenvatInfo
     */
    public $factuurSamenvattingen;
    /**
     * Constructor method for getFactSamenvatInfoResponse
     * @uses GetFactSamenvatInfoResponse::setRequestTag()
     * @uses GetFactSamenvatInfoResponse::setFactuurSamenvattingen()
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\FactSamenvatInfo $factuurSamenvattingen
     */
    public function __construct($requestTag = null, \AbonnementApiV6\StructType\FactSamenvatInfo $factuurSamenvattingen = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setFactuurSamenvattingen($factuurSamenvattingen);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetFactSamenvatInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get factuurSamenvattingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\FactSamenvatInfo|null
     */
    public function getFactuurSamenvattingen()
    {
        return isset($this->factuurSamenvattingen) ? $this->factuurSamenvattingen : null;
    }
    /**
     * Set factuurSamenvattingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\FactSamenvatInfo $factuurSamenvattingen
     * @return \AbonnementApiV6\StructType\GetFactSamenvatInfoResponse
     */
    public function setFactuurSamenvattingen(\AbonnementApiV6\StructType\FactSamenvatInfo $factuurSamenvattingen = null)
    {
        if (is_null($factuurSamenvattingen) || (is_array($factuurSamenvattingen) && empty($factuurSamenvattingen))) {
            unset($this->factuurSamenvattingen);
        } else {
            $this->factuurSamenvattingen = $factuurSamenvattingen;
        }
        return $this;
    }
}
