<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCalamiteitInfoResponse StructType
 * @subpackage Structs
 * @date 20240419 package
 */
class GetCalamiteitInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The calamiteiten
     * Meta information extracted from the WSDL
     * - documentation: Object met de geldende calamiteiten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\CalamiteitTab
     */
    public $calamiteiten;
    /**
     * The relNoResult
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer waarvoor de calamiteiten zijn bepaald. Kan afwijken van RelNo in geval van een ontdubbelde relatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for getCalamiteitInfoResponse
     * @uses GetCalamiteitInfoResponse::setRequestTag()
     * @uses GetCalamiteitInfoResponse::setCalamiteiten()
     * @uses GetCalamiteitInfoResponse::setRelNoResult()
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setCalamiteiten($calamiteiten)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get calamiteiten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\CalamiteitTab|null
     */
    public function getCalamiteiten()
    {
        return isset($this->calamiteiten) ? $this->calamiteiten : null;
    }
    /**
     * Set calamiteiten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoResponse
     */
    public function setCalamiteiten(\AbonnementApiV6\StructType\CalamiteitTab $calamiteiten = null)
    {
        if (is_null($calamiteiten) || (is_array($calamiteiten) && empty($calamiteiten))) {
            unset($this->calamiteiten);
        } else {
            $this->calamiteiten = $calamiteiten;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoResult) && !(is_int($relNoResult) || ctype_digit($relNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoResult, true), gettype($relNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoResult))), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
}
