<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCalamiteitInfoByPcHnrResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error999: Deze functionaliteit is niet geimplementeerd | error186: Opgegeven postcode is niet geldig
 * @subpackage Structs
 * @date 20240419 package
 */
class GetCalamiteitInfoByPcHnrResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The calCount
     * Meta information extracted from the WSDL
     * - documentation: Aantal gevonden calamiteiten.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $calCount;
    /**
     * The calamiteiten
     * Meta information extracted from the WSDL
     * - documentation: Object met de geldende calamiteiten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\CalamiteitTab
     */
    public $calamiteiten;
    /**
     * Constructor method for getCalamiteitInfoByPcHnrResponse
     * @uses GetCalamiteitInfoByPcHnrResponse::setRequestTag()
     * @uses GetCalamiteitInfoByPcHnrResponse::setCalCount()
     * @uses GetCalamiteitInfoByPcHnrResponse::setCalamiteiten()
     * @param string $requestTag
     * @param float $calCount
     * @param \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten
     */
    public function __construct($requestTag = null, $calCount = null, \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setCalCount($calCount)
            ->setCalamiteiten($calamiteiten);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get calCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCalCount()
    {
        return isset($this->calCount) ? $this->calCount : null;
    }
    /**
     * Set calCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $calCount
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrResponse
     */
    public function setCalCount($calCount = null)
    {
        // validation for constraint: float
        if (!is_null($calCount) && !(is_float($calCount) || is_numeric($calCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calCount, true), gettype($calCount)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($calCount) && mb_strlen(preg_replace('/(\D)/', '', $calCount)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($calCount, true), mb_strlen(preg_replace('/(\D)/', '', $calCount))), __LINE__);
        }
        if (is_null($calCount) || (is_array($calCount) && empty($calCount))) {
            unset($this->calCount);
        } else {
            $this->calCount = $calCount;
        }
        return $this;
    }
    /**
     * Get calamiteiten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\CalamiteitTab|null
     */
    public function getCalamiteiten()
    {
        return isset($this->calamiteiten) ? $this->calamiteiten : null;
    }
    /**
     * Set calamiteiten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\CalamiteitTab $calamiteiten
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrResponse
     */
    public function setCalamiteiten(\AbonnementApiV6\StructType\CalamiteitTab $calamiteiten = null)
    {
        if (is_null($calamiteiten) || (is_array($calamiteiten) && empty($calamiteiten))) {
            unset($this->calamiteiten);
        } else {
            $this->calamiteiten = $calamiteiten;
        }
        return $this;
    }
}
