<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCalamiteitInfoByPcHnrRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft informatie over calamiteiten die actief zijn voor de distributie van een krant op een specifiek adres.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetCalamiteitInfoByPcHnrRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: Volledige postcode, formaat 9999XX of 9999 XX.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The datum
     * Meta information extracted from the WSDL
     * - documentation: Datum waarvoor de calamiteiten gezocht worden, indien leeg wordt gezocht op vandaag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datum;
    /**
     * Constructor method for getCalamiteitInfoByPcHnrRequest
     * @uses GetCalamiteitInfoByPcHnrRequest::setRequestTag()
     * @uses GetCalamiteitInfoByPcHnrRequest::setPostcode()
     * @uses GetCalamiteitInfoByPcHnrRequest::setHuisNummer()
     * @uses GetCalamiteitInfoByPcHnrRequest::setDatum()
     * @param string $requestTag
     * @param string $postcode
     * @param float $huisNummer
     * @param string $datum
     */
    public function __construct($requestTag = null, $postcode = null, $huisNummer = null, $datum = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setDatum($datum);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisNummer
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: float
        if (!is_null($huisNummer) && !(is_float($huisNummer) || is_numeric($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get datum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatum()
    {
        return isset($this->datum) ? $this->datum : null;
    }
    /**
     * Set datum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datum
     * @return \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        if (is_null($datum) || (is_array($datum) && empty($datum))) {
            unset($this->datum);
        } else {
            $this->datum = $datum;
        }
        return $this;
    }
}
