<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteLicentiehouderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Verwijdert een licentiehouder bij een abonnement. Ofwel aboNo en relNo moeten opgegeven worden, ofwel licentiehouderNo moet worden opgegeven.
 * @subpackage Structs
 * @date 20240419 package
 */
class DeleteLicentiehouderRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Het abonnementnummer van het licentieabonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de licentiehouder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The licentiehouderNo
     * Meta information extracted from the WSDL
     * - documentation: De identifier die een licentiehouder uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentiehouderNo;
    /**
     * Constructor method for deleteLicentiehouderRequest
     * @uses DeleteLicentiehouderRequest::setRequestTag()
     * @uses DeleteLicentiehouderRequest::setAboNo()
     * @uses DeleteLicentiehouderRequest::setRelNo()
     * @uses DeleteLicentiehouderRequest::setLicentiehouderNo()
     * @param string $requestTag
     * @param int $aboNo
     * @param int $relNo
     * @param int $licentiehouderNo
     */
    public function __construct($requestTag = null, $aboNo = null, $relNo = null, $licentiehouderNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setRelNo($relNo)
            ->setLicentiehouderNo($licentiehouderNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get licentiehouderNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentiehouderNo()
    {
        return isset($this->licentiehouderNo) ? $this->licentiehouderNo : null;
    }
    /**
     * Set licentiehouderNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentiehouderNo
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderRequest
     */
    public function setLicentiehouderNo($licentiehouderNo = null)
    {
        // validation for constraint: int
        if (!is_null($licentiehouderNo) && !(is_int($licentiehouderNo) || ctype_digit($licentiehouderNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licentiehouderNo, true), gettype($licentiehouderNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($licentiehouderNo) && mb_strlen(preg_replace('/(\D)/', '', $licentiehouderNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($licentiehouderNo, true), mb_strlen(preg_replace('/(\D)/', '', $licentiehouderNo))), __LINE__);
        }
        if (is_null($licentiehouderNo) || (is_array($licentiehouderNo) && empty($licentiehouderNo))) {
            unset($this->licentiehouderNo);
        } else {
            $this->licentiehouderNo = $licentiehouderNo;
        }
        return $this;
    }
}
