<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboDebNawAboNawRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>createAboDebNoAboNo</b> te gebruiken i.c.m. de RelatieApiV6 om de relatie
 * aan te maken. </br></u> <br/> Aanmaken van een nieuw abonnement voor een relatie, waarbij zowel de NAW gegevens van de abonnee als de NAW gegevens van de debiteur meegegeven kan worden.
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAboDebNawAboNawRequest extends AbstractStructBase
{
    /**
     * The persoonsObjectAbo
     * Meta information extracted from the WSDL
     * - documentation: Persoonsgegevens voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoonsObjectAbo;
    /**
     * The persoonsObjectDeb
     * Meta information extracted from the WSDL
     * - documentation: Persoonsgegevens voor de betaler.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoonsObjectDeb;
    /**
     * The adresObjectDeb
     * Meta information extracted from the WSDL
     * - documentation: Adresgegevens voor de betaler.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $adresObjectDeb;
    /**
     * The aboObject
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsgegevens.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboObject
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The adresObjectAbo
     * Meta information extracted from the WSDL
     * - documentation: Adresgegevens voor de abonnee. Verplicht indien in de stamgegevens niet is opgegeven dat een abonnee zonder adres ingevoerd mag worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $adresObjectAbo;
    /**
     * The geenControleLopendAbo
     * Meta information extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The forceerNieuweKlantAbo
     * Meta information extracted from the WSDL
     * - documentation: Aanmaken nieuwe klant abonnee forceren, dus niet controleren of de klant al bestaat. Default false dus wel controleren en eventueel bestaande klant gebruiken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerNieuweKlantAbo;
    /**
     * The forceerNieuweKlantDeb
     * Meta information extracted from the WSDL
     * - documentation: Aanmaken nieuwe klant debiteur forceren, dus niet controleren of de klant al bestaat. Default false dus wel controleren en eventueel bestaande klant gebruiken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerNieuweKlantDeb;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie en abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createAboDebNawAboNawRequest
     * @uses CreateAboDebNawAboNawRequest::setPersoonsObjectAbo()
     * @uses CreateAboDebNawAboNawRequest::setPersoonsObjectDeb()
     * @uses CreateAboDebNawAboNawRequest::setAdresObjectDeb()
     * @uses CreateAboDebNawAboNawRequest::setAboObject()
     * @uses CreateAboDebNawAboNawRequest::setRequestTag()
     * @uses CreateAboDebNawAboNawRequest::setAdresObjectAbo()
     * @uses CreateAboDebNawAboNawRequest::setGeenControleLopendAbo()
     * @uses CreateAboDebNawAboNawRequest::setForceerNieuweKlantAbo()
     * @uses CreateAboDebNawAboNawRequest::setForceerNieuweKlantDeb()
     * @uses CreateAboDebNawAboNawRequest::setCanCreate()
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectDeb
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectAbo
     * @param bool $geenControleLopendAbo
     * @param bool $forceerNieuweKlantAbo
     * @param bool $forceerNieuweKlantDeb
     * @param bool $canCreate
     */
    public function __construct(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo = null, \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb = null, \AbonnementApiV6\StructType\AdresObject $adresObjectDeb = null, \AbonnementApiV6\StructType\AboObject $aboObject = null, $requestTag = null, \AbonnementApiV6\StructType\AdresObject $adresObjectAbo = null, $geenControleLopendAbo = null, $forceerNieuweKlantAbo = null, $forceerNieuweKlantDeb = null, $canCreate = null)
    {
        $this
            ->setPersoonsObjectAbo($persoonsObjectAbo)
            ->setPersoonsObjectDeb($persoonsObjectDeb)
            ->setAdresObjectDeb($adresObjectDeb)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setAdresObjectAbo($adresObjectAbo)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setForceerNieuweKlantAbo($forceerNieuweKlantAbo)
            ->setForceerNieuweKlantDeb($forceerNieuweKlantDeb)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObjectAbo value
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function getPersoonsObjectAbo()
    {
        return $this->persoonsObjectAbo;
    }
    /**
     * Set persoonsObjectAbo value
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setPersoonsObjectAbo(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectAbo = null)
    {
        $this->persoonsObjectAbo = $persoonsObjectAbo;
        return $this;
    }
    /**
     * Get persoonsObjectDeb value
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function getPersoonsObjectDeb()
    {
        return $this->persoonsObjectDeb;
    }
    /**
     * Set persoonsObjectDeb value
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setPersoonsObjectDeb(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb = null)
    {
        $this->persoonsObjectDeb = $persoonsObjectDeb;
        return $this;
    }
    /**
     * Get adresObjectDeb value
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function getAdresObjectDeb()
    {
        return $this->adresObjectDeb;
    }
    /**
     * Set adresObjectDeb value
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setAdresObjectDeb(\AbonnementApiV6\StructType\AdresObject $adresObjectDeb = null)
    {
        $this->adresObjectDeb = $adresObjectDeb;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setAboObject(\AbonnementApiV6\StructType\AboObject $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get adresObjectAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AdresObject|null
     */
    public function getAdresObjectAbo()
    {
        return isset($this->adresObjectAbo) ? $this->adresObjectAbo : null;
    }
    /**
     * Set adresObjectAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setAdresObjectAbo(\AbonnementApiV6\StructType\AdresObject $adresObjectAbo = null)
    {
        if (is_null($adresObjectAbo) || (is_array($adresObjectAbo) && empty($adresObjectAbo))) {
            unset($this->adresObjectAbo);
        } else {
            $this->adresObjectAbo = $adresObjectAbo;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get forceerNieuweKlantAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerNieuweKlantAbo()
    {
        return isset($this->forceerNieuweKlantAbo) ? $this->forceerNieuweKlantAbo : null;
    }
    /**
     * Set forceerNieuweKlantAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerNieuweKlantAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setForceerNieuweKlantAbo($forceerNieuweKlantAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerNieuweKlantAbo) && !is_bool($forceerNieuweKlantAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerNieuweKlantAbo, true), gettype($forceerNieuweKlantAbo)), __LINE__);
        }
        if (is_null($forceerNieuweKlantAbo) || (is_array($forceerNieuweKlantAbo) && empty($forceerNieuweKlantAbo))) {
            unset($this->forceerNieuweKlantAbo);
        } else {
            $this->forceerNieuweKlantAbo = $forceerNieuweKlantAbo;
        }
        return $this;
    }
    /**
     * Get forceerNieuweKlantDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerNieuweKlantDeb()
    {
        return isset($this->forceerNieuweKlantDeb) ? $this->forceerNieuweKlantDeb : null;
    }
    /**
     * Set forceerNieuweKlantDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerNieuweKlantDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setForceerNieuweKlantDeb($forceerNieuweKlantDeb = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerNieuweKlantDeb) && !is_bool($forceerNieuweKlantDeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerNieuweKlantDeb, true), gettype($forceerNieuweKlantDeb)), __LINE__);
        }
        if (is_null($forceerNieuweKlantDeb) || (is_array($forceerNieuweKlantDeb) && empty($forceerNieuweKlantDeb))) {
            unset($this->forceerNieuweKlantDeb);
        } else {
            $this->forceerNieuweKlantDeb = $forceerNieuweKlantDeb;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
