<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalamiteitTab StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met calamiteiten.
 * @subpackage Structs
 * @date 20240419 package
 */
class CalamiteitTab extends AbstractStructBase
{
    /**
     * The calamiteit
     * Meta information extracted from the WSDL
     * - documentation: Lijst met calamiteiten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Calamiteit[]
     */
    public $calamiteit;
    /**
     * Constructor method for CalamiteitTab
     * @uses CalamiteitTab::setCalamiteit()
     * @param \AbonnementApiV6\StructType\Calamiteit[] $calamiteit
     */
    public function __construct(array $calamiteit = array())
    {
        $this
            ->setCalamiteit($calamiteit);
    }
    /**
     * Get calamiteit value
     * @return \AbonnementApiV6\StructType\Calamiteit[]|null
     */
    public function getCalamiteit()
    {
        return $this->calamiteit;
    }
    /**
     * This method is responsible for validating the values passed to the setCalamiteit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCalamiteit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCalamiteitForArrayConstraintsFromSetCalamiteit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calamiteitTabCalamiteitItem) {
            // validation for constraint: itemType
            if (!$calamiteitTabCalamiteitItem instanceof \AbonnementApiV6\StructType\Calamiteit) {
                $invalidValues[] = is_object($calamiteitTabCalamiteitItem) ? get_class($calamiteitTabCalamiteitItem) : sprintf('%s(%s)', gettype($calamiteitTabCalamiteitItem), var_export($calamiteitTabCalamiteitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The calamiteit property can only contain items of type \AbonnementApiV6\StructType\Calamiteit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set calamiteit value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Calamiteit[] $calamiteit
     * @return \AbonnementApiV6\StructType\CalamiteitTab
     */
    public function setCalamiteit(array $calamiteit = array())
    {
        // validation for constraint: array
        if ('' !== ($calamiteitArrayErrorMessage = self::validateCalamiteitForArrayConstraintsFromSetCalamiteit($calamiteit))) {
            throw new \InvalidArgumentException($calamiteitArrayErrorMessage, __LINE__);
        }
        $this->calamiteit = $calamiteit;
        return $this;
    }
    /**
     * Add item to calamiteit value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Calamiteit $item
     * @return \AbonnementApiV6\StructType\CalamiteitTab
     */
    public function addToCalamiteit(\AbonnementApiV6\StructType\Calamiteit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Calamiteit) {
            throw new \InvalidArgumentException(sprintf('The calamiteit property can only contain items of type \AbonnementApiV6\StructType\Calamiteit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->calamiteit[] = $item;
        return $this;
    }
}
