<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresObject StructType
 * Meta information extracted from the WSDL
 * - documentation: Het adresobject bestaat uit de volgende velden
 * @subpackage Structs
 * @date 20240419 package
 */
class AdresObject extends AbstractStructBase
{
    /**
     * The relHuisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer, groter dan 0.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relHuisNummer;
    /**
     * The relHuisNummerToev
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer toevoeging.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relHuisNummerToev;
    /**
     * The relLandCode
     * Meta information extracted from the WSDL
     * - documentation: Land code, moet bestaan in de landen tabel.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relLandCode;
    /**
     * The relPlaats
     * Meta information extracted from the WSDL
     * - documentation: Woonplaats.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relPlaats;
    /**
     * The relPostcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relPostcode;
    /**
     * The relProvincieCode
     * Meta information extracted from the WSDL
     * - documentation: De Provincie waar iemand woont. Alleen noodzakelijk en toegestaan voor buitenland. Code moet bestaan in de provincie tabel. Provincie moet gekoppeld zijn aan Land.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relProvincieCode;
    /**
     * The relStraat
     * Meta information extracted from the WSDL
     * - documentation: Straatnaam.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relStraat;
    /**
     * Constructor method for AdresObject
     * @uses AdresObject::setRelHuisNummer()
     * @uses AdresObject::setRelHuisNummerToev()
     * @uses AdresObject::setRelLandCode()
     * @uses AdresObject::setRelPlaats()
     * @uses AdresObject::setRelPostcode()
     * @uses AdresObject::setRelProvincieCode()
     * @uses AdresObject::setRelStraat()
     * @param int $relHuisNummer
     * @param string $relHuisNummerToev
     * @param string $relLandCode
     * @param string $relPlaats
     * @param string $relPostcode
     * @param string $relProvincieCode
     * @param string $relStraat
     */
    public function __construct($relHuisNummer = null, $relHuisNummerToev = null, $relLandCode = null, $relPlaats = null, $relPostcode = null, $relProvincieCode = null, $relStraat = null)
    {
        $this
            ->setRelHuisNummer($relHuisNummer)
            ->setRelHuisNummerToev($relHuisNummerToev)
            ->setRelLandCode($relLandCode)
            ->setRelPlaats($relPlaats)
            ->setRelPostcode($relPostcode)
            ->setRelProvincieCode($relProvincieCode)
            ->setRelStraat($relStraat);
    }
    /**
     * Get relHuisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelHuisNummer()
    {
        return isset($this->relHuisNummer) ? $this->relHuisNummer : null;
    }
    /**
     * Set relHuisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relHuisNummer
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelHuisNummer($relHuisNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relHuisNummer) && !(is_int($relHuisNummer) || ctype_digit($relHuisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relHuisNummer, true), gettype($relHuisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relHuisNummer) && mb_strlen(preg_replace('/(\D)/', '', $relHuisNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relHuisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relHuisNummer))), __LINE__);
        }
        if (is_null($relHuisNummer) || (is_array($relHuisNummer) && empty($relHuisNummer))) {
            unset($this->relHuisNummer);
        } else {
            $this->relHuisNummer = $relHuisNummer;
        }
        return $this;
    }
    /**
     * Get relHuisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelHuisNummerToev()
    {
        return isset($this->relHuisNummerToev) ? $this->relHuisNummerToev : null;
    }
    /**
     * Set relHuisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relHuisNummerToev
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelHuisNummerToev($relHuisNummerToev = null)
    {
        // validation for constraint: string
        if (!is_null($relHuisNummerToev) && !is_string($relHuisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relHuisNummerToev, true), gettype($relHuisNummerToev)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($relHuisNummerToev) && mb_strlen($relHuisNummerToev) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($relHuisNummerToev)), __LINE__);
        }
        if (is_null($relHuisNummerToev) || (is_array($relHuisNummerToev) && empty($relHuisNummerToev))) {
            unset($this->relHuisNummerToev);
        } else {
            $this->relHuisNummerToev = $relHuisNummerToev;
        }
        return $this;
    }
    /**
     * Get relLandCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelLandCode()
    {
        return isset($this->relLandCode) ? $this->relLandCode : null;
    }
    /**
     * Set relLandCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relLandCode
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelLandCode($relLandCode = null)
    {
        // validation for constraint: string
        if (!is_null($relLandCode) && !is_string($relLandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relLandCode, true), gettype($relLandCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($relLandCode) && mb_strlen($relLandCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($relLandCode)), __LINE__);
        }
        if (is_null($relLandCode) || (is_array($relLandCode) && empty($relLandCode))) {
            unset($this->relLandCode);
        } else {
            $this->relLandCode = $relLandCode;
        }
        return $this;
    }
    /**
     * Get relPlaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelPlaats()
    {
        return isset($this->relPlaats) ? $this->relPlaats : null;
    }
    /**
     * Set relPlaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relPlaats
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelPlaats($relPlaats = null)
    {
        // validation for constraint: string
        if (!is_null($relPlaats) && !is_string($relPlaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relPlaats, true), gettype($relPlaats)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($relPlaats) && mb_strlen($relPlaats) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($relPlaats)), __LINE__);
        }
        if (is_null($relPlaats) || (is_array($relPlaats) && empty($relPlaats))) {
            unset($this->relPlaats);
        } else {
            $this->relPlaats = $relPlaats;
        }
        return $this;
    }
    /**
     * Get relPostcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelPostcode()
    {
        return isset($this->relPostcode) ? $this->relPostcode : null;
    }
    /**
     * Set relPostcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relPostcode
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelPostcode($relPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($relPostcode) && !is_string($relPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relPostcode, true), gettype($relPostcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($relPostcode) && mb_strlen($relPostcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($relPostcode)), __LINE__);
        }
        if (is_null($relPostcode) || (is_array($relPostcode) && empty($relPostcode))) {
            unset($this->relPostcode);
        } else {
            $this->relPostcode = $relPostcode;
        }
        return $this;
    }
    /**
     * Get relProvincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelProvincieCode()
    {
        return isset($this->relProvincieCode) ? $this->relProvincieCode : null;
    }
    /**
     * Set relProvincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relProvincieCode
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelProvincieCode($relProvincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($relProvincieCode) && !is_string($relProvincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relProvincieCode, true), gettype($relProvincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($relProvincieCode) && mb_strlen($relProvincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($relProvincieCode)), __LINE__);
        }
        if (is_null($relProvincieCode) || (is_array($relProvincieCode) && empty($relProvincieCode))) {
            unset($this->relProvincieCode);
        } else {
            $this->relProvincieCode = $relProvincieCode;
        }
        return $this;
    }
    /**
     * Get relStraat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelStraat()
    {
        return isset($this->relStraat) ? $this->relStraat : null;
    }
    /**
     * Set relStraat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relStraat
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function setRelStraat($relStraat = null)
    {
        // validation for constraint: string
        if (!is_null($relStraat) && !is_string($relStraat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relStraat, true), gettype($relStraat)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($relStraat) && mb_strlen($relStraat) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($relStraat)), __LINE__);
        }
        if (is_null($relStraat) || (is_array($relStraat) && empty($relStraat))) {
            unset($this->relStraat);
        } else {
            $this->relStraat = $relStraat;
        }
        return $this;
    }
}
