<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Abonnementsoort StructType
 * Meta information extracted from the WSDL
 * - documentation: Abonnementsoort object
 * @subpackage Structs
 * @date 20240419 package
 */
class Abonnementsoort extends AbstractStructBase
{
    /**
     * The abonnementsoortNo
     * Meta information extracted from the WSDL
     * - documentation: Interne sleutel van de abonnementsoort.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortNo;
    /**
     * The abonnementsoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de abonnementsoort.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The abonnementsoortNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de abonnementsoort.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortNaam;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de uitgave.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The artikelGroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de artikelgroep.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepCode;
    /**
     * The artikelGroepNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de artikelgroep.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepNaam;
    /**
     * The artikelHoofdgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de hoofdgroep.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelHoofdgroepCode;
    /**
     * The artikelHoofdgroepNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de hoofdgroep.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelHoofdgroepNaam;
    /**
     * The abonnementsoortBetaalwijze
     * Meta information extracted from the WSDL
     * - documentation: Betaalwijze van de abonnementsoort (0= Geen voorkeur, 1= Bij voorkeur aut. incasso, 2= Verplicht aut. incasso).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $abonnementsoortBetaalwijze;
    /**
     * The abonnementsoortPrijs
     * Meta information extracted from the WSDL
     * - documentation: Prijs exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $abonnementsoortPrijs;
    /**
     * The abonnementsoortBtwCode
     * Meta information extracted from the WSDL
     * - documentation: Code van BTW die van toepassing is.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortBtwCode;
    /**
     * The abonnementsoortBtwOmschr
     * Meta information extracted from the WSDL
     * - documentation: Naam van BTW die van toepassing is.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortBtwOmschr;
    /**
     * The abonnementsoortBtwPercentage
     * Meta information extracted from the WSDL
     * - documentation: BTW percentage.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortBtwPercentage;
    /**
     * The abonnementsoortPeriode
     * Meta information extracted from the WSDL
     * - documentation: Looptijd abonnement is in Edities, Jaar, Maanden, Weken of Einddatum.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortPeriode;
    /**
     * The abonnementsoortAantal
     * Meta information extracted from the WSDL
     * - documentation: Aantal periodes per abonnementsperiode.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortAantal;
    /**
     * The abonnementsoortVerlenging
     * Meta information extracted from the WSDL
     * - documentation: Automatisch verlenging (Automatisch verlengen, Niet automatisch verlengen, Overgang naar abonnement, Overgang naar Promo of Overgang naar Pakket).
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortVerlenging;
    /**
     * The abonnementsoortDoorlopend
     * Meta information extracted from the WSDL
     * - documentation: Abonnement doorlopend factureren, dus niet aan het begin van het jaar Ja/Nee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $abonnementsoortDoorlopend;
    /**
     * The abonnementsoortKortPerc
     * Meta information extracted from the WSDL
     * - documentation: Percentage korting op het abonnement.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortPerc;
    /**
     * The abonnementsoortKortBedr
     * Meta information extracted from the WSDL
     * - documentation: Bedrag korting op het abonnement.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortBedr;
    /**
     * The abonnementsoortKortIncasso
     * Meta information extracted from the WSDL
     * - documentation: Korting bij betaling via automatische incasso.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortIncasso;
    /**
     * The abonnementsoortVrijeTekst1
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 1, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst1;
    /**
     * The abonnementsoortVrijeTekst2
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 2, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst2;
    /**
     * The abonnementsoortVrijeTekst3
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 3, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst3;
    /**
     * The abonnementsoortVrijeTekst4
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 4, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst4;
    /**
     * The abonnementsoortVrijeTekst5
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 5, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst5;
    /**
     * The abonnementsoortVrijeTekst6
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 6, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst6;
    /**
     * The abonnementsoortVrijeTekst7
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 7, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst7;
    /**
     * The abonnementsoortVrijeTekst8
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 8, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst8;
    /**
     * The abonnementsoortVrijeTekst9
     * Meta information extracted from the WSDL
     * - documentation: Vrij tekst veld 9, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldTekst
     */
    public $abonnementsoortVrijeTekst9;
    /**
     * The abonnementsoortVrijeDatum1
     * Meta information extracted from the WSDL
     * - documentation: Vrij datum veld 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldDatum
     */
    public $abonnementsoortVrijeDatum1;
    /**
     * The abonnementsoortVrijeDatum2
     * Meta information extracted from the WSDL
     * - documentation: Vrij datum veld 2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldDatum
     */
    public $abonnementsoortVrijeDatum2;
    /**
     * The abonnementsoortVrijCode1
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode1;
    /**
     * The abonnementsoortVrijCode2
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode2;
    /**
     * The abonnementsoortVrijCode3
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 3.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode3;
    /**
     * The abonnementsoortVrijCode4
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 4.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode4;
    /**
     * The abonnementsoortVrijCode5
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 5.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode5;
    /**
     * The abonnementsoortVrijCode6
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 6.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode6;
    /**
     * The abonnementsoortVrijCode7
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 7.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode7;
    /**
     * The abonnementsoortVrijCode8
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 8.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode8;
    /**
     * The abonnementsoortVrijCode9
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 9.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode9;
    /**
     * The abonnementsoortVrijCode10
     * Meta information extracted from the WSDL
     * - documentation: Vrij code veld 10.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijVeldCode
     */
    public $abonnementsoortVrijCode10;
    /**
     * The abonnementsoortActief
     * Meta information extracted from the WSDL
     * - documentation: Indicatie abonnementsoort actief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $abonnementsoortActief;
    /**
     * The organisatieLicentie
     * Meta information extracted from the WSDL
     * - documentation: Indicatie organisatie licentie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $organisatieLicentie;
    /**
     * The buitenland
     * Meta information extracted from the WSDL
     * - documentation: Indicatie abonnement leverbaar in het buitenland.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $buitenland;
    /**
     * Constructor method for Abonnementsoort
     * @uses Abonnementsoort::setAbonnementsoortNo()
     * @uses Abonnementsoort::setAbonnementsoortCode()
     * @uses Abonnementsoort::setAbonnementsoortNaam()
     * @uses Abonnementsoort::setUitgaveCode()
     * @uses Abonnementsoort::setUitgaveNaam()
     * @uses Abonnementsoort::setArtikelGroepCode()
     * @uses Abonnementsoort::setArtikelGroepNaam()
     * @uses Abonnementsoort::setArtikelHoofdgroepCode()
     * @uses Abonnementsoort::setArtikelHoofdgroepNaam()
     * @uses Abonnementsoort::setAbonnementsoortBetaalwijze()
     * @uses Abonnementsoort::setAbonnementsoortPrijs()
     * @uses Abonnementsoort::setAbonnementsoortBtwCode()
     * @uses Abonnementsoort::setAbonnementsoortBtwOmschr()
     * @uses Abonnementsoort::setAbonnementsoortBtwPercentage()
     * @uses Abonnementsoort::setAbonnementsoortPeriode()
     * @uses Abonnementsoort::setAbonnementsoortAantal()
     * @uses Abonnementsoort::setAbonnementsoortVerlenging()
     * @uses Abonnementsoort::setAbonnementsoortDoorlopend()
     * @uses Abonnementsoort::setAbonnementsoortKortPerc()
     * @uses Abonnementsoort::setAbonnementsoortKortBedr()
     * @uses Abonnementsoort::setAbonnementsoortKortIncasso()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst1()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst2()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst3()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst4()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst5()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst6()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst7()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst8()
     * @uses Abonnementsoort::setAbonnementsoortVrijeTekst9()
     * @uses Abonnementsoort::setAbonnementsoortVrijeDatum1()
     * @uses Abonnementsoort::setAbonnementsoortVrijeDatum2()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode1()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode2()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode3()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode4()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode5()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode6()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode7()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode8()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode9()
     * @uses Abonnementsoort::setAbonnementsoortVrijCode10()
     * @uses Abonnementsoort::setAbonnementsoortActief()
     * @uses Abonnementsoort::setOrganisatieLicentie()
     * @uses Abonnementsoort::setBuitenland()
     * @param int $abonnementsoortNo
     * @param string $abonnementsoortCode
     * @param string $abonnementsoortNaam
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param string $artikelGroepCode
     * @param string $artikelGroepNaam
     * @param string $artikelHoofdgroepCode
     * @param string $artikelHoofdgroepNaam
     * @param int $abonnementsoortBetaalwijze
     * @param float $abonnementsoortPrijs
     * @param string $abonnementsoortBtwCode
     * @param string $abonnementsoortBtwOmschr
     * @param float $abonnementsoortBtwPercentage
     * @param string $abonnementsoortPeriode
     * @param int $abonnementsoortAantal
     * @param string $abonnementsoortVerlenging
     * @param bool $abonnementsoortDoorlopend
     * @param float $abonnementsoortKortPerc
     * @param float $abonnementsoortKortBedr
     * @param float $abonnementsoortKortIncasso
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst1
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst2
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst3
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst4
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst5
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst6
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst7
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst8
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst9
     * @param \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum1
     * @param \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum2
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode1
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode2
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode3
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode4
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode5
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode6
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode7
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode8
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode9
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode10
     * @param bool $abonnementsoortActief
     * @param bool $organisatieLicentie
     * @param bool $buitenland
     */
    public function __construct($abonnementsoortNo = null, $abonnementsoortCode = null, $abonnementsoortNaam = null, $uitgaveCode = null, $uitgaveNaam = null, $artikelGroepCode = null, $artikelGroepNaam = null, $artikelHoofdgroepCode = null, $artikelHoofdgroepNaam = null, $abonnementsoortBetaalwijze = null, $abonnementsoortPrijs = null, $abonnementsoortBtwCode = null, $abonnementsoortBtwOmschr = null, $abonnementsoortBtwPercentage = null, $abonnementsoortPeriode = null, $abonnementsoortAantal = null, $abonnementsoortVerlenging = null, $abonnementsoortDoorlopend = null, $abonnementsoortKortPerc = null, $abonnementsoortKortBedr = null, $abonnementsoortKortIncasso = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst1 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst2 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst3 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst4 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst5 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst6 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst7 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst8 = null, \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst9 = null, \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum1 = null, \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum2 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode1 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode2 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode3 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode4 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode5 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode6 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode7 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode8 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode9 = null, \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode10 = null, $abonnementsoortActief = null, $organisatieLicentie = null, $buitenland = null)
    {
        $this
            ->setAbonnementsoortNo($abonnementsoortNo)
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setAbonnementsoortNaam($abonnementsoortNaam)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setArtikelGroepCode($artikelGroepCode)
            ->setArtikelGroepNaam($artikelGroepNaam)
            ->setArtikelHoofdgroepCode($artikelHoofdgroepCode)
            ->setArtikelHoofdgroepNaam($artikelHoofdgroepNaam)
            ->setAbonnementsoortBetaalwijze($abonnementsoortBetaalwijze)
            ->setAbonnementsoortPrijs($abonnementsoortPrijs)
            ->setAbonnementsoortBtwCode($abonnementsoortBtwCode)
            ->setAbonnementsoortBtwOmschr($abonnementsoortBtwOmschr)
            ->setAbonnementsoortBtwPercentage($abonnementsoortBtwPercentage)
            ->setAbonnementsoortPeriode($abonnementsoortPeriode)
            ->setAbonnementsoortAantal($abonnementsoortAantal)
            ->setAbonnementsoortVerlenging($abonnementsoortVerlenging)
            ->setAbonnementsoortDoorlopend($abonnementsoortDoorlopend)
            ->setAbonnementsoortKortPerc($abonnementsoortKortPerc)
            ->setAbonnementsoortKortBedr($abonnementsoortKortBedr)
            ->setAbonnementsoortKortIncasso($abonnementsoortKortIncasso)
            ->setAbonnementsoortVrijeTekst1($abonnementsoortVrijeTekst1)
            ->setAbonnementsoortVrijeTekst2($abonnementsoortVrijeTekst2)
            ->setAbonnementsoortVrijeTekst3($abonnementsoortVrijeTekst3)
            ->setAbonnementsoortVrijeTekst4($abonnementsoortVrijeTekst4)
            ->setAbonnementsoortVrijeTekst5($abonnementsoortVrijeTekst5)
            ->setAbonnementsoortVrijeTekst6($abonnementsoortVrijeTekst6)
            ->setAbonnementsoortVrijeTekst7($abonnementsoortVrijeTekst7)
            ->setAbonnementsoortVrijeTekst8($abonnementsoortVrijeTekst8)
            ->setAbonnementsoortVrijeTekst9($abonnementsoortVrijeTekst9)
            ->setAbonnementsoortVrijeDatum1($abonnementsoortVrijeDatum1)
            ->setAbonnementsoortVrijeDatum2($abonnementsoortVrijeDatum2)
            ->setAbonnementsoortVrijCode1($abonnementsoortVrijCode1)
            ->setAbonnementsoortVrijCode2($abonnementsoortVrijCode2)
            ->setAbonnementsoortVrijCode3($abonnementsoortVrijCode3)
            ->setAbonnementsoortVrijCode4($abonnementsoortVrijCode4)
            ->setAbonnementsoortVrijCode5($abonnementsoortVrijCode5)
            ->setAbonnementsoortVrijCode6($abonnementsoortVrijCode6)
            ->setAbonnementsoortVrijCode7($abonnementsoortVrijCode7)
            ->setAbonnementsoortVrijCode8($abonnementsoortVrijCode8)
            ->setAbonnementsoortVrijCode9($abonnementsoortVrijCode9)
            ->setAbonnementsoortVrijCode10($abonnementsoortVrijCode10)
            ->setAbonnementsoortActief($abonnementsoortActief)
            ->setOrganisatieLicentie($organisatieLicentie)
            ->setBuitenland($buitenland);
    }
    /**
     * Get abonnementsoortNo value
     * @return int
     */
    public function getAbonnementsoortNo()
    {
        return $this->abonnementsoortNo;
    }
    /**
     * Set abonnementsoortNo value
     * @param int $abonnementsoortNo
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortNo($abonnementsoortNo = null)
    {
        // validation for constraint: int
        if (!is_null($abonnementsoortNo) && !(is_int($abonnementsoortNo) || ctype_digit($abonnementsoortNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abonnementsoortNo, true), gettype($abonnementsoortNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($abonnementsoortNo) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($abonnementsoortNo, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortNo))), __LINE__);
        }
        $this->abonnementsoortNo = $abonnementsoortNo;
        return $this;
    }
    /**
     * Get abonnementsoortCode value
     * @return string
     */
    public function getAbonnementsoortCode()
    {
        return $this->abonnementsoortCode;
    }
    /**
     * Set abonnementsoortCode value
     * @param string $abonnementsoortCode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortCode, true), gettype($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($abonnementsoortCode) && mb_strlen($abonnementsoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($abonnementsoortCode) && mb_strlen($abonnementsoortCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($abonnementsoortCode)), __LINE__);
        }
        $this->abonnementsoortCode = $abonnementsoortCode;
        return $this;
    }
    /**
     * Get abonnementsoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortNaam()
    {
        return isset($this->abonnementsoortNaam) ? $this->abonnementsoortNaam : null;
    }
    /**
     * Set abonnementsoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortNaam
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortNaam($abonnementsoortNaam = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortNaam) && !is_string($abonnementsoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortNaam, true), gettype($abonnementsoortNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($abonnementsoortNaam) && mb_strlen($abonnementsoortNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($abonnementsoortNaam)), __LINE__);
        }
        if (is_null($abonnementsoortNaam) || (is_array($abonnementsoortNaam) && empty($abonnementsoortNaam))) {
            unset($this->abonnementsoortNaam);
        } else {
            $this->abonnementsoortNaam = $abonnementsoortNaam;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get artikelGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepCode()
    {
        return isset($this->artikelGroepCode) ? $this->artikelGroepCode : null;
    }
    /**
     * Set artikelGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepCode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setArtikelGroepCode($artikelGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepCode) && !is_string($artikelGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepCode, true), gettype($artikelGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($artikelGroepCode) && mb_strlen($artikelGroepCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($artikelGroepCode)), __LINE__);
        }
        if (is_null($artikelGroepCode) || (is_array($artikelGroepCode) && empty($artikelGroepCode))) {
            unset($this->artikelGroepCode);
        } else {
            $this->artikelGroepCode = $artikelGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepNaam()
    {
        return isset($this->artikelGroepNaam) ? $this->artikelGroepNaam : null;
    }
    /**
     * Set artikelGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepNaam
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setArtikelGroepNaam($artikelGroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepNaam) && !is_string($artikelGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepNaam, true), gettype($artikelGroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($artikelGroepNaam) && mb_strlen($artikelGroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($artikelGroepNaam)), __LINE__);
        }
        if (is_null($artikelGroepNaam) || (is_array($artikelGroepNaam) && empty($artikelGroepNaam))) {
            unset($this->artikelGroepNaam);
        } else {
            $this->artikelGroepNaam = $artikelGroepNaam;
        }
        return $this;
    }
    /**
     * Get artikelHoofdgroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdgroepCode()
    {
        return isset($this->artikelHoofdgroepCode) ? $this->artikelHoofdgroepCode : null;
    }
    /**
     * Set artikelHoofdgroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdgroepCode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setArtikelHoofdgroepCode($artikelHoofdgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelHoofdgroepCode) && !is_string($artikelHoofdgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelHoofdgroepCode, true), gettype($artikelHoofdgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($artikelHoofdgroepCode) && mb_strlen($artikelHoofdgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($artikelHoofdgroepCode)), __LINE__);
        }
        if (is_null($artikelHoofdgroepCode) || (is_array($artikelHoofdgroepCode) && empty($artikelHoofdgroepCode))) {
            unset($this->artikelHoofdgroepCode);
        } else {
            $this->artikelHoofdgroepCode = $artikelHoofdgroepCode;
        }
        return $this;
    }
    /**
     * Get artikelHoofdgroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdgroepNaam()
    {
        return isset($this->artikelHoofdgroepNaam) ? $this->artikelHoofdgroepNaam : null;
    }
    /**
     * Set artikelHoofdgroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdgroepNaam
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setArtikelHoofdgroepNaam($artikelHoofdgroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelHoofdgroepNaam) && !is_string($artikelHoofdgroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelHoofdgroepNaam, true), gettype($artikelHoofdgroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($artikelHoofdgroepNaam) && mb_strlen($artikelHoofdgroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($artikelHoofdgroepNaam)), __LINE__);
        }
        if (is_null($artikelHoofdgroepNaam) || (is_array($artikelHoofdgroepNaam) && empty($artikelHoofdgroepNaam))) {
            unset($this->artikelHoofdgroepNaam);
        } else {
            $this->artikelHoofdgroepNaam = $artikelHoofdgroepNaam;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBetaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortBetaalwijze()
    {
        return isset($this->abonnementsoortBetaalwijze) ? $this->abonnementsoortBetaalwijze : null;
    }
    /**
     * Set abonnementsoortBetaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortBetaalwijze
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortBetaalwijze($abonnementsoortBetaalwijze = null)
    {
        // validation for constraint: int
        if (!is_null($abonnementsoortBetaalwijze) && !(is_int($abonnementsoortBetaalwijze) || ctype_digit($abonnementsoortBetaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abonnementsoortBetaalwijze, true), gettype($abonnementsoortBetaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($abonnementsoortBetaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortBetaalwijze)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($abonnementsoortBetaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortBetaalwijze))), __LINE__);
        }
        if (is_null($abonnementsoortBetaalwijze) || (is_array($abonnementsoortBetaalwijze) && empty($abonnementsoortBetaalwijze))) {
            unset($this->abonnementsoortBetaalwijze);
        } else {
            $this->abonnementsoortBetaalwijze = $abonnementsoortBetaalwijze;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijs()
    {
        return isset($this->abonnementsoortPrijs) ? $this->abonnementsoortPrijs : null;
    }
    /**
     * Set abonnementsoortPrijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijs
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortPrijs($abonnementsoortPrijs = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortPrijs) && !(is_float($abonnementsoortPrijs) || is_numeric($abonnementsoortPrijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortPrijs, true), gettype($abonnementsoortPrijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($abonnementsoortPrijs) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($abonnementsoortPrijs, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijs))), __LINE__);
        }
        if (is_null($abonnementsoortPrijs) || (is_array($abonnementsoortPrijs) && empty($abonnementsoortPrijs))) {
            unset($this->abonnementsoortPrijs);
        } else {
            $this->abonnementsoortPrijs = $abonnementsoortPrijs;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortBtwCode()
    {
        return isset($this->abonnementsoortBtwCode) ? $this->abonnementsoortBtwCode : null;
    }
    /**
     * Set abonnementsoortBtwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortBtwCode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortBtwCode($abonnementsoortBtwCode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortBtwCode) && !is_string($abonnementsoortBtwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortBtwCode, true), gettype($abonnementsoortBtwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($abonnementsoortBtwCode) && mb_strlen($abonnementsoortBtwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($abonnementsoortBtwCode)), __LINE__);
        }
        if (is_null($abonnementsoortBtwCode) || (is_array($abonnementsoortBtwCode) && empty($abonnementsoortBtwCode))) {
            unset($this->abonnementsoortBtwCode);
        } else {
            $this->abonnementsoortBtwCode = $abonnementsoortBtwCode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortBtwOmschr()
    {
        return isset($this->abonnementsoortBtwOmschr) ? $this->abonnementsoortBtwOmschr : null;
    }
    /**
     * Set abonnementsoortBtwOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortBtwOmschr
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortBtwOmschr($abonnementsoortBtwOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortBtwOmschr) && !is_string($abonnementsoortBtwOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortBtwOmschr, true), gettype($abonnementsoortBtwOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($abonnementsoortBtwOmschr) && mb_strlen($abonnementsoortBtwOmschr) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($abonnementsoortBtwOmschr)), __LINE__);
        }
        if (is_null($abonnementsoortBtwOmschr) || (is_array($abonnementsoortBtwOmschr) && empty($abonnementsoortBtwOmschr))) {
            unset($this->abonnementsoortBtwOmschr);
        } else {
            $this->abonnementsoortBtwOmschr = $abonnementsoortBtwOmschr;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortBtwPercentage()
    {
        return isset($this->abonnementsoortBtwPercentage) ? $this->abonnementsoortBtwPercentage : null;
    }
    /**
     * Set abonnementsoortBtwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortBtwPercentage
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortBtwPercentage($abonnementsoortBtwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortBtwPercentage) && !(is_float($abonnementsoortBtwPercentage) || is_numeric($abonnementsoortBtwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortBtwPercentage, true), gettype($abonnementsoortBtwPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortBtwPercentage) && mb_strlen(mb_substr($abonnementsoortBtwPercentage, false !== mb_strpos($abonnementsoortBtwPercentage, '.') ? mb_strpos($abonnementsoortBtwPercentage, '.') + 1 : mb_strlen($abonnementsoortBtwPercentage))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortBtwPercentage, true), mb_strlen(mb_substr($abonnementsoortBtwPercentage, mb_strpos($abonnementsoortBtwPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortBtwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortBtwPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortBtwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortBtwPercentage))), __LINE__);
        }
        if (is_null($abonnementsoortBtwPercentage) || (is_array($abonnementsoortBtwPercentage) && empty($abonnementsoortBtwPercentage))) {
            unset($this->abonnementsoortBtwPercentage);
        } else {
            $this->abonnementsoortBtwPercentage = $abonnementsoortBtwPercentage;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPeriode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortPeriode()
    {
        return isset($this->abonnementsoortPeriode) ? $this->abonnementsoortPeriode : null;
    }
    /**
     * Set abonnementsoortPeriode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortPeriode
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortPeriode($abonnementsoortPeriode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortPeriode) && !is_string($abonnementsoortPeriode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortPeriode, true), gettype($abonnementsoortPeriode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($abonnementsoortPeriode) && mb_strlen($abonnementsoortPeriode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($abonnementsoortPeriode)), __LINE__);
        }
        if (is_null($abonnementsoortPeriode) || (is_array($abonnementsoortPeriode) && empty($abonnementsoortPeriode))) {
            unset($this->abonnementsoortPeriode);
        } else {
            $this->abonnementsoortPeriode = $abonnementsoortPeriode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortAantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortAantal()
    {
        return isset($this->abonnementsoortAantal) ? $this->abonnementsoortAantal : null;
    }
    /**
     * Set abonnementsoortAantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortAantal
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortAantal($abonnementsoortAantal = null)
    {
        // validation for constraint: int
        if (!is_null($abonnementsoortAantal) && !(is_int($abonnementsoortAantal) || ctype_digit($abonnementsoortAantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abonnementsoortAantal, true), gettype($abonnementsoortAantal)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($abonnementsoortAantal) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortAantal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($abonnementsoortAantal, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortAantal))), __LINE__);
        }
        if (is_null($abonnementsoortAantal) || (is_array($abonnementsoortAantal) && empty($abonnementsoortAantal))) {
            unset($this->abonnementsoortAantal);
        } else {
            $this->abonnementsoortAantal = $abonnementsoortAantal;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVerlenging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortVerlenging()
    {
        return isset($this->abonnementsoortVerlenging) ? $this->abonnementsoortVerlenging : null;
    }
    /**
     * Set abonnementsoortVerlenging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortVerlenging
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVerlenging($abonnementsoortVerlenging = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortVerlenging) && !is_string($abonnementsoortVerlenging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortVerlenging, true), gettype($abonnementsoortVerlenging)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($abonnementsoortVerlenging) && mb_strlen($abonnementsoortVerlenging) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($abonnementsoortVerlenging)), __LINE__);
        }
        if (is_null($abonnementsoortVerlenging) || (is_array($abonnementsoortVerlenging) && empty($abonnementsoortVerlenging))) {
            unset($this->abonnementsoortVerlenging);
        } else {
            $this->abonnementsoortVerlenging = $abonnementsoortVerlenging;
        }
        return $this;
    }
    /**
     * Get abonnementsoortDoorlopend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAbonnementsoortDoorlopend()
    {
        return isset($this->abonnementsoortDoorlopend) ? $this->abonnementsoortDoorlopend : null;
    }
    /**
     * Set abonnementsoortDoorlopend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $abonnementsoortDoorlopend
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortDoorlopend($abonnementsoortDoorlopend = null)
    {
        // validation for constraint: boolean
        if (!is_null($abonnementsoortDoorlopend) && !is_bool($abonnementsoortDoorlopend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abonnementsoortDoorlopend, true), gettype($abonnementsoortDoorlopend)), __LINE__);
        }
        if (is_null($abonnementsoortDoorlopend) || (is_array($abonnementsoortDoorlopend) && empty($abonnementsoortDoorlopend))) {
            unset($this->abonnementsoortDoorlopend);
        } else {
            $this->abonnementsoortDoorlopend = $abonnementsoortDoorlopend;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortPerc()
    {
        return isset($this->abonnementsoortKortPerc) ? $this->abonnementsoortKortPerc : null;
    }
    /**
     * Set abonnementsoortKortPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortPerc
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortKortPerc($abonnementsoortKortPerc = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortKortPerc) && !(is_float($abonnementsoortKortPerc) || is_numeric($abonnementsoortKortPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortKortPerc, true), gettype($abonnementsoortKortPerc)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortKortPerc) && mb_strlen(mb_substr($abonnementsoortKortPerc, false !== mb_strpos($abonnementsoortKortPerc, '.') ? mb_strpos($abonnementsoortKortPerc, '.') + 1 : mb_strlen($abonnementsoortKortPerc))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortKortPerc, true), mb_strlen(mb_substr($abonnementsoortKortPerc, mb_strpos($abonnementsoortKortPerc, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortKortPerc) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortPerc)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortKortPerc, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortPerc))), __LINE__);
        }
        if (is_null($abonnementsoortKortPerc) || (is_array($abonnementsoortKortPerc) && empty($abonnementsoortKortPerc))) {
            unset($this->abonnementsoortKortPerc);
        } else {
            $this->abonnementsoortKortPerc = $abonnementsoortKortPerc;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortBedr()
    {
        return isset($this->abonnementsoortKortBedr) ? $this->abonnementsoortKortBedr : null;
    }
    /**
     * Set abonnementsoortKortBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortBedr
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortKortBedr($abonnementsoortKortBedr = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortKortBedr) && !(is_float($abonnementsoortKortBedr) || is_numeric($abonnementsoortKortBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortKortBedr, true), gettype($abonnementsoortKortBedr)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortKortBedr) && mb_strlen(mb_substr($abonnementsoortKortBedr, false !== mb_strpos($abonnementsoortKortBedr, '.') ? mb_strpos($abonnementsoortKortBedr, '.') + 1 : mb_strlen($abonnementsoortKortBedr))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortKortBedr, true), mb_strlen(mb_substr($abonnementsoortKortBedr, mb_strpos($abonnementsoortKortBedr, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortKortBedr) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortBedr)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortKortBedr, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortBedr))), __LINE__);
        }
        if (is_null($abonnementsoortKortBedr) || (is_array($abonnementsoortKortBedr) && empty($abonnementsoortKortBedr))) {
            unset($this->abonnementsoortKortBedr);
        } else {
            $this->abonnementsoortKortBedr = $abonnementsoortKortBedr;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortIncasso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortIncasso()
    {
        return isset($this->abonnementsoortKortIncasso) ? $this->abonnementsoortKortIncasso : null;
    }
    /**
     * Set abonnementsoortKortIncasso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortIncasso
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortKortIncasso($abonnementsoortKortIncasso = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortKortIncasso) && !(is_float($abonnementsoortKortIncasso) || is_numeric($abonnementsoortKortIncasso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortKortIncasso, true), gettype($abonnementsoortKortIncasso)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortKortIncasso) && mb_strlen(mb_substr($abonnementsoortKortIncasso, false !== mb_strpos($abonnementsoortKortIncasso, '.') ? mb_strpos($abonnementsoortKortIncasso, '.') + 1 : mb_strlen($abonnementsoortKortIncasso))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortKortIncasso, true), mb_strlen(mb_substr($abonnementsoortKortIncasso, mb_strpos($abonnementsoortKortIncasso, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortKortIncasso) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortIncasso)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortKortIncasso, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortKortIncasso))), __LINE__);
        }
        if (is_null($abonnementsoortKortIncasso) || (is_array($abonnementsoortKortIncasso) && empty($abonnementsoortKortIncasso))) {
            unset($this->abonnementsoortKortIncasso);
        } else {
            $this->abonnementsoortKortIncasso = $abonnementsoortKortIncasso;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst1()
    {
        return isset($this->abonnementsoortVrijeTekst1) ? $this->abonnementsoortVrijeTekst1 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst1
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst1(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst1 = null)
    {
        if (is_null($abonnementsoortVrijeTekst1) || (is_array($abonnementsoortVrijeTekst1) && empty($abonnementsoortVrijeTekst1))) {
            unset($this->abonnementsoortVrijeTekst1);
        } else {
            $this->abonnementsoortVrijeTekst1 = $abonnementsoortVrijeTekst1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst2()
    {
        return isset($this->abonnementsoortVrijeTekst2) ? $this->abonnementsoortVrijeTekst2 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst2
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst2(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst2 = null)
    {
        if (is_null($abonnementsoortVrijeTekst2) || (is_array($abonnementsoortVrijeTekst2) && empty($abonnementsoortVrijeTekst2))) {
            unset($this->abonnementsoortVrijeTekst2);
        } else {
            $this->abonnementsoortVrijeTekst2 = $abonnementsoortVrijeTekst2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst3()
    {
        return isset($this->abonnementsoortVrijeTekst3) ? $this->abonnementsoortVrijeTekst3 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst3
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst3(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst3 = null)
    {
        if (is_null($abonnementsoortVrijeTekst3) || (is_array($abonnementsoortVrijeTekst3) && empty($abonnementsoortVrijeTekst3))) {
            unset($this->abonnementsoortVrijeTekst3);
        } else {
            $this->abonnementsoortVrijeTekst3 = $abonnementsoortVrijeTekst3;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst4()
    {
        return isset($this->abonnementsoortVrijeTekst4) ? $this->abonnementsoortVrijeTekst4 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst4
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst4(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst4 = null)
    {
        if (is_null($abonnementsoortVrijeTekst4) || (is_array($abonnementsoortVrijeTekst4) && empty($abonnementsoortVrijeTekst4))) {
            unset($this->abonnementsoortVrijeTekst4);
        } else {
            $this->abonnementsoortVrijeTekst4 = $abonnementsoortVrijeTekst4;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst5()
    {
        return isset($this->abonnementsoortVrijeTekst5) ? $this->abonnementsoortVrijeTekst5 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst5
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst5(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst5 = null)
    {
        if (is_null($abonnementsoortVrijeTekst5) || (is_array($abonnementsoortVrijeTekst5) && empty($abonnementsoortVrijeTekst5))) {
            unset($this->abonnementsoortVrijeTekst5);
        } else {
            $this->abonnementsoortVrijeTekst5 = $abonnementsoortVrijeTekst5;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst6()
    {
        return isset($this->abonnementsoortVrijeTekst6) ? $this->abonnementsoortVrijeTekst6 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst6
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst6(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst6 = null)
    {
        if (is_null($abonnementsoortVrijeTekst6) || (is_array($abonnementsoortVrijeTekst6) && empty($abonnementsoortVrijeTekst6))) {
            unset($this->abonnementsoortVrijeTekst6);
        } else {
            $this->abonnementsoortVrijeTekst6 = $abonnementsoortVrijeTekst6;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst7()
    {
        return isset($this->abonnementsoortVrijeTekst7) ? $this->abonnementsoortVrijeTekst7 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst7
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst7(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst7 = null)
    {
        if (is_null($abonnementsoortVrijeTekst7) || (is_array($abonnementsoortVrijeTekst7) && empty($abonnementsoortVrijeTekst7))) {
            unset($this->abonnementsoortVrijeTekst7);
        } else {
            $this->abonnementsoortVrijeTekst7 = $abonnementsoortVrijeTekst7;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst8()
    {
        return isset($this->abonnementsoortVrijeTekst8) ? $this->abonnementsoortVrijeTekst8 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst8
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst8(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst8 = null)
    {
        if (is_null($abonnementsoortVrijeTekst8) || (is_array($abonnementsoortVrijeTekst8) && empty($abonnementsoortVrijeTekst8))) {
            unset($this->abonnementsoortVrijeTekst8);
        } else {
            $this->abonnementsoortVrijeTekst8 = $abonnementsoortVrijeTekst8;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldTekst|null
     */
    public function getAbonnementsoortVrijeTekst9()
    {
        return isset($this->abonnementsoortVrijeTekst9) ? $this->abonnementsoortVrijeTekst9 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst9
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeTekst9(\AbonnementApiV6\StructType\VrijVeldTekst $abonnementsoortVrijeTekst9 = null)
    {
        if (is_null($abonnementsoortVrijeTekst9) || (is_array($abonnementsoortVrijeTekst9) && empty($abonnementsoortVrijeTekst9))) {
            unset($this->abonnementsoortVrijeTekst9);
        } else {
            $this->abonnementsoortVrijeTekst9 = $abonnementsoortVrijeTekst9;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeDatum1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldDatum|null
     */
    public function getAbonnementsoortVrijeDatum1()
    {
        return isset($this->abonnementsoortVrijeDatum1) ? $this->abonnementsoortVrijeDatum1 : null;
    }
    /**
     * Set abonnementsoortVrijeDatum1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum1
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeDatum1(\AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum1 = null)
    {
        if (is_null($abonnementsoortVrijeDatum1) || (is_array($abonnementsoortVrijeDatum1) && empty($abonnementsoortVrijeDatum1))) {
            unset($this->abonnementsoortVrijeDatum1);
        } else {
            $this->abonnementsoortVrijeDatum1 = $abonnementsoortVrijeDatum1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeDatum2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldDatum|null
     */
    public function getAbonnementsoortVrijeDatum2()
    {
        return isset($this->abonnementsoortVrijeDatum2) ? $this->abonnementsoortVrijeDatum2 : null;
    }
    /**
     * Set abonnementsoortVrijeDatum2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum2
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijeDatum2(\AbonnementApiV6\StructType\VrijVeldDatum $abonnementsoortVrijeDatum2 = null)
    {
        if (is_null($abonnementsoortVrijeDatum2) || (is_array($abonnementsoortVrijeDatum2) && empty($abonnementsoortVrijeDatum2))) {
            unset($this->abonnementsoortVrijeDatum2);
        } else {
            $this->abonnementsoortVrijeDatum2 = $abonnementsoortVrijeDatum2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode1()
    {
        return isset($this->abonnementsoortVrijCode1) ? $this->abonnementsoortVrijCode1 : null;
    }
    /**
     * Set abonnementsoortVrijCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode1
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode1(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode1 = null)
    {
        if (is_null($abonnementsoortVrijCode1) || (is_array($abonnementsoortVrijCode1) && empty($abonnementsoortVrijCode1))) {
            unset($this->abonnementsoortVrijCode1);
        } else {
            $this->abonnementsoortVrijCode1 = $abonnementsoortVrijCode1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode2()
    {
        return isset($this->abonnementsoortVrijCode2) ? $this->abonnementsoortVrijCode2 : null;
    }
    /**
     * Set abonnementsoortVrijCode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode2
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode2(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode2 = null)
    {
        if (is_null($abonnementsoortVrijCode2) || (is_array($abonnementsoortVrijCode2) && empty($abonnementsoortVrijCode2))) {
            unset($this->abonnementsoortVrijCode2);
        } else {
            $this->abonnementsoortVrijCode2 = $abonnementsoortVrijCode2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode3()
    {
        return isset($this->abonnementsoortVrijCode3) ? $this->abonnementsoortVrijCode3 : null;
    }
    /**
     * Set abonnementsoortVrijCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode3
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode3(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode3 = null)
    {
        if (is_null($abonnementsoortVrijCode3) || (is_array($abonnementsoortVrijCode3) && empty($abonnementsoortVrijCode3))) {
            unset($this->abonnementsoortVrijCode3);
        } else {
            $this->abonnementsoortVrijCode3 = $abonnementsoortVrijCode3;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode4()
    {
        return isset($this->abonnementsoortVrijCode4) ? $this->abonnementsoortVrijCode4 : null;
    }
    /**
     * Set abonnementsoortVrijCode4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode4
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode4(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode4 = null)
    {
        if (is_null($abonnementsoortVrijCode4) || (is_array($abonnementsoortVrijCode4) && empty($abonnementsoortVrijCode4))) {
            unset($this->abonnementsoortVrijCode4);
        } else {
            $this->abonnementsoortVrijCode4 = $abonnementsoortVrijCode4;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode5()
    {
        return isset($this->abonnementsoortVrijCode5) ? $this->abonnementsoortVrijCode5 : null;
    }
    /**
     * Set abonnementsoortVrijCode5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode5
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode5(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode5 = null)
    {
        if (is_null($abonnementsoortVrijCode5) || (is_array($abonnementsoortVrijCode5) && empty($abonnementsoortVrijCode5))) {
            unset($this->abonnementsoortVrijCode5);
        } else {
            $this->abonnementsoortVrijCode5 = $abonnementsoortVrijCode5;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode6()
    {
        return isset($this->abonnementsoortVrijCode6) ? $this->abonnementsoortVrijCode6 : null;
    }
    /**
     * Set abonnementsoortVrijCode6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode6
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode6(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode6 = null)
    {
        if (is_null($abonnementsoortVrijCode6) || (is_array($abonnementsoortVrijCode6) && empty($abonnementsoortVrijCode6))) {
            unset($this->abonnementsoortVrijCode6);
        } else {
            $this->abonnementsoortVrijCode6 = $abonnementsoortVrijCode6;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode7()
    {
        return isset($this->abonnementsoortVrijCode7) ? $this->abonnementsoortVrijCode7 : null;
    }
    /**
     * Set abonnementsoortVrijCode7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode7
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode7(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode7 = null)
    {
        if (is_null($abonnementsoortVrijCode7) || (is_array($abonnementsoortVrijCode7) && empty($abonnementsoortVrijCode7))) {
            unset($this->abonnementsoortVrijCode7);
        } else {
            $this->abonnementsoortVrijCode7 = $abonnementsoortVrijCode7;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode8()
    {
        return isset($this->abonnementsoortVrijCode8) ? $this->abonnementsoortVrijCode8 : null;
    }
    /**
     * Set abonnementsoortVrijCode8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode8
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode8(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode8 = null)
    {
        if (is_null($abonnementsoortVrijCode8) || (is_array($abonnementsoortVrijCode8) && empty($abonnementsoortVrijCode8))) {
            unset($this->abonnementsoortVrijCode8);
        } else {
            $this->abonnementsoortVrijCode8 = $abonnementsoortVrijCode8;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode9()
    {
        return isset($this->abonnementsoortVrijCode9) ? $this->abonnementsoortVrijCode9 : null;
    }
    /**
     * Set abonnementsoortVrijCode9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode9
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode9(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode9 = null)
    {
        if (is_null($abonnementsoortVrijCode9) || (is_array($abonnementsoortVrijCode9) && empty($abonnementsoortVrijCode9))) {
            unset($this->abonnementsoortVrijCode9);
        } else {
            $this->abonnementsoortVrijCode9 = $abonnementsoortVrijCode9;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijVeldCode|null
     */
    public function getAbonnementsoortVrijCode10()
    {
        return isset($this->abonnementsoortVrijCode10) ? $this->abonnementsoortVrijCode10 : null;
    }
    /**
     * Set abonnementsoortVrijCode10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode10
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortVrijCode10(\AbonnementApiV6\StructType\VrijVeldCode $abonnementsoortVrijCode10 = null)
    {
        if (is_null($abonnementsoortVrijCode10) || (is_array($abonnementsoortVrijCode10) && empty($abonnementsoortVrijCode10))) {
            unset($this->abonnementsoortVrijCode10);
        } else {
            $this->abonnementsoortVrijCode10 = $abonnementsoortVrijCode10;
        }
        return $this;
    }
    /**
     * Get abonnementsoortActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAbonnementsoortActief()
    {
        return isset($this->abonnementsoortActief) ? $this->abonnementsoortActief : null;
    }
    /**
     * Set abonnementsoortActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $abonnementsoortActief
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setAbonnementsoortActief($abonnementsoortActief = null)
    {
        // validation for constraint: boolean
        if (!is_null($abonnementsoortActief) && !is_bool($abonnementsoortActief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abonnementsoortActief, true), gettype($abonnementsoortActief)), __LINE__);
        }
        if (is_null($abonnementsoortActief) || (is_array($abonnementsoortActief) && empty($abonnementsoortActief))) {
            unset($this->abonnementsoortActief);
        } else {
            $this->abonnementsoortActief = $abonnementsoortActief;
        }
        return $this;
    }
    /**
     * Get organisatieLicentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganisatieLicentie()
    {
        return isset($this->organisatieLicentie) ? $this->organisatieLicentie : null;
    }
    /**
     * Set organisatieLicentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organisatieLicentie
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setOrganisatieLicentie($organisatieLicentie = null)
    {
        // validation for constraint: boolean
        if (!is_null($organisatieLicentie) && !is_bool($organisatieLicentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organisatieLicentie, true), gettype($organisatieLicentie)), __LINE__);
        }
        if (is_null($organisatieLicentie) || (is_array($organisatieLicentie) && empty($organisatieLicentie))) {
            unset($this->organisatieLicentie);
        } else {
            $this->organisatieLicentie = $organisatieLicentie;
        }
        return $this;
    }
    /**
     * Get buitenland value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBuitenland()
    {
        return isset($this->buitenland) ? $this->buitenland : null;
    }
    /**
     * Set buitenland value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $buitenland
     * @return \AbonnementApiV6\StructType\Abonnementsoort
     */
    public function setBuitenland($buitenland = null)
    {
        // validation for constraint: boolean
        if (!is_null($buitenland) && !is_bool($buitenland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($buitenland, true), gettype($buitenland)), __LINE__);
        }
        if (is_null($buitenland) || (is_array($buitenland) && empty($buitenland))) {
            unset($this->buitenland);
        } else {
            $this->buitenland = $buitenland;
        }
        return $this;
    }
}
