<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementTab StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst abonnementen.
 * @subpackage Structs
 * @date 20240419 package
 */
class AbonnementTab extends AbstractStructBase
{
    /**
     * The abonnement
     * Meta information extracted from the WSDL
     * - documentation: Lijst abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Abonnement[]
     */
    public $abonnement;
    /**
     * Constructor method for AbonnementTab
     * @uses AbonnementTab::setAbonnement()
     * @param \AbonnementApiV6\StructType\Abonnement[] $abonnement
     */
    public function __construct(array $abonnement = array())
    {
        $this
            ->setAbonnement($abonnement);
    }
    /**
     * Get abonnement value
     * @return \AbonnementApiV6\StructType\Abonnement[]|null
     */
    public function getAbonnement()
    {
        return $this->abonnement;
    }
    /**
     * This method is responsible for validating the values passed to the setAbonnement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbonnement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbonnementForArrayConstraintsFromSetAbonnement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abonnementTabAbonnementItem) {
            // validation for constraint: itemType
            if (!$abonnementTabAbonnementItem instanceof \AbonnementApiV6\StructType\Abonnement) {
                $invalidValues[] = is_object($abonnementTabAbonnementItem) ? get_class($abonnementTabAbonnementItem) : sprintf('%s(%s)', gettype($abonnementTabAbonnementItem), var_export($abonnementTabAbonnementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abonnement property can only contain items of type \AbonnementApiV6\StructType\Abonnement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abonnement value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Abonnement[] $abonnement
     * @return \AbonnementApiV6\StructType\AbonnementTab
     */
    public function setAbonnement(array $abonnement = array())
    {
        // validation for constraint: array
        if ('' !== ($abonnementArrayErrorMessage = self::validateAbonnementForArrayConstraintsFromSetAbonnement($abonnement))) {
            throw new \InvalidArgumentException($abonnementArrayErrorMessage, __LINE__);
        }
        $this->abonnement = $abonnement;
        return $this;
    }
    /**
     * Add item to abonnement value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Abonnement $item
     * @return \AbonnementApiV6\StructType\AbonnementTab
     */
    public function addToAbonnement(\AbonnementApiV6\StructType\Abonnement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Abonnement) {
            throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of type \AbonnementApiV6\StructType\Abonnement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abonnement[] = $item;
        return $this;
    }
}
